package jp.ito.camera;

import java.util.Properties;

import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;

import android.util.Log;

public class MailService {
	private static final String TAG = CameraService.class.getSimpleName();
	public volatile String _address = "foo@aaa.com";
	public volatile String _password = "";
	public volatile String _host = "smtp.gmail.com";
	public volatile String _port = "587";
	private MainService _mainService = null;

	public MailService(MainService mainService){
		_mainService = mainService;
	}

	public void status(String msg1, String msg2){
		StatusMailThread th = new StatusMailThread(msg1, msg2);
		th.start();
	}
	public void photo(String strFile){
		PhotoMailThread th = new PhotoMailThread(strFile);
		th.start();
	}
	/**
	 * 
	 * @return
	 */
	private Session createSendGMailSession() {
		Properties props = new Properties();
		props.put("mail.smtp.host", _host); // SMTPT[o
		props.put("mail.host", _host); // ڑzXg
		props.put("mail.smtp.port", _port); // SMTPT[o|[g
		props.put("mail.smtp.auth", "true"); // smtp auth
		props.put("mail.smtp.starttls.enable", "true"); // STTLS

		// ZbV
		Session session = Session.getDefaultInstance(props);
		session.setDebug(true);
		return session;
	}
	/**
	 * 
	 * @param msg
	 * @param session
	 * @throws MessagingException
	 */
	private void sendGmail(MimeMessage msg, Session session) throws MessagingException {
		try {
			Transport t = session.getTransport("smtp");
			t.connect(_address, _password);
			t.sendMessage(msg, msg.getAllRecipients());
		} catch (Exception e) {
			e.printStackTrace();
			Log.e(TAG, "send mail failer." + e.getMessage());
			_mainService.toast("send mail failer:" + e.getMessage());
		}
	}

	class PhotoMailThread extends Thread {
		String _strFile;
		PhotoMailThread(String strFile){
			 _strFile = strFile;
		}
		public void run(){
			try {
//				Properties props = new Properties();
//				Session session = Session.getDefaultInstance(props);
				Session session = createSendGMailSession();
				MimeMessage msg = new MimeMessage(session);

				msg.setSubject("Android̉摜ł", "shift-jis");
				msg.setFrom(new InternetAddress(_address));
				msg.setSender(new InternetAddress(_address));
				msg.setRecipient(Message.RecipientType.TO, new InternetAddress(_address));

				// mixed
				Multipart mixedPart = new MimeMultipart("mixed");

				// alternative
				MimeBodyPart alternativeBodyPart = new MimeBodyPart();
				Multipart alternativePart = new MimeMultipart("alternative");
				alternativeBodyPart.setContent(alternativePart);
				mixedPart.addBodyPart(alternativeBodyPart);

				// text mail
				MimeBodyPart textBodyPart = new MimeBodyPart();
				textBodyPart.setText("Be摜ł", "shift-jis", "plain");
				textBodyPart.setHeader("Content-Transfer-Encoding", "base64");
				alternativePart.addBodyPart(textBodyPart);	// alter

				// related
				MimeBodyPart relatedBodyPart = new MimeBodyPart();
				Multipart relatedPart = new MimeMultipart("related");
				relatedBodyPart.setContent(relatedPart);
				alternativePart.addBodyPart(relatedBodyPart);

				// html mail
				MimeBodyPart htmlBodyPart = new MimeBodyPart();
				htmlBodyPart.setText("<HTML><BODY>Be摜ł<IMG src=\"cid:12345@12345\"></BODY></HTML>", "shift-jis", "html");
				htmlBodyPart.setHeader("Content-Transfer-Encoding", "base64");
				relatedPart.addBodyPart(htmlBodyPart);

				// inline image
				MimeBodyPart imageBodyPart = new MimeBodyPart();
				DataSource dataSource1 = new FileDataSource(_strFile);
				DataHandler dataHandler1 = new DataHandler(dataSource1);
				imageBodyPart.setDataHandler(dataHandler1);
				imageBodyPart.setFileName(MimeUtility.encodeWord("sample.jpg"));
				imageBodyPart.setDisposition("inline");	    // inlinew肵Ă
				imageBodyPart.setContentID("12345@12345");  // CC摜w
				relatedPart.addBodyPart(imageBodyPart);

				// set misedPart
				msg.setContent(mixedPart);

				sendGmail(msg, session);
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}
	class StatusMailThread extends Thread {
		String _str1;
		String _str2;
		StatusMailThread(String str1, String str2){
			 _str1 = str1;
			 _str2 = str2;
		}
		public void run(){
			try {
				Session session = createSendGMailSession();
				MimeMessage msg = new MimeMessage(session);

				msg.setSubject("Android̏Ԃł", "shift-jis");
				msg.setFrom(new InternetAddress(_address));
				msg.setSender(new InternetAddress(_address));
				msg.setRecipient(Message.RecipientType.TO, new InternetAddress(_address));

				// mixed
				Multipart mixedPart = new MimeMultipart("mixed");

				// alternative
				MimeBodyPart alternativeBodyPart = new MimeBodyPart();
				Multipart alternativePart = new MimeMultipart("alternative");
				alternativeBodyPart.setContent(alternativePart);
				mixedPart.addBodyPart(alternativeBodyPart);

				// text mail
				MimeBodyPart textBodyPart = new MimeBodyPart();
				textBodyPart.setText(_str1+_str2, "shift-jis", "plain");
				textBodyPart.setHeader("Content-Transfer-Encoding", "base64");
				alternativePart.addBodyPart(textBodyPart);	// alter

				msg.setContent(mixedPart);

				sendGmail(msg, session);
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}
}
