/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.awt.datatransfer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.SystemFlavorMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.harmony.awt.datatransfer.DataProvider;
import org.apache.harmony.awt.datatransfer.RawBitmap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSnapshot
implements DataProvider {
    private final String text;
    private final String[] fileList;
    private final String url;
    private final String html;
    private final RawBitmap rawBitmap;
    private final String[] nativeFormats;
    private final Map<Class<?>, byte[]> serializedObjects;

    public DataSnapshot(DataProvider data) {
        this.nativeFormats = data.getNativeFormats();
        this.text = data.getText();
        this.fileList = data.getFileList();
        this.url = data.getURL();
        this.html = data.getHTML();
        this.rawBitmap = data.getRawBitmap();
        this.serializedObjects = Collections.synchronizedMap(new HashMap());
        int i = 0;
        while (i < this.nativeFormats.length) {
            Class<?> clazz;
            byte[] bytes;
            DataFlavor df = null;
            try {
                df = SystemFlavorMap.decodeDataFlavor(this.nativeFormats[i]);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (df != null && (bytes = data.getSerializedObject(clazz = df.getRepresentationClass())) != null) {
                this.serializedObjects.put(clazz, bytes);
            }
            ++i;
        }
    }

    @Override
    public boolean isNativeFormatAvailable(String nativeFormat) {
        if (nativeFormat == null) {
            return false;
        }
        if (nativeFormat.equals("text/plain")) {
            return this.text != null;
        }
        if (nativeFormat.equals("application/x-java-file-list")) {
            return this.fileList != null;
        }
        if (nativeFormat.equals("application/x-java-url")) {
            return this.url != null;
        }
        if (nativeFormat.equals("text/html")) {
            return this.html != null;
        }
        if (nativeFormat.equals("image/x-java-image")) {
            return this.rawBitmap != null;
        }
        try {
            DataFlavor df = SystemFlavorMap.decodeDataFlavor(nativeFormat);
            return this.serializedObjects.containsKey(df.getRepresentationClass());
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public String[] getFileList() {
        return this.fileList;
    }

    @Override
    public String getURL() {
        return this.url;
    }

    @Override
    public String getHTML() {
        return this.html;
    }

    @Override
    public RawBitmap getRawBitmap() {
        return this.rawBitmap;
    }

    public int[] getRawBitmapHeader() {
        return this.rawBitmap != null ? this.rawBitmap.getHeader() : null;
    }

    public byte[] getRawBitmapBuffer8() {
        return this.rawBitmap != null && this.rawBitmap.buffer instanceof byte[] ? (byte[])this.rawBitmap.buffer : null;
    }

    public short[] getRawBitmapBuffer16() {
        return this.rawBitmap != null && this.rawBitmap.buffer instanceof short[] ? (short[])this.rawBitmap.buffer : null;
    }

    public int[] getRawBitmapBuffer32() {
        return this.rawBitmap != null && this.rawBitmap.buffer instanceof int[] ? (int[])this.rawBitmap.buffer : null;
    }

    @Override
    public byte[] getSerializedObject(Class<?> clazz) {
        return this.serializedObjects.get(clazz);
    }

    public byte[] getSerializedObject(String nativeFormat) {
        try {
            DataFlavor df = SystemFlavorMap.decodeDataFlavor(nativeFormat);
            return this.getSerializedObject(df.getRepresentationClass());
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String[] getNativeFormats() {
        return this.nativeFormats;
    }
}

