/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap.protocol;

import java.util.Vector;

public class UIDSet {
    public long start;
    public long end;

    public UIDSet() {
    }

    public UIDSet(long start, long end) {
        this.start = start;
        this.end = end;
    }

    public long size() {
        return this.end - this.start + 1L;
    }

    public static UIDSet[] createUIDSets(long[] msgs) {
        Vector<UIDSet> v = new Vector<UIDSet>();
        int i = 0;
        while (i < msgs.length) {
            UIDSet ms = new UIDSet();
            ms.start = msgs[i];
            int j = i + 1;
            while (j < msgs.length) {
                if (msgs[j] != msgs[j - 1] + 1L) break;
                ++j;
            }
            ms.end = msgs[j - 1];
            v.addElement(ms);
            i = j - 1;
            ++i;
        }
        Object[] msgsets = new UIDSet[v.size()];
        v.copyInto(msgsets);
        return msgsets;
    }

    public static String toString(UIDSet[] msgsets) {
        if (msgsets == null || msgsets.length == 0) {
            return null;
        }
        int i = 0;
        StringBuffer s = new StringBuffer();
        int size = msgsets.length;
        while (true) {
            long start;
            long end;
            if ((end = msgsets[i].end) > (start = msgsets[i].start)) {
                s.append(start).append(':').append(end);
            } else {
                s.append(start);
            }
            if (++i >= size) break;
            s.append(',');
        }
        return s.toString();
    }

    public static long size(UIDSet[] msgsets) {
        long count = 0L;
        if (msgsets == null) {
            return 0L;
        }
        int i = 0;
        while (i < msgsets.length) {
            count += msgsets[i].size();
            ++i;
        }
        return count;
    }
}

