package com.hide.ServiceTest;

import android.app.Service;
import android.content.Intent;
import android.net.Uri;
import android.os.IBinder;
import android.util.Log;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;

// 同期処理サービス
public class MyService extends Service {

  final static String TAG = "MyService";

	int nId = R.string.app_name;

	// NotificationManagerのインスタンスを取得する。コンストラクタはなし。
	private NotificationManager nm;
	@Override
  public IBinder onBind(Intent intent) {
    return null;
  }

  @Override
  public void onCreate() {
    super.onCreate();
    Log.d(TAG, "onCreate");
  }

  @Override
  public int onStartCommand(Intent intent, int flags, int startId) {
    Log.d(TAG, "onStartCommand");

    nm = (NotificationManager)getSystemService(NOTIFICATION_SERVICE);
	// Notificationのインスタンスを生成する。
    Notification n;
	// 表示させるアイコンのリソースID、
	// ステータスバーにアイコンが表示される直前にちょっとだけ表示されるテキスト、
	// ステータスバーを引っ張ったときに表示させる時刻を指定する。
    n = new Notification(R.drawable.icon, "通知情報が届きました", System.currentTimeMillis());

	// 「通知」ではなく「実行中」として表示する
	// n.flags = Notification.FLAG_ONGOING_EVENT;
	// Notification表示時に振動
	// n.defaults |= Notification.DEFAULT_VIBRATE;
	// Notification表示時に音を鳴らす
	// n.sound = Uri.parse(ringtoneStr);

	// Notificationをタップしたときに起動するアクティビティを指定するIntentを生成し、PendingIntentに放り込む。
	// Intent i = new Intent(this, com.example.hogehoge.Hogehoge.class);
	Intent i = new Intent(android.content.Intent.ACTION_VIEW, Uri.parse("http://www.google.co.jp"));
	PendingIntent pi;
	pi = PendingIntent.getActivity(this, 0, i, Intent.FLAG_ACTIVITY_NEW_TASK);

	// NotificationのインスタンスにsetLatestEventInfoメソッドを使ってセットする。
	// このとき、ステータスバーを引っ張ったときにNotificationの中で表示されるタイトルとテキストを指定する。
	n.setLatestEventInfo(this, "サービス開始", "タイマーを開始しました", pi);

	// NotificationのIDを指定してnotifyする。
	// IDはintなら何でもいい
	// nm.notify(nId, n);
	nm.notify(1, n);

	try {
		// 10秒間停止
		// sleepを使用した場合、サービス起動元がブロックされる
		Thread.sleep(10000);
	} catch (InterruptedException e) {
		// TODO 自動生成された catch ブロック
		e.printStackTrace();
	}

    Notification n2;
    n2 = new Notification(R.drawable.icon, "タイマー通知だよ", System.currentTimeMillis());
	n2.setLatestEventInfo(this, "タイマー通知", "指定時間たったよ", pi);
	// NotificationのIDを指定してnotifyする。
	// IDはintなら何でもいい
	nm.notify(2, n2);

    return START_STICKY;
  }

  @Override
  public void onDestroy() {
    super.onDestroy();
    Log.d(TAG, "onDestroy");

	// Notificationを消す場合、cancelメソッドを使う。
	//nm.cancel(nId);
	nm.cancel(1);
	nm.cancel(2);
	// 全てのNotificationをまとめて消す
	// nm.cancelAll();
  }

}
