/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.client.async;

import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.WebServiceException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.async.AsyncResult;
import org.apache.axis2.client.async.Callback;
import org.apache.axis2.jaxws.client.async.AsyncUtils;
import org.apache.axis2.jaxws.client.async.CallbackFutureTask;
import org.apache.axis2.jaxws.core.InvocationContext;
import org.apache.axis2.jaxws.core.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallbackFuture
extends Callback {
    private static final Log log = LogFactory.getLog(CallbackFuture.class);
    private static final boolean debug = log.isDebugEnabled();
    private CallbackFutureTask cft;
    private Executor executor;
    private FutureTask task;
    private InvocationContext invocationCtx;

    public CallbackFuture(InvocationContext ic, AsyncHandler handler) {
        this.cft = new CallbackFutureTask(ic.getAsyncResponseListener(), handler);
        this.task = new FutureTask(this.cft);
        this.executor = ic.getExecutor();
        this.invocationCtx = ic;
    }

    public Future<?> getFutureTask() {
        return this.task;
    }

    public void onComplete(AsyncResult result) {
        MessageContext response;
        block4: {
            if (debug) {
                log.debug((Object)"JAX-WS received the async response");
            }
            response = null;
            try {
                response = AsyncUtils.createJAXWSMessageContext(result);
                response.setInvocationContext(this.invocationCtx);
                response.setMEPContext(this.invocationCtx.getRequestMessageContext().getMEPContext());
            }
            catch (WebServiceException e) {
                this.cft.setError((Exception)((Object)e));
                if (!debug) break block4;
                log.debug((Object)("An error occured while processing the async response.  " + e.getMessage()));
            }
        }
        if (response == null) {
            // empty if block
        }
        this.cft.setMessageContext(response);
        this.execute();
    }

    public void onError(Exception e) {
        if (e.getClass().isAssignableFrom(AxisFault.class)) {
            AxisFault fault = (AxisFault)((Object)e);
            MessageContext faultMessageContext = null;
            try {
                faultMessageContext = AsyncUtils.createJAXWSMessageContext(fault.getFaultMessageContext());
                faultMessageContext.setInvocationContext(this.invocationCtx);
                faultMessageContext.setMEPContext(this.invocationCtx.getRequestMessageContext().getMEPContext());
            }
            catch (WebServiceException wse) {
                this.cft.setError((Exception)((Object)wse));
            }
            this.cft.setError(e);
            this.cft.setMessageContext(faultMessageContext);
        } else {
            this.cft.setError(e);
        }
        this.execute();
    }

    private void execute() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Executor task starting to process async response");
        }
        if (this.executor != null) {
            if (this.task != null && !this.task.isCancelled()) {
                try {
                    this.executor.execute(this.task);
                }
                catch (Exception executorExc) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("CallbackFuture.execute():  executor exception [" + executorExc.getClass().getName() + "]"));
                    }
                    this.task.cancel(true);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Task submitted to Executor");
                }
            } else if (log.isDebugEnabled()) {
                log.info((Object)"Executor task was not sumbitted as Async Future task was cancelled by clients");
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Executor task completed");
        }
    }
}

