/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.server.dispatcher;

import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.core.MessageContext;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.server.dispatcher.EndpointDispatcher;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class JavaDispatcher
implements EndpointDispatcher {
    private static final Log log = LogFactory.getLog(JavaDispatcher.class);
    protected Class serviceImplClass;
    protected Object serviceInstance;

    protected JavaDispatcher(Class impl, Object serviceInstance) {
        this.serviceImplClass = impl;
        this.serviceInstance = serviceInstance;
    }

    public abstract MessageContext invoke(MessageContext var1) throws Exception;

    public Class getServiceImplementationClass() {
        return this.serviceImplClass;
    }

    protected Object createServiceInstance() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Creating new instance of service endpoint");
        }
        if (this.serviceImplClass == null) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"JavaDispErr1"));
        }
        Object instance = null;
        try {
            instance = this.serviceImplClass.newInstance();
        }
        catch (IllegalAccessException e) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"JavaDispErr2", (String)this.serviceImplClass.getName()));
        }
        catch (InstantiationException e) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"JavaDispErr2", (String)this.serviceImplClass.getName()));
        }
        return instance;
    }
}

