/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.woden.ErrorHandler;
import org.apache.woden.ErrorLocator;
import org.apache.woden.WSDLException;
import org.apache.woden.WSDLFactory;
import org.apache.woden.WSDLSource;
import org.apache.woden.XMLElement;
import org.apache.woden.internal.BaseWSDLReader;
import org.apache.woden.internal.ErrorLocatorImpl;
import org.apache.woden.internal.OMXMLElement;
import org.apache.woden.internal.resolver.OMSchemaResolverAdapter;
import org.apache.woden.internal.schema.ImportedSchemaImpl;
import org.apache.woden.internal.schema.InlinedSchemaImpl;
import org.apache.woden.internal.util.StringUtils;
import org.apache.woden.internal.util.om.OMQNameUtils;
import org.apache.woden.internal.util.om.OMUtils;
import org.apache.woden.internal.wsdl20.Constants;
import org.apache.woden.schema.Schema;
import org.apache.woden.wsdl20.Description;
import org.apache.woden.wsdl20.xml.DescriptionElement;
import org.apache.woden.wsdl20.xml.WSDLElement;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.XmlSchemaException;
import org.apache.ws.commons.schema.resolver.URIResolver;
import org.apache.ws.commons.schema.utils.NamespaceMap;
import org.apache.ws.commons.schema.utils.NamespacePrefixList;
import org.xml.sax.InputSource;

public class OMWSDLReader
extends BaseWSDLReader {
    private Map fImportedSchemas = new Hashtable();

    OMWSDLReader(WSDLFactory factory) throws WSDLException {
        super(factory);
    }

    public Description readWSDL(String wsdlURI) throws WSDLException {
        URL url;
        try {
            url = StringUtils.getURL(null, wsdlURI);
        }
        catch (MalformedURLException e) {
            String msg = this.getErrorReporter().getFormattedMessage("WSDL502", new Object[]{null, wsdlURI});
            throw new WSDLException("PARSER_ERROR", msg, e);
        }
        String wsdlURL = url.toString();
        OMElement wsdlDescription = null;
        try {
            wsdlDescription = OMUtils.getElement(this.resolveURI(wsdlURL));
        }
        catch (IOException e) {
            String msg = this.getErrorReporter().getFormattedMessage("WSDL503", new Object[]{wsdlURL});
            throw new WSDLException("PARSER_ERROR", msg, e);
        }
        XMLElement descEl = this.createXMLElement(wsdlDescription);
        DescriptionElement descElem = this.parseDescription(url.toString(), descEl, null);
        return descElem.toComponent();
    }

    protected Schema parseSchemaImport(XMLElement importEl, DescriptionElement desc) throws WSDLException {
        String sloc;
        ImportedSchemaImpl schema = new ImportedSchemaImpl();
        String ns = importEl.getAttributeValue("namespace");
        if (ns != null) {
            schema.setNamespace(this.getURI(ns));
        }
        if ((sloc = importEl.getAttributeValue("schemaLocation")) != null) {
            schema.setSchemaLocation(this.getURI(sloc));
        }
        if (schema.getNamespace() == null) {
            schema.setReferenceable(false);
            return schema;
        }
        if (schema.getSchemaLocation() == null) {
            return schema;
        }
        OMElement importedSchemaDoc = null;
        URI contextURI = null;
        String schemaLoc = null;
        URL url = null;
        try {
            contextURI = this.resolveURI(desc.getDocumentBaseURI());
            URL contextURL = contextURI != null ? contextURI.toURL() : null;
            schemaLoc = schema.getSchemaLocation().toString();
            url = StringUtils.getURL(contextURL, schemaLoc);
        }
        catch (MalformedURLException e) {
            String baseLoc = contextURI != null ? contextURI.toString() : null;
            this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL502", new Object[]{baseLoc, schemaLoc}, (short)2);
            schema.setReferenceable(false);
            return schema;
        }
        String schemaURL = url.toString();
        XmlSchema schemaDef = (XmlSchema)this.fImportedSchemas.get(schemaURL);
        if (schemaDef == null) {
            try {
                importedSchemaDoc = OMUtils.getElement(schemaURL);
            }
            catch (IOException e4) {
                this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL504", new Object[]{schemaURL}, (short)1, (Exception)e4);
                schema.setReferenceable(false);
                return schema;
            }
            String schemaElStr = null;
            try {
                schemaElStr = importedSchemaDoc.toStringWithConsume();
            }
            catch (XMLStreamException e) {
                e.printStackTrace();
            }
            byte[] schemaElbytes = schemaElStr.getBytes();
            InputSource schemaSource = new InputSource(new ByteArrayInputStream(schemaElbytes));
            schemaSource.setSystemId(schemaURL);
            try {
                XmlSchemaCollection xsc = new XmlSchemaCollection();
                xsc.setSchemaResolver((URIResolver)new OMSchemaResolverAdapter(this.getURIResolver(), importEl));
                schemaDef = xsc.read(schemaSource, null);
                this.fImportedSchemas.put(schemaURL, schemaDef);
            }
            catch (XmlSchemaException e) {
                this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL522", new Object[]{schemaURL}, (short)1, (Exception)((Object)e));
            }
        }
        if (schemaDef != null) {
            schema.setSchemaDefinition(schemaDef);
        } else {
            schema.setReferenceable(false);
        }
        return schema;
    }

    protected Schema parseSchemaInline(XMLElement schemaElement, DescriptionElement desc) throws WSDLException {
        InlinedSchemaImpl schema = new InlinedSchemaImpl();
        schema.setId(schemaElement.getAttributeValue("id"));
        String tns = schemaElement.getAttributeValue("targetNamespace");
        if (tns != null) {
            schema.setNamespace(this.getURI(tns));
        }
        String baseURI = desc.getDocumentBaseURI() != null ? desc.getDocumentBaseURI().toString() : null;
        XmlSchema schemaDef = null;
        try {
            OMElement omSchemaElem = (OMElement)schemaElement.getSource();
            InputSource schemaSource = OMUtils.getInputSource(omSchemaElem);
            XmlSchemaCollection xsc = new XmlSchemaCollection();
            xsc.setBaseUri(baseURI);
            NamespaceMap namespaces = new NamespaceMap(desc.getNamespaces());
            xsc.setNamespaceContext((NamespacePrefixList)namespaces);
            xsc.setSchemaResolver((URIResolver)new OMSchemaResolverAdapter(this.getURIResolver(), schemaElement));
            schemaDef = xsc.read(schemaSource, null);
        }
        catch (XmlSchemaException e) {
            this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL521", new Object[]{baseURI}, (short)1, (Exception)((Object)e));
        }
        catch (RuntimeException e) {
            this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL521", new Object[]{baseURI}, (short)2, (Exception)e);
        }
        if (schemaDef != null) {
            schema.setSchemaDefinition(schemaDef);
        } else {
            schema.setReferenceable(false);
        }
        return schema;
    }

    protected void parseExtensionAttributes(XMLElement domEl, Class wsdlClass, WSDLElement wsdlObj, DescriptionElement desc) throws WSDLException {
    }

    public Description readWSDL(String wsdlURI, ErrorHandler errorHandler) throws WSDLException {
        if (errorHandler != null) {
            this.getErrorReporter().setErrorHandler(errorHandler);
        }
        return this.readWSDL(wsdlURI);
    }

    public Description readWSDL(WSDLSource wsdlSource) throws WSDLException {
        return null;
    }

    public Description readWSDL(WSDLSource wsdlSource, ErrorHandler errorHandler) throws WSDLException {
        return null;
    }

    protected DescriptionElement getWSDLFromLocation(String locationURI, DescriptionElement desc, Map wsdlModules) throws WSDLException {
        DescriptionElement referencedDesc = null;
        URL locationURL = null;
        URI contextURI = null;
        try {
            contextURI = this.resolveURI(desc.getDocumentBaseURI());
            URL contextURL = contextURI != null ? contextURI.toURL() : null;
            locationURL = StringUtils.getURL(contextURL, locationURI);
        }
        catch (MalformedURLException e) {
            String baseURI = contextURI != null ? contextURI.toString() : null;
            this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL502", new Object[]{baseURI, locationURI}, (short)2);
            return null;
        }
        String locationStr = locationURL.toString();
        referencedDesc = (DescriptionElement)wsdlModules.get(locationStr);
        if (referencedDesc == null) {
            OMElement docEl;
            try {
                docEl = OMUtils.getElement(locationStr);
            }
            catch (IOException e) {
                this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL503", new Object[]{locationStr}, (short)1, (Exception)e);
                return null;
            }
            if (!OMQNameUtils.matches(Constants.Q_ELEM_DESCRIPTION, docEl)) {
                this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL501", new Object[]{Constants.Q_ELEM_DESCRIPTION, OMQNameUtils.newQName(docEl)}, (short)2);
                return null;
            }
            XMLElement descEl = this.createXMLElement(docEl);
            referencedDesc = this.parseDescription(locationStr, descEl, wsdlModules);
            if (!wsdlModules.containsKey(locationStr)) {
                wsdlModules.put(locationStr, referencedDesc);
            }
        }
        return referencedDesc;
    }

    public WSDLSource createWSDLSource() {
        return null;
    }

    protected XMLElement createXMLElement(Object elem) {
        OMXMLElement omXMLElement = new OMXMLElement(this.getErrorReporter());
        omXMLElement.setSource(elem);
        return omXMLElement;
    }

    protected void parseNamespaceDeclarations(XMLElement xmlElem, WSDLElement wsdlElem) throws WSDLException {
        OMElement omDescription = (OMElement)xmlElem.getSource();
        DescriptionElement desc = (DescriptionElement)wsdlElem;
        Iterator namespaces = omDescription.getAllDeclaredNamespaces();
        while (namespaces.hasNext()) {
            OMNamespace namespace = (OMNamespace)namespaces.next();
            String localPart = namespace.getPrefix();
            String value = namespace.getNamespaceURI();
            if (!"xmlns".equals(localPart)) {
                desc.addNamespace(localPart, this.getURI(value));
                continue;
            }
            desc.addNamespace(null, this.getURI(value));
        }
    }
}

