/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden.internal.wsdl20.extensions.soap;

import java.net.URI;
import org.apache.woden.internal.wsdl20.extensions.ComponentExtensionsImpl;
import org.apache.woden.internal.wsdl20.extensions.http.HTTPConstants;
import org.apache.woden.internal.wsdl20.extensions.soap.SOAPConstants;
import org.apache.woden.wsdl20.Binding;
import org.apache.woden.wsdl20.BindingOperation;
import org.apache.woden.wsdl20.NestedComponent;
import org.apache.woden.wsdl20.extensions.ComponentExtensions;
import org.apache.woden.wsdl20.extensions.ExtensionElement;
import org.apache.woden.wsdl20.extensions.http.HTTPHeader;
import org.apache.woden.wsdl20.extensions.soap.SOAPBindingExtensions;
import org.apache.woden.wsdl20.extensions.soap.SOAPBindingMessageReferenceExtensions;
import org.apache.woden.wsdl20.extensions.soap.SOAPHeaderBlock;
import org.apache.woden.wsdl20.extensions.soap.SOAPModule;
import org.apache.woden.wsdl20.xml.WSDLElement;
import org.apache.woden.xml.StringAttr;

public class SOAPBindingMessageReferenceExtensionsImpl
extends ComponentExtensionsImpl
implements SOAPBindingMessageReferenceExtensions {
    public SOAPModule[] getSoapModules() {
        ExtensionElement[] extEls = this.fParentElement.getExtensionElementsOfType(SOAPConstants.Q_ELEM_SOAP_MODULE);
        int len = extEls.length;
        SOAPModule[] soapMods = new SOAPModule[len];
        System.arraycopy(extEls, 0, soapMods, 0, len);
        return soapMods;
    }

    public SOAPHeaderBlock[] getSoapHeaders() {
        ExtensionElement[] extEls = this.fParentElement.getExtensionElementsOfType(SOAPConstants.Q_ELEM_SOAP_HEADER);
        int len = extEls.length;
        SOAPHeaderBlock[] soapHeaders = new SOAPHeaderBlock[len];
        System.arraycopy(extEls, 0, soapHeaders, 0, len);
        return soapHeaders;
    }

    public String getHttpContentEncoding() {
        BindingOperation bindingOp = (BindingOperation)((NestedComponent)this.fParent).getParent();
        Binding binding = (Binding)bindingOp.getParent();
        SOAPBindingExtensions soapBindExt = (SOAPBindingExtensions)binding.getComponentExtensionsForNamespace(ComponentExtensions.URI_NS_SOAP);
        String version = soapBindExt.getSoapVersion();
        URI protocol = soapBindExt.getSoapUnderlyingProtocol();
        if (protocol == null) {
            return null;
        }
        if ("1.2".equals(version) && protocol.toString().equals("http://www.w3.org/2003/05/soap/bindings/HTTP/") || "1.1".equals(version) && protocol.toString().equals("http://www.w3.org/2006/01/soap11/bindings/HTTP/")) {
            StringAttr contEncoding = (StringAttr)((WSDLElement)((Object)this.fParent)).getExtensionAttribute(HTTPConstants.Q_ATTR_CONTENT_ENCODING);
            return contEncoding != null ? contEncoding.getString() : null;
        }
        return null;
    }

    public HTTPHeader[] getHttpHeaders() {
        BindingOperation bindingOp = (BindingOperation)((NestedComponent)this.fParent).getParent();
        Binding binding = (Binding)bindingOp.getParent();
        SOAPBindingExtensions soapBindExt = (SOAPBindingExtensions)binding.getComponentExtensionsForNamespace(ComponentExtensions.URI_NS_SOAP);
        String version = soapBindExt.getSoapVersion();
        URI protocol = soapBindExt.getSoapUnderlyingProtocol();
        if (protocol == null) {
            return new HTTPHeader[0];
        }
        if ("1.2".equals(version) && protocol.toString().equals("http://www.w3.org/2003/05/soap/bindings/HTTP/") || "1.1".equals(version) && protocol.toString().equals("http://www.w3.org/2006/01/soap11/bindings/HTTP/")) {
            ExtensionElement[] extEls = ((WSDLElement)((Object)this.fParent)).getExtensionElementsOfType(HTTPConstants.Q_ELEM_HTTP_HEADER);
            int len = extEls.length;
            HTTPHeader[] httpHeaders = new HTTPHeader[len];
            System.arraycopy(extEls, 0, httpHeaders, 0, len);
            return httpHeaders;
        }
        return new HTTPHeader[0];
    }
}

