/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.nio;

import java.io.IOException;
import java.util.Iterator;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpMessage;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestFactory;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.impl.nio.NHttpConnectionBase;
import org.apache.http.impl.nio.codecs.HttpRequestParser;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicStatusLine;
import org.apache.http.message.BufferedHeader;
import org.apache.http.nio.NHttpServerConnection;
import org.apache.http.nio.NHttpServiceHandler;
import org.apache.http.nio.reactor.IOSession;
import org.apache.http.nio.util.ByteBufferAllocator;
import org.apache.http.params.HttpParams;
import org.apache.http.util.CharArrayBuffer;

public class DefaultNHttpServerConnection
extends NHttpConnectionBase
implements NHttpServerConnection {
    private HttpRequestParser requestParser;

    public DefaultNHttpServerConnection(IOSession session, HttpRequestFactory requestFactory, ByteBufferAllocator allocator, HttpParams params) {
        super(session, allocator, params);
        if (requestFactory == null) {
            throw new IllegalArgumentException("Request factory may not be null");
        }
        this.requestParser = new HttpRequestParser(this.inbuf, requestFactory, params);
    }

    public void resetInput() {
        this.request = null;
        this.contentDecoder = null;
        this.requestParser.reset();
    }

    public void resetOutput() {
        this.response = null;
        this.contentEncoder = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consumeInput(NHttpServiceHandler handler) {
        if (this.closed) {
            this.session.clearEvent(1);
            return;
        }
        try {
            if (this.request == null) {
                int bytesRead = this.requestParser.fillBuffer(this.session.channel());
                this.request = (HttpRequest)this.requestParser.parse();
                if (this.request != null) {
                    if (this.request instanceof HttpEntityEnclosingRequest) {
                        HttpEntity entity = this.prepareDecoder((HttpMessage)this.request);
                        ((HttpEntityEnclosingRequest)this.request).setEntity(entity);
                    }
                    this.metrics.incrementRequestCount();
                    handler.requestReceived(this);
                    if (this.contentDecoder == null) {
                        this.resetInput();
                    }
                }
                if (bytesRead == -1) {
                    this.close();
                }
            }
            if (this.contentDecoder != null) {
                handler.inputReady(this, this.contentDecoder);
                if (this.contentDecoder.isCompleted()) {
                    this.resetInput();
                }
            }
        }
        catch (IOException ex) {
            handler.exception((NHttpServerConnection)this, ex);
        }
        catch (HttpException ex) {
            handler.exception((NHttpServerConnection)this, ex);
        }
        finally {
            this.hasBufferedInput = this.inbuf.hasData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void produceOutput(NHttpServiceHandler handler) {
        try {
            if (this.outbuf.hasData()) {
                this.outbuf.flush(this.session.channel());
            }
            if (!this.outbuf.hasData()) {
                if (this.closed) {
                    this.session.close();
                    this.resetOutput();
                    return;
                }
                if (this.contentEncoder != null) {
                    handler.outputReady(this, this.contentEncoder);
                    if (this.contentEncoder.isCompleted()) {
                        this.resetOutput();
                    }
                }
                if (this.contentEncoder == null && !this.outbuf.hasData()) {
                    if (this.closed) {
                        this.session.close();
                        return;
                    }
                    this.session.clearEvent(4);
                    handler.responseReady(this);
                }
            }
        }
        catch (IOException ex) {
            handler.exception((NHttpServerConnection)this, ex);
        }
        finally {
            this.hasBufferedOutput = this.outbuf.hasData();
        }
    }

    public void submitResponse(HttpResponse response) throws IOException, HttpException {
        if (response == null) {
            throw new IllegalArgumentException("HTTP response may not be null");
        }
        this.assertNotClosed();
        if (this.response != null) {
            throw new HttpException("Response already submitted");
        }
        this.lineBuffer.clear();
        BasicStatusLine.format((CharArrayBuffer)this.lineBuffer, (StatusLine)response.getStatusLine());
        this.outbuf.writeLine(this.lineBuffer);
        Iterator it = response.headerIterator();
        while (it.hasNext()) {
            Header header = (Header)it.next();
            if (header instanceof BufferedHeader) {
                this.outbuf.writeLine(((BufferedHeader)header).getBuffer());
                continue;
            }
            this.lineBuffer.clear();
            BasicHeader.format((CharArrayBuffer)this.lineBuffer, (Header)header);
            this.outbuf.writeLine(this.lineBuffer);
        }
        this.lineBuffer.clear();
        this.outbuf.writeLine(this.lineBuffer);
        if (response.getStatusLine().getStatusCode() >= 200) {
            this.metrics.incrementRequestCount();
            if (response.getEntity() != null) {
                this.response = response;
                this.prepareEncoder((HttpMessage)response);
            }
        }
        this.session.setEvent(4);
    }

    public boolean isResponseSubmitted() {
        return this.response != null;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        if (this.isOpen()) {
            buffer.append(this.session.getRemoteAddress());
        } else {
            buffer.append("closed");
        }
        buffer.append("]");
        return buffer.toString();
    }
}

