using System;
using System.Collections.Generic;
using System.Text;

namespace SlothLib.LinearAlgebra.FeatureVector
{
	/// <summary>
	/// dS@̃fhÕm[h
	/// </summary>
	public class CentroidDendrogramNode<T> : DendrogramNode<T>
	{

		// dS@ɂdS̃xNg
		private IVector<T> centroidVector;

		/// <summary>
		/// RXgN^
		/// </summary>
		/// <param name="iid1"></param>
		/// <param name="iid2"></param>
		/// <param name="distance"></param>
		/// <param name="centroidVector"></param>
		public CentroidDendrogramNode(int iid1, int iid2, double distance, IVector<T> centroidVector)
			: base(iid1, iid2, distance)
		{
			this.centroidVector = centroidVector;
		}

		/// <summary>
		/// dS@ɂdS̃xNg
		/// </summary>
		public override IVector<T> CentroidVector
		{
			get { return this.centroidVector; }
		}


	}
}
