using System;
using System.Collections.Generic;
using System.Text;

namespace SlothLib.LinearAlgebra.FeatureVector
{
	/// <summary>
	/// fhÕm[h
	/// </summary>
	public class DendrogramNode<T> : IDendrogramNode<T>
	{
		private int iid1;
		private int iid2;
		private double distance;

		/// <summary>
		/// RXgN^
		/// </summary>
		/// <param name="iid1"></param>
		/// <param name="iid2"></param>
		/// <param name="distance"></param>
		public DendrogramNode(int iid1, int iid2, double distance)
		{
			this.iid1 = iid1;
			this.iid2 = iid2;
			this.distance = distance;
		}

		/// <summary>
		/// ID̃NX^ԍ
		/// </summary>
		public int ItemID1
		{
			get { return this.iid1; }
		}

		/// <summary>
		/// ID傫̃NX^ԍ
		/// </summary>
		public int ItemID2
		{
			get { return this.iid2; }
		}

		/// <summary>
		/// ړ_ɂ鋗
		/// ގx̏ꍇގx̂܂
		/// </summary>
		public double Distance
		{
			get { return this.distance; }
		}

		/// <summary>
		/// dS̃xNg
		/// </summary>
		public virtual IVector<T> CentroidVector
		{
			get { return null; }
		}


	}
}
