using System;
using System.Collections.Generic;
using System.Text;
using STATCONNECTORSRVLib;

namespace SlothLib.LinearAlgebra.R
{
    public class ROperator
    {
        private static readonly StatConnectorClass scc;

        static ROperator() {
            scc = new StatConnectorClass();
            scc.Init("R");
        }

        private ROperator()
        { }

        public static Object Run(string rCommand)
        {         
            return scc.Evaluate(rCommand);
        }

        public static void Set(string rVariable, double[,] matrix)
        {
            scc.SetSymbol(rVariable, matrix);
        }

        public static void Set(string RVariable, double[] Vector)
        {
            scc.SetSymbol(RVariable, Vector);
        }


        public static void Close()
        {
            if (scc != null)
            {
                scc.Close();
                //scc = null;
            }
        }

    }
}
