using System;
using System.Collections.Generic;
using System.Text;
using SlothLib.LinearAlgebra.Vector;
using SlothLib.LinearAlgebra.Matrix;

namespace SlothLib.LinearAlgebra.R.Vector
{
    public class OuterProductOperator
    {
        public OuterProductOperator()
        {}

        public StandaloneMatrix DoCalculate(IVector vector1, IVector vector2)
        {
            ROperator.Set("v1", vector1.GetPlainVector() as double[]);
            ROperator.Set("v2", vector2.GetPlainVector() as double[]);

            StandaloneMatrix resultMatrix = new StandaloneMatrix(ROperator.Run("v1 %o% v2") as double[,]);

            return resultMatrix;
        }
    }
}
