using System;
using System.Collections.Generic;
using System.Text;

namespace SlothLib.NLP
{
    /// <summary>
    /// IMorphemeToStringFilterNX̂߂̒ۃNX
    /// </summary>
	public abstract class AbstractMorphemeToStringFilter : IMorphemeToStringFilter
	{
        /// <summary>
        /// `ԑfɃtB^Kp
        /// </summary>
        /// <param name="morpheme">tB^Kp`ԑf</param>
        /// <returns>tB^ɂĕϊꂽʂ̕</returns>
		public abstract string DoFilter(IMorpheme morpheme);

        /// <summary>
        /// ̌`ԑfɃtB^Kp
        /// </summary>
        /// <param name="morphemes">tB^Kp`ԑf</param>
        /// <returns>tB^ɂĕϊꂽʂ̔̕z</returns>
		public virtual string[] DoFilter(IEnumerable<IMorpheme> morphemes)
		{
			List<string> result = new List<string>();
			foreach (IMorpheme mp in morphemes)
			{
				string filtered = this.DoFilter(mp);
				if (filtered != null)
				{
					result.Add(filtered);
				}
			}
			return result.ToArray();
		}

	}
}
