using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using Microsoft.Win32;

namespace SlothLib.NLP
{

	/// <summary>
	/// `ԑf͊MeCab𗘗pNX 
	/// </summary>
	/// <remarks>
	/// o[W0.95z肵Ă܂B
	/// mecabrcƂāAMeCabCXg[̕Ŵ̂gƂz肳Ă܂B
	/// <newpara>[2007-04-22][ohshima]쐬</newpara>
	/// </remarks>
	public class MeCab : IMorphologicalAnalyzer, ITokenizer
	{

		#region private tB[h

		/// <summary>
		/// mecab.exe ̃pX
		/// </summary>
		private string meCabPath;

		/// <summary>
		/// mecabrc ̃pX
		/// </summary>
		private string meCabRcPath;


		#endregion


		/// <summary>
		/// 𐶐
		/// </summary>
		private static Random random = new Random();


		#region RXgN^

		/// <summary>
		/// RXgN^BMeCab̃ftHg̐ݒ𗘗p
		/// </summary>
		public MeCab()
		{
			// mecab.exe  mecabrc ̃pXWXg̏ɐݒ肷B
			this.MeCabPath = GetMeCabPath();
			this.MeCabRcPath = GetMeCabRcPath();
		}

        /// <summary>
        /// RXgN^Bmecab.exemecabrc̃pXw肷
        /// </summary>
        /// <param name="meCabPath">mecab.exẽpX</param>
        /// <param name="meCabRcPath">mecabrc̃pX</param>
		public MeCab(string meCabPath, string meCabRcPath)
		{
			this.MeCabPath = meCabPath;
			this.MeCabRcPath = meCabRcPath;
		}

		#endregion


		#region vpeBn

        /// <summary>
        /// mecab.exẽpX
        /// </summary>
		public string MeCabPath
		{
            get { return this.meCabPath; }
            set 
            {
                if (!File.Exists(value))
                {
                    throw new FileNotFoundException("mecab.exe邱Ƃł܂łB", value);
                }
                this.meCabPath = value; 
            }
		}

        /// <summary>
        /// mecabrc̃pX
        /// </summary>
		public string MeCabRcPath
		{
            get { return this.meCabRcPath; }
            set
            {
                if (!File.Exists(value))
                {
                    throw new FileNotFoundException("mecabrc邱Ƃł܂łB", value);
                }
                this.meCabRcPath = value;
            }
		}

		#endregion


		// \w`\ti,iו1,iו2,iו3,p`,p^,`,ǂ,


		#region C̃\bh DoAnalyze

        /// <summary>
        /// `ԑf͂s
        /// </summary>
        /// <param name="text">͑Ώۂ̃eLXg</param>
        /// <returns>͌</returns>
		public MeCabResult DoAnalyze(string text)
		{

			if (text == null)
			{
				throw new ArgumentNullException("text", "nullłB");
			}

			// t@CpX
			string tempFilePath;
			do
			{
				tempFilePath = Path.GetTempPath() + "SlothLib.NLP.MeCab.DoAnalyze." + text.GetHashCode() + "." + random.Next().ToString() + ".tmp";
			} while (File.Exists(tempFilePath));

			// Rec̏o

			// ͂sƂɕB
			string[] splitText = text.Split(new string[] { "\r", "\n", "\r\n" }, StringSplitOptions.RemoveEmptyEntries);

			using (StreamWriter sw = new StreamWriter(tempFilePath, false, System.Text.Encoding.GetEncoding("shift_jis")))
			{

				foreach (string input in splitText)
				{
					string inputTrim = input.Trim();
					if (string.IsNullOrEmpty(inputTrim))
					{
						continue;
					}
					//Debug.WriteLine("input:" + inputTrim);
					sw.WriteLine(inputTrim);
				}
			}

			/*
			using (StreamWriter sw = new StreamWriter(tempFilePath, false, System.Text.Encoding.GetEncoding("shift_jis")))
			{
				sw.Write(text);
			}*/

			// MeCab̐
			string parsedText = ParseFile(tempFilePath);

            try
            {
                // ꎞt@CsvɂȂ͂Ȃ̂ŁA폜B
                // OHȂ񖳎łB
                File.Delete(tempFilePath);
            }
            catch { }

			return new MeCabResult(parsedText);
		}


        /// <summary>
        /// eLXgt@CǂݍŌ`ԑf͂B
        /// </summary>
        /// <param name="tempFilePath">eLXgt@C̃pXB</param>
        /// <param name="option">IvV</param>
        /// <returns>MeCab̉͌</returns>
		private string ParseFile(string tempFilePath, string option)
		{
			// vZX쐬Ƃ낢
			System.Diagnostics.Process p = new System.Diagnostics.Process();
			p.StartInfo.FileName = this.MeCabPath;
            p.StartInfo.Arguments = @"-r """ + this.MeCabRcPath + @""" " + option + @" """ + tempFilePath + @"""";
			p.StartInfo.CreateNoWindow = true;
			p.StartInfo.UseShellExecute = false;
			// Wo͂ǂݍ
			p.StartInfo.RedirectStandardOutput = true;
			p.Start();
			string output = p.StandardOutput.ReadToEnd();
			p.WaitForExit();
			int ec = p.ExitCode;
			p.Close();
			if (ec != 0)
			{
				throw new Exception("mecab.exe̎sɃG[N܂B");
			}
			return output;
		}

		/// <summary>
		/// eLXgt@CǂݍŌ`ԑf͂B
		/// </summary>
		/// <param name="tempFilePath">eLXgt@C̃pXB</param>
		/// <returns>MeCab̉͌</returns>
        private string ParseFile(string tempFilePath)
        {
            return ParseFile(tempFilePath, string.Empty);
        }

		#endregion


		#region public static \bh

        /// <summary>
        /// WXgmecab.exẽpX擾
        /// </summary>
        /// <returns>mecab.exẽpX</returns>
		public static string GetMeCabPath()
		{
			// @t@C̈ʒu
			string pathRc = GetMeCabRcPath();
			FileInfo fiRc = new FileInfo(pathRc);
			
			// W̎fBNg̐eChaSeñpXƂĂ̈Ԃ̌łB
			string pathExe = fiRc.Directory.Parent.FullName + "\\bin\\mecab.exe";
			if (!File.Exists(pathExe))
			{
				throw new FileNotFoundException("mecab.exe܂łB", pathExe);
			}
			return pathExe;
		}

        /// <summary>
        /// WXgmecabrc̃pX
        /// </summary>
        /// <returns>mecabrc̃pX</returns>
		public static string GetMeCabRcPath()
		{
			// MeCab֘ÃWXgL[
			RegistryKey rkMeCabLm = Registry.LocalMachine.OpenSubKey(@"SOFTWARE\Mecab", false);
            RegistryKey rkMeCabCu = Registry.CurrentUser.OpenSubKey(@"SOFTWARE\Mecab", false);

			try
			{
                // HKEY_LOCAL_MACHINEWmecabrc̃pX߂B
                return rkMeCabLm.GetValue("mecabrc").ToString();
            }
			catch
			{
				try
				{
                    // HKEY_CURRENT_USERWmecabrc̃pX߂B
                    return rkMeCabCu.GetValue("mecabrc").ToString();
                }
				catch
				{
					throw new ApplicationException("WXgMeCabɊւ񂪂݂܂łB");
				}
			}
		}

		#endregion


		#region IMorphologicalAnalyzer o

		IMorphologicalAnalyzerResult IMorphologicalAnalyzer.DoAnalyze(string text)
		{
			return this.DoAnalyze(text);
		}

		#endregion


        #region ITokenizer o

        /// <summary>
        /// ʂԂ
        /// </summary>
        /// <param name="text"></param>
        /// <returns></returns>
        public string[] DoTokenize(string text)
        {
            if (text == null)
            {
                throw new ArgumentNullException("text", "nullłB");
            }

            // t@CpX
            string tempFilePath;
            do
            {
                tempFilePath = Path.GetTempPath() + "SlothLib.NLP.MeCab.DoAnalyze." + text.GetHashCode() + "." + random.Next().ToString() + ".tmp";
            } while (File.Exists(tempFilePath));

            // Rec̏o

            // ͂sƂɕB
            string[] splitText = text.Split(new string[] { "\r", "\n", "\r\n" }, StringSplitOptions.RemoveEmptyEntries);

            using (StreamWriter sw = new StreamWriter(tempFilePath, false, System.Text.Encoding.GetEncoding("shift_jis")))
            {

                foreach (string input in splitText)
                {
                    string inputTrim = input.Trim();
                    if (string.IsNullOrEmpty(inputTrim))
                    {
                        continue;
                    }
                    //Debug.WriteLine("input:" + inputTrim);
                    sw.WriteLine(inputTrim);
                }
            }

            /*
            using (StreamWriter sw = new StreamWriter(tempFilePath, false, System.Text.Encoding.GetEncoding("shift_jis")))
            {
                sw.Write(text);
            }*/

            // MeCab̐
            string parsedText = ParseFile(tempFilePath,"-O wakati");

            try
            {
                // ꎞt@CsvɂȂ͂Ȃ̂ŁA폜B
                // OHȂ񖳎łB
                File.Delete(tempFilePath);
            }
            catch { }

            return parsedText.Split(' ');
        }

        #endregion
    }
}
