using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Diagnostics;

namespace SlothLib.NLP
{
    /// <summary>
    /// `ԑf͊MeCabT[oƂĎgNXB͂xɃvZXNȂ
    /// </summary>
    public class MeCabServer : IMorphologicalAnalyzer
    {

        #region private

        /// <summary>
        /// mecab̃vZX
        /// </summary>
        private static Process p = null;

        /// <summary>
        /// mecab.exe ̃pX
        /// </summary>
        private static string meCabPath = null;

        /// <summary>
        /// mecabrc ̃pX
        /// </summary>
        private static string meCabRcPath = null;

        /// <summary>
        /// ͂ċN邩
        /// </summary>
        private static int restartCount = 1000;

        /// <summary>
        /// ݂܂łɉ͂
        /// </summary>
        private static int doneCount = 0;


        private static object lockObject = new object();

        #endregion

        #region RXgN^

        /// <summary>
        /// RXgN^
        /// </summary>
		public MeCabServer()
		{
            //this.SetMeCabPath(MeCab.GetMeCabPath());
            //this.SetMeCabRcPath(MeCab.GetMeCabRcPath());
            MeCabPath = MeCab.GetMeCabPath();
            meCabRcPath = MeCab.GetMeCabRcPath();
		}

        /// <summary>
        /// RXgN^
        /// </summary>
        /// <param name="meCabPath">mecab.exẽpX</param>
        /// <param name="meCabRcPath">mecabrc̃pX</param>
        public MeCabServer(string meCabPath, string meCabRcPath)
        {
            MeCabPath = meCabPath;
            MeCabRcPath = meCabRcPath;
        }

        #endregion

        #region static\bh DoMeCab

        /// <summary>
        /// MeCabs
        /// </summary>
        /// <param name="text">͑Ώۂ̃eLXg</param>
        /// <returns>͌</returns>
        public static MeCabResult DoMeCab(string text)
        {
            // ʂi[邽
            StringBuilder sb = new StringBuilder();

            lock (lockObject)
            {
                // vZXĂȂ΁A点B
                if (p == null || p.HasExited)
                {
					p = null;
                    StartProcess();
                }

                // ͂sƂɕB
                string[] splitText = text.Split(new string[] { "\r", "\n", "\r\n" }, StringSplitOptions.RemoveEmptyEntries);

                foreach (string input in splitText)
                {
					string inputTrim = input.Trim();
					if (string.IsNullOrEmpty(inputTrim))
					{
						continue;
					}
					//Debug.WriteLine("input:" + inputTrim);
					p.StandardInput.WriteLine(inputTrim);

                    string line;
                    while ((line = p.StandardOutput.ReadLine()) != "EOS" && line != null)
                    {
                        //Debug.WriteLine("line:" + line);
                        sb.AppendLine(line);
                    }
                    sb.AppendLine("EOS");

                    //eLXg͂񐔂ݒ񐔂𒴂ċN
                    if (doneCount++ >= restartCount)
                    {
                        StopProcess();
                        StartProcess();
                    }

                }
            }

            return new MeCabResult(sb.ToString());
        }

        #endregion

        #region Start, Stop

        /// <summary>
        /// vZXN
        /// </summary>
        public static void StartProcess()
        {
            lock (lockObject)
            {
                // vZXĂȂ΁A点B
                if (p == null)
                {
                    try
                    {
                        // vZX̃CX^XB
                        p = new System.Diagnostics.Process();
                        // vZX StartInfo ݒ肷B
                        // st@CB
                        p.StartInfo.FileName = MeCabPath;
                        p.StartInfo.Arguments = @"-r """ + MeCabRcPath + @"""";
                        // qvZX̃EBhE\ȂB
                        p.StartInfo.CreateNoWindow = true;
                        //  StandardInput gpꍇ́A
                        // UseShellExecute  false ɂȂĂKv܂B
                        p.StartInfo.UseShellExecute = false;
                        // ẂAWo͂gp܂B
                        p.StartInfo.RedirectStandardInput = true;
                        p.StartInfo.RedirectStandardOutput = true;
                        // N܂B
                        p.Start();
                    }
                    catch
                    {
                        p = null;
                        throw;
                    }
                }
            }
        }


        /// <summary>
        /// vZX~
        /// </summary>
        public static void StopProcess()
        {
            lock (lockObject)
            {
                if (p != null)
                {
                    p.Dispose();
                    p = null;
                    doneCount = 0;
                }
            }
        }

        #endregion

        #region CX^X\bh

        /// <summary>
        /// CX^X̃\bh
        /// </summary>
        /// <param name="text">͑Ώۂ̃eLXg</param>
        /// <returns>͌</returns>
        public MeCabResult DoAnalyze(string text)
        {
            //static̃\bhĂ
            return DoMeCab(text);
        }

        #endregion

        #region vpeBn

        /// <summary>
        /// mecab.exẽpX
        /// </summary>
        public static string MeCabPath
        {
            get { return meCabPath; }
            set
            {
                if (!File.Exists(value))
                {
                    throw new FileNotFoundException("mecab.exe邱Ƃł܂łB", value);
                }
                lock (lockObject)
                {
                    meCabPath = value;
                }
            }
        }

        /// <summary>
        /// mecabrc̃pX
        /// </summary>
        public static string MeCabRcPath
        {
            get { return meCabRcPath; }
            set
            {
                if (!File.Exists(value))
                {
                    throw new FileNotFoundException("mecabrc邱Ƃł܂łB", value);
                }
                lock (lockObject)
                {
                    meCabRcPath = value;
                }
            }
        }

        /// <summary>
        /// ͂MeCabServerċN邩
        /// </summary>
        public static int RestartCount
        {
            get { return restartCount; }
            set { restartCount = value; }
        }

        #endregion


        #region IMorphologicalAnalyzer o

        IMorphologicalAnalyzerResult IMorphologicalAnalyzer.DoAnalyze(string text)
        {
            return this.DoAnalyze(text);
        }

        #endregion

    }
}
