using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SlothLib.Web.Search;

namespace SlothLibTests.Web
{
    public partial class FormFlickr : Form
    {
        public FormFlickr()
        {
            InitializeComponent();
        }

        private void btnSearch_Click(object sender, EventArgs e)
        {
            FlickrSearch search;
            search = new FlickrSearch("945e41273602152763825a2c31060a35");

            FlickrSearchResult result = search.DoSearch(tbQuery.Text, int.Parse(cbMaxNum.Text),FlickrSearch.GetSearchType(cbSearchType.Text),FlickrSearch.GetTagMode(cbTagMode.Text));

            lblTotalNumber.Text = result.TotalResultsAvailable.ToString() + "";
            lblReturned.Text = result.TotalResultsReturned.ToString();

            lblQuery.Text = result.Query;

            lvResult.Items.Clear();
            foreach (FlickrElement element in result.ResultElements)
            {
                ListViewItem item = new ListViewItem(element.Title);
                item.SubItems.Add(element.URL);
                item.SubItems.Add(element.ID);
                item.SubItems.Add(element.Owner);
                item.SubItems.Add(element.IsPublic.ToString());
                item.SubItems.Add(element.IsFriend.ToString());
                item.SubItems.Add(element.IsFamily.ToString());
                
                lvResult.Items.Add(item);
            }
        }

        private void lvResult_DoubleClick(object sender, EventArgs e)
        {
            foreach (ListViewItem item in lvResult.SelectedItems)
            {
                System.Diagnostics.Process.Start(item.SubItems[1].Text);
            }
        }

        private void FormFlickr_Load(object sender, EventArgs e)
        {
            cbSearchType.SelectedIndex = 0;
            cbTagMode.SelectedIndex = 0;
        }
    }
}