using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;
using System.Web;
using System.Net;
using System.IO;

namespace SlothLib.Web.Search
{
    /// <summary>
    /// Yahoo!EFu摜WebT[rX
    /// http://developer.yahoo.co.jp/search/image/V1/imageSearch.html
    /// </summary>
    /// <remarks>
    /// <newpara>[2007-05-24][kondo]쐬</newpara>
    /// </remarks>
    public class YahooJpImageSearch : IImageSearch
    {

        #region vCx[gtB[h

        // AvP[VID
        private string applicationID;

        // query  results(resultNumber) ȊÖ
        private SearchType type;
        private int start;
        private SearchFormat format;
        private bool adultOk;
        private Color coloration;
        private string[] site;

        // proxy
        private WebProxy proxy;

        //ʂJԂȂ悤ɂ邽߂ɕKv
        Dictionary<string, bool> alreadyGotURL = new Dictionary<string, bool>();

        // XML̂߂̃[v񐔃JE^
        private int loopCount = 0;

        #endregion

        #region RXgN^

        /// <summary>
		/// RXgN^
		/// AvP[VIDw肷
		/// </summary>
		/// <param name="applicationID">vOŗpAvP[VID</param>
		public YahooJpImageSearch(string applicationID)
		{
			this.applicationID = applicationID;

			// query  resultNumber ȊÖ
			this.type= SearchType.all;
			this.start= 1;
			this.format = SearchFormat.any;
			this.adultOk = false;
            this.coloration = Color.any;
			this.site = null;
		}

		#endregion

        #region public \bh

        /// <summary>
        /// Yahoo!摜s
        /// </summary>
        /// <param name="query">NG[łB܂ޏꍇ '+'A܂܂Ȃꍇ '-' w肵܂Bt[Y̏ꍇ " NG[" ̂悤 " ł܂B</param>
        /// <param name="maxNumber">ԋpʂ̐łB</param>
        /// <returns>YahooJpImageSearchResult^̌</returns>
        public YahooJpImageSearchResult DoSearch(string query, int maxNumber)
        {
            return DoSearchOver(query, maxNumber);
        }


        /// <summary>
        /// HIT݂̂擾郁\bh
        /// </summary>
        /// <param name="query">NG</param>
        /// <returns>HIT</returns>
        public long GetTotalNumber(string query)
        {
            return DoSearch(query, 1).TotalResultsAvailable;
        }

        #endregion

        #region vpeB

        /// <summary>
        /// w茟̎ ftHgall
        /// </summary>
        public SearchType Type
        {
            get
            {
                return this.type;
            }
            set
            {
                this.type = value;
            }
        }

        /// <summary>
        /// t@C̎ށ@ftHgany
        /// </summary>
        public SearchFormat Format
        {
            get
            {
                return this.format;
            }
            set
            {
                this.format = value;
            }
        }

        /// <summary>
        /// A_gRečʂ܂߂邩ǂw肵܂BftHgfalse
        /// </summary>
        public bool AdultOk
        {
            get
            {
                return this.adultOk;
            }
            set
            {
                this.adultOk = value;
            }
        }

        /// <summary>
        /// J[摜ʂƂ邩ǂw肵܂iJ[jB
        /// </summary>
        public Color Coloration
        {
            get
            {
                return this.coloration;
            }
            set
            {
                this.coloration = value;
            }
        }

        /// <summary>
        /// hCiႦ www.yahoo.co.jpj𐧌܂B30hC܂Ŏw肷邱Ƃł܂BftHgnull
        /// </summary>
        public string[] Site
        {
            get
            {
                return this.site;
            }
            set
            {
                this.site = value;
            }
        }


        #endregion

        #region Proxyݒ

        /// <summary>
        /// vNVݒ肷B
        /// </summary>
        /// <param name="proxyAddress"></param>
        public void SetProxy(string proxyAddress)
        {
            if (proxyAddress == null)
            {
                this.proxy = null;
            }
            else
            {
                this.proxy = new WebProxy(proxyAddress);
            }
        }

        #endregion

        #region t@\̌\bh

        /// <summary>
        /// 50܂łYahoo!摜s
        /// </summary>
        /// <param name="query">NG[łB܂ޏꍇ '+'A܂܂Ȃꍇ '-' w肵܂Bt[Y̏ꍇ " NG[" ̂悤 " ł܂B</param>
        /// <param name="results">ԋpʂ̐łB</param>
        /// <param name="start">ԋpʂ̐擪ʒułBŏIʒuistart + results - 1j́A1000𒴂܂B</param>
        /// <returns>YahooJpImageSearchResult^̌</returns>
        private YahooJpImageSearchResult DoSearchOriginal(string query, int results, int start)
        {
            string requestURL = MakeRequestURL(query, this.type, results, start, this.format, this.adultOk, this.coloration, this.site);
            XmlDocument xmlDoc = new XmlDocument();

            HttpStatusCode statusCode;

            HttpWebRequest req = (HttpWebRequest)WebRequest.Create(requestURL);
            if (this.proxy != null)
            {
                req.Proxy = proxy;
            }
            using (HttpWebResponse res = (HttpWebResponse)req.GetResponse())
            using (Stream st = res.GetResponseStream())
            {
                xmlDoc.Load(st);
                statusCode = res.StatusCode;
            }

            // [g̗vf擾
            XmlElement xmlRoot = xmlDoc.DocumentElement;

            //ErrorAĂꍇ
            //if (xmlRoot.Name.Equals("Error"))
            if (statusCode != HttpStatusCode.OK)
            {
                // ObZ[W擾
                string errorMessage = GetElementString(xmlRoot.GetElementsByTagName("Message"));
                // O𓊂B
                ThrowException(statusCode, errorMessage);
            }

            // [inagawa] XMLԂĂɎbIΏyvz
            if (string.IsNullOrEmpty(xmlRoot.InnerXml) && string.IsNullOrEmpty(xmlRoot.GetAttribute("totalResultsAvailable")))
            {
                if (++loopCount > 5)
                {
                    // [v񐔂5𒴂O𓊂
                    throw new Exception("Yahoo!K؂XML擾ł܂B");
                }
                System.Diagnostics.Debug.WriteLine("returned XML is empty");
                return DoSearchOriginal(query, results, start);
            }

            // <Result>vftotalResultsAvailablȇl擾
            long totalResultsAvailable = long.Parse(xmlRoot.GetAttribute("totalResultsAvailable"));
            int totalResultsReturned = int.Parse(xmlRoot.GetAttribute("totalResultsReturned"));
            int firstResultPosition = int.Parse(xmlRoot.GetAttribute("firstResultPosition"));

            // ʗvfĂ
            List<YahooJpImageElement> ResultElementList = new List<YahooJpImageElement>();

            //[inagawa]ʂ̐0̌ʃXgԂyvz
            if (totalResultsReturned == 0)
            {
                return new YahooJpImageSearchResult(query, totalResultsAvailable, totalResultsReturned, firstResultPosition, ResultElementList.ToArray());
            }
            
            XmlNodeList xmlResultList = xmlRoot.GetElementsByTagName("Result");

            int rank = start - 1;

            string firstURL = GetElementString(((XmlElement)xmlResultList[0]).GetElementsByTagName("Url"));
            if (alreadyGotURL.ContainsKey(firstURL))
            {
                return new YahooJpImageSearchResult(query, 0, 0, -1, new YahooJpImageElement[0]);
            }
            else
            {
                alreadyGotURL.Add(firstURL, true);
            }
            foreach (XmlElement xmlResult in xmlResultList)
            {
                rank++;
                string title = GetElementString(xmlResult.GetElementsByTagName("Title"));
                string summary = GetElementString(xmlResult.GetElementsByTagName("Summary"));
                string url = GetElementString(xmlResult.GetElementsByTagName("Url"));
                string clickUrl = GetElementString(xmlResult.GetElementsByTagName("ClickUrl"));
                string refererUrl = GetElementString(xmlResult.GetElementsByTagName("RefererUrl"));
                string fileSize = GetElementString(xmlResult.GetElementsByTagName("FileSize"));
                string fileFormat = GetElementString(xmlResult.GetElementsByTagName("FileFormat"));
                double height = double.Parse(GetElementString(xmlResult.GetElementsByTagName("Height")));
                double width = double.Parse(GetElementString(xmlResult.GetElementsByTagName("Width")));
                XmlNodeList xmlThumbnailNode = xmlResult.GetElementsByTagName("Thumbnail");
                string thumbnailUrl = string.Empty;
                double thumbnailHeight = 0.0;
                double thumbnailWidth = 0.0;
                if (xmlThumbnailNode != null)
                {
                    foreach (XmlElement xmlThumbnailElement in xmlThumbnailNode)
                    {
                        thumbnailUrl = GetElementString(xmlThumbnailElement.GetElementsByTagName("Url"));
                        thumbnailHeight = double.Parse(GetElementString(xmlThumbnailElement.GetElementsByTagName("Height")));
                        thumbnailWidth = double.Parse(GetElementString(xmlThumbnailElement.GetElementsByTagName("Width")));
                    }
                }            
                string publisher = GetElementString(xmlResult.GetElementsByTagName("Publisher"));
                bool frameOk = true;
                bool inlineOk = true;

                if (xmlResult.HasAttribute("noframe"))
                {
                    frameOk = false;
                }
                if (xmlResult.HasAttribute("noinline"))
                {
                    inlineOk = false;
                }

                string copyright = GetElementString(xmlResult.GetElementsByTagName("Copyright"));

                YahooJpImageElement result = new YahooJpImageElement(rank, title, summary, url, clickUrl, refererUrl, fileSize,
                    fileFormat, height, width, thumbnailUrl, thumbnailHeight, thumbnailWidth, publisher, frameOk, inlineOk, copyright);
                ResultElementList.Add(result);
            }

            return new YahooJpImageSearchResult(query, totalResultsAvailable, totalResultsReturned, firstResultPosition, ResultElementList.ToArray());
        }


        /// <summary>
        /// Yahoo!摜s
        /// </summary>
        /// <param name="query">NG[łB܂ޏꍇ '+'A܂܂Ȃꍇ '-' w肵܂Bt[Y̏ꍇ " NG[" ̂悤 " ł܂B</param>
        /// <param name="results">ԋpʂ̐łB</param>
        /// <returns>YahooJpImageSearchResult^̌</returns>
        private YahooJpImageSearchResult DoSearchOver(string query, int results)
        {
            int i;
            int loop = (results - 1) / 50;
            List<YahooJpImageElement> resultElementList = new List<YahooJpImageElement>();
            long totalResultsAvailable = 0;
            YahooJpImageSearchResult r;

            for (i = 0; i < loop; i++)
            {
                this.loopCount = 0;
                r = DoSearchOriginal(query,50, ((i * 50) + start));
                if (r.FirstResultPosition == -1) { break; }
                totalResultsAvailable = r.TotalResultsAvailable;
                resultElementList.AddRange(r.ResultElements);
            }
            this.loopCount = 0;
            r = DoSearchOriginal(query,  results - (loop * 50), loop * 50 + start);
            resultElementList.AddRange(r.ResultElements);
            if (r.FirstResultPosition == -1)
            {
            }
            else
            {
                totalResultsAvailable = r.TotalResultsAvailable;
            }

            return new YahooJpImageSearchResult(query, totalResultsAvailable, resultElementList.Count, start, resultElementList.ToArray());
        }

        #endregion

        #region Gp\bh

        /// <summary>
        /// O𓊂
        /// </summary>
        /// <param name="errorCode"></param>
        /// <param name="errorMessage"></param>
        private void ThrowException(HttpStatusCode errorCode, string errorMessage)
        {
            switch (errorCode)
            {
                case HttpStatusCode.BadRequest: // 400
                    throw new YahooJpSearchException(YahooJpSearchException.HttpCode.BadRequest, errorMessage);
                case HttpStatusCode.Forbidden: // 403
                    throw new YahooJpSearchException(YahooJpSearchException.HttpCode.Forbidden, errorMessage);
                case HttpStatusCode.ServiceUnavailable: // 503
                    throw new YahooJpSearchException(YahooJpSearchException.HttpCode.ServiceUnavailable, errorMessage);
                default:
                    throw new Exception("YahooWebSearchőzOHTTPG[܂BiG[R[h: " + (int)errorCode + "j" + errorMessage);
            }
        }

        /// <summary>
        /// XmlNodeList̏߂̃m[h̃eLXg擾
        /// </summary>
        /// <param name="nodeList">XmlNodeList</param>
        /// <returns>XmlNodeList̏߂̃m[hInnerText
        ///          XmlNodeListł΋󕶎Ԃ</returns>
        private string GetElementString(XmlNodeList nodeList)
        {
            if (nodeList.Count == 0)
            {
                return string.Empty;
            }
            else
            {
                return nodeList[0].InnerText;
            }
        }

        /// <summary>
        /// NGXgURL쐬
        /// </summary>
        /// <param name="query">NG[łB܂ޏꍇ '+'A܂܂Ȃꍇ '-' w肵܂Bt[Y̏ꍇ " NG[" ̂悤 " ł܂B</param>
        /// <param name="type">w茟̎ށ@ftHgall</param>
        /// <param name="results">擾</param>
        /// <param name="start">Jn̐擪ʒu</param>
        /// <param name="format">t@C̎ށ@ftHgany</param>
        /// <param name="adultOk">A_gRečʂ܂߂邩ǂ@ftHgfalse</param>
        /// <param name="coloration">J[摜ʂƂ邩ǂw肵܂iJ[jB</param>
        /// <param name="site">hCiႦ www.yahoo.co.jpj𐧌܂B30hC܂Ŏw肷邱Ƃł܂BftHgnull</param>
        /// <returns>URL</returns>
        private string MakeRequestURL(string query, SearchType type, int results, int start, SearchFormat format, bool adultOk,
            Color coloration, string[] site)
        {
            string strType = string.Empty;
            string strFormat = string.Empty;
            string strAdult = string.Empty;
            string strColoration = string.Empty;
            string strSite = string.Empty;

            switch (type)
            {
                case SearchType.all:
                    break;
                case SearchType.any:
                    strType = "&type=any";
                    break;
                case SearchType.phrase:
                    strType = "&type=phrase";
                    break;
            }

            switch (format)
            {
                case SearchFormat.any:
                    break;
                case SearchFormat.bmp:
                    strFormat = "&format=bmp";
                    break;
                case SearchFormat.gif:
                    strFormat = "&format=gif";
                    break;
                case SearchFormat.jpeg:
                    strFormat = "&format=jpeg";
                    break;
                case SearchFormat.png:
                    strFormat = "&format=png";
                    break;
            }

            if (adultOk == true)
            {
                strAdult = "&adulat_ok=1";
            }

            switch (coloration)
            {
                case Color.any:
                    break;
                case Color.bw:
                    strColoration = "&coloration=bw";
                    break;
                case Color.color:
                    strColoration = "&coloration=color";
                    break;
            }

            if (site != null)
            {
                if (site.Length > 30)
                {
                    throw new ArgumentException("siteɎwłhC30܂łł", "site");
                }
                else
                {
                    foreach (string s in site)
                    {
                        strSite += "&site=" + s;
                    }
                }
            }
            
            string uriString = "http://api.search.yahoo.co.jp/ImageSearchService/V1/imageSearch?"
            + "appid=" + this.applicationID
            + "&query=" + System.Web.HttpUtility.UrlEncode(query, Encoding.UTF8)
            //+ "&query=" + query
            + strType
            + "&results=" + results.ToString()
            + "&start=" + start.ToString()
            + strFormat
            + strAdult
            + strColoration
            + strSite;


            //return uriString;

            Uri uri = new Uri(uriString);
            string result = uri.AbsoluteUri;
            //System.Diagnostics.Debug.WriteLine(result);

            return result;
        }

        #endregion

        #region Ŏw肷邽߂̗񋓌^

		/// <summary>
		/// w茟̎
		/// </summary>
		public enum SearchType
		{
			/// <summary>
			/// SNG[܂ތʂԂ܂iftHgjB
			/// </summary>
			all,
			/// <summary>
			/// NG[̂ꂩ܂ތʂԂ܂B
			/// </summary>
			any,
			/// <summary>
			/// NG[𕶏͂ƂĊ܂ތʂԂ܂B
			/// </summary>
			phrase
		}

		/// <summary>
		/// t@C̎ ftHgany
		/// </summary>
		public enum SearchFormat
		{
			/// <summary>
			/// ftHg
			/// </summary>
			any,
			/// <summary>
			/// BMP`
			/// </summary>
			bmp,
			/// <summary>
			/// GIF`
			/// </summary>
			gif,
			/// <summary>
			/// JPEG`
			/// </summary>
			jpeg,
			/// <summary>
			/// PNG`
			/// </summary>
			png
		}

        /// <summary>
		/// ʂ̉摜̎ ftHgany
		/// </summary>
		public enum Color
		{
			/// <summary>
			/// ftHg
			/// </summary>
			any,
			/// <summary>
			/// J[摜
			/// </summary>
			color,
			/// <summary>
			/// 摜
			/// </summary>
			bw
		}

		#endregion

        #region IImageSearch o

        /// <summary>
        /// 摜GWŌ
        /// </summary>
        /// <param name="query">NG</param>
        /// <param name="resultNum">擾</param>
        /// <returns></returns>
        IImageSearchResult IImageSearch.DoSearch(string query, int resultNum)
        {
            return this.DoSearch(query, resultNum);
        }

        #endregion

        #region ISearch o

        /// <summary>
        /// T[`GWŌ
        /// </summary>
        /// <param name="query">NG</param>
        /// <param name="resultNum">擾</param>
        /// <returns></returns>
        ISearchResult ISearch.DoSearch(string query, int resultNum)
        {
            return this.DoSearch(query, resultNum);
        }

        #endregion
    
    }
}
