using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;
using System.Web;
using System.IO;
using System.Net;
using System.Net.Sockets;

namespace SlothLib.Web.Search
{
    /// <summary>
    /// YouTube^OsNX
    /// </summary>
    public class YouTubeSearch : IVideoSearch
    {

        #region privatetB[h

        /// <summary>
        /// YouTube API  dev_key
        /// </summary>
        private string dev_id;
        private WebProxy proxy;

        #endregion

        #region RXgN^

        /// <summary>
        /// RXgN^@AvP[VIDw肷
        /// </summary>
        /// <param name="dev_id">vOŗpAvP[VID</param>

        public YouTubeSearch(string dev_id)
        {
            this.dev_id = dev_id;
        }

        #endregion


        #region public֐

        /// <summary>
        /// YouTubes
        /// </summary>
        /// <param name="query">NG</param>
        /// <param name="resultNum">ʎ擾</param>
        /// <returns></returns>
        public YouTubeSearchResult DoSearch(string query, int resultNum)
        {
            return this.DoSearchOver(query, resultNum);
        }

        #endregion


        #region private֐

        private YouTubeSearchResult DoSearchOriginal(string query, int resultNum, int page)
        {
            List<YouTubeElement> result = new List<YouTubeElement>();

            // YouTube API REST NGXgURL
            string url = MakeYouTubeQuery(query, page, resultNum);
            System.Diagnostics.Debug.WriteLine(url);
            
            XmlDocument xmlDoc = new XmlDocument();

            HttpStatusCode statusCode;

            HttpWebRequest req = (HttpWebRequest)WebRequest.Create(url);
            if (this.proxy != null)
            {
                req.Proxy = proxy;
            }
            using (HttpWebResponse res = (HttpWebResponse)req.GetResponse())
            using (Stream st = res.GetResponseStream())
            {
                xmlDoc.Load(st);
                statusCode = res.StatusCode;
            }

            // [g̗vf擾
            XmlElement rootElement = xmlDoc.DocumentElement;

            long totalNumber = 0;

            try
            {
               totalNumber =  long.Parse(rootElement.ChildNodes[0].ChildNodes[0].InnerText);
            }
            catch
            {
                totalNumber = 0;
            }


            // ۂ̃`FbN
            try
            {
                string status = rootElement.Attributes["status"].InnerText;
                switch (status)
                {
                    case "ok":
                        {
                            break;
                        }

                    case "fail":
                        {
                            string code = rootElement.FirstChild["code"].InnerText;
                            //O𔭐
                            throw (new YouTubeException(code));
                        }
                }
            }
            catch
            {
                throw;
            }

            

            XmlNodeList videoList = rootElement.GetElementsByTagName("video");

            int i = 1;
            foreach (XmlNode video in videoList)
            {
                
                string author = video.ChildNodes[0].InnerText;
                string id = video.ChildNodes[1].InnerText;
                string title = video.ChildNodes[2].InnerText;
                string length_seconds = video.ChildNodes[3].InnerText;
                string rating_avg = video.ChildNodes[4].InnerText;
                string rating_count = video.ChildNodes[5].InnerText;
                string description = video.ChildNodes[6].InnerText; //dexcription
                string view_count = video.ChildNodes[7].InnerText;
                string date = video.ChildNodes[8].InnerText;
                string commnet_count = video.ChildNodes[9].InnerText;
                int rank = (page - 1) * 100 + i;
                i++;
                string tags = video.ChildNodes[10].InnerText; //tags
                // ^O[]ň͂
                tags = "[" + tags + "]";
                tags = tags.Replace(" ", "] [");
                // snippettagssnippet


                string uri = video.ChildNodes[11].InnerText; // y[WւURL iflvւ̒URLł͂Ȃj

                string thumbnail_url = video.ChildNodes[12].InnerText;

                // Rg擾
                // snippet += GetComment(dev_id, id);

                //ϐɌʃNX쐬AXgɒǉ
                YouTubeElement element = new YouTubeElement(SafeString(author), 
                    SafeString(id), 
                    SafeString(title),
                    StrToInt(length_seconds), 
                    StrToDouble(rating_avg),
                    StrToInt(rating_count),
                    SafeString(description),
                    StrToInt(view_count),
                    UnixTimeStampToDateTime(date),
                    StrToInt(commnet_count),
                    SafeString(tags),
                    SafeString(uri),
                    SafeString(thumbnail_url),
                    rank);
                result.Add(element);
                System.Diagnostics.Debug.WriteLine(element.ToString());
            }

            return new YouTubeSearchResult(query, totalNumber, result.ToArray());

        }

        /// <summary>
        /// YouTubeɓURLo͂
        /// </summary>
        /// <param name="tag">the tag to search for</param>
        /// <param name="page">the "page" of results you want to retrieve (e.g. 1, 2, 3)</param>
        /// <param name="per_page">the number of results you want to retrieve per page (default 20, maximum 100) </param>
        /// <returns></returns>
        private string MakeYouTubeQuery(string tag, int page, int per_page)
        {
           
            string requestURL = "http://www.youtube.com/api2_rest?method=youtube.videos.list_by_tag&"
            + "dev_id=" + dev_id + "&tag=" +tag
            + "&page=" + page.ToString() + "&per_page=" + per_page.ToString();

            return new Uri(requestURL).AbsoluteUri;
        }

        #region GetComment
        /// <summary>
        /// videos.get_details \bhŃRg擾
        /// </summary>
        /// <param name="dev_id">AvP[VID</param>
        /// <param name="video_id">rfIID</param>
        /// <returns>RgȂ</returns>
        public string GetComment(string dev_id, string video_id)
        {
            string comment_str = "";

            // Rg擾
            string detail_url = "http://www.youtube.com/api2_rest?method=youtube.videos.get_details&" + "dev_id=" + dev_id + "&video_id=" + video_id;
            XmlDocument detail_xmlDoc = new XmlDocument();
            detail_xmlDoc.Load(detail_url);

            XmlElement detail_rootElement = detail_xmlDoc.DocumentElement;

            try
            {
                string status = detail_rootElement.Attributes["status"].InnerText;
                switch (status)
                {
                    case "ok":
                        {
                            break;
                        }

                    case "fail":
                        {
                            string code = detail_rootElement.FirstChild["code"].InnerText;
                            //O𔭐
                            throw (new YouTubeException(code));
                        }
                }
            }
            catch
            {
                throw;
            }


            XmlNodeList commentList = detail_rootElement.GetElementsByTagName("comment");

            if (commentList != null)
            {
                foreach (XmlNode comment in commentList)
                {
                    // author = comment.ChildNodes[3].InnerText;
                    comment_str += " " + comment.ChildNodes[1].InnerText; // comment
                    // time = comment.ChildNodes[3].InnerText;
                }
            }

            return comment_str;
        }
        #endregion

        #region GetSwfUrl
        /// <summary>
        /// Flash̃vC[URL擾
        /// </summary>
        /// <param name="videoID">rfIID</param>
        /// <returns>Flash̃vC[URL</returns>
        public string GetSwfUrl(string videoID)
        {
            // HTTP Request
            string request = "GET /watch_video?v=" + videoID + " HTTP/1.0\r\n";
            request += "Connection: Close\r\n";
            request += "\r\n";

            // t擾郊NGXgbZ[W
            string server = "www.youtube.com";
            string path = "/watch_video?v=" + videoID;
            //NGXgbZ[W쐬
            string reqMsg = "GET " + path + " HTTP/1.0\r\n" + "Connection: Close\r\n\r\n";

            // \PbgʐM
            string resMsg = socketConnect(server, reqMsg);


            // t擾
            int start = resMsg.IndexOf("&t=") + 3;
            int end = resMsg.IndexOf("\n", start);
            string t = resMsg.Substring(start, end - start - 1);

            string swfURL = "http://www.youtube.com/player2.swf?video_id=" + videoID + "&t=" + t;
            return swfURL;

        }
        #endregion

        #region GetVideoUrl
        /// <summary>
        /// video̒URL擾
        /// </summary>
        /// <param name="videoID">videoID</param>
        /// <returns>URL</returns>
        public string GetVideoUrl(string videoID)
        {
            // HTTP Request
            string request = "GET /watch_video?v=" + videoID + " HTTP/1.0\r\n";
            request += "Connection: Close\r\n";
            request += "\r\n";

            // t擾郊NGXgbZ[W
            string server = "www.youtube.com";
            string path = "/watch_video?v=" + videoID;
            //NGXgbZ[W쐬
            string reqMsg = "GET " + path + " HTTP/1.0\r\n" + "Connection: Close\r\n\r\n";

            // \PbgʐM
            string resMsg = socketConnect(server, reqMsg);


            // t擾
            int start = resMsg.IndexOf("&t=") + 3;
            int end = resMsg.IndexOf("\n", start);
            string t = resMsg.Substring(start, end - start - 1);


            // video URL 擾郊NGXgbZ[W
            string path2 = "/get_video?video_id=" + videoID + "&t=" + t;
            //NGXgbZ[W쐬
            string reqMsg2 = "GET " + path2 + " HTTP/1.0\r\n" + "Connection: Keep-Alive\r\n\r\n";


            // \PbgʐM
            string resMsg2 = socketConnect(server, reqMsg2);

            // video URL 擾
            int start2 = resMsg2.IndexOf("Location:") + 10;
            int end2 = resMsg2.IndexOf("\r\n", start2);
            string videoURL = resMsg2.Substring(start2, end2 - start2);

            return videoURL;

        }
        #endregion

        #region socketConnect
        /// <summary>
        /// \PbgʐMsȂ
        /// </summary>
        /// <param name="server">T[o</param>
        /// <param name="reqMsg">NGXgbZ[W</param>
        /// <returns>X|XbZ[W</returns>
        private string socketConnect(string server, string reqMsg)
        {
            //bytezɕϊ
            Encoding enc = Encoding.ASCII;
            byte[] reqBytes = enc.GetBytes(reqMsg);

            //zXgIPAhX擾
            IPAddress hostadd = Dns.GetHostEntry(server).AddressList[0];

            //IPEndPoint擾
            IPEndPoint ephost = new IPEndPoint(hostadd, 80);

            //Socket̍쐬
            Socket sock = new Socket(AddressFamily.InterNetwork, SocketType.Stream, ProtocolType.Tcp);

            //ڑ
            sock.Connect(ephost);
            //ڑ̊mF
            if (sock.Connected == false)
            {
                return "Error";
            }

            //NGXgbZ[W𑗐M
            sock.Send(reqBytes, reqBytes.Length, SocketFlags.None);

            //M
            string resMsg = "";
            byte[] resBytes = new byte[256];
            while (true)
            {
                int resSize =
                    sock.Receive(resBytes, resBytes.Length, SocketFlags.None);
                if (resSize == 0)
                    break;
                resMsg += enc.GetString(resBytes, 0, resSize);
            }

            //
            sock.Shutdown(SocketShutdown.Both);
            sock.Close();

            return resMsg;

        }
        #endregion

        private DateTime UnixTimeStampToDateTime(string date)
        {

            //UNIX^CX^vDateTime^ɕϊ
            DateTime baseTime = new DateTime(1970, 1, 1);
            try
            {
                return baseTime.AddSeconds(double.Parse(date));
            }
            catch
            {
                return new DateTime();
            }

        }

        private int StrToInt(string str)
        {
            try
            {
                return int.Parse(str);
            }
            catch
            {
                return 0;
            }
        }

        private double StrToDouble(string str)
        {
            try
            {
                return double.Parse(str);
            }
            catch
            {
                return 0.0;
            }
        }

        private string SafeString(string str)
        {
            if (str == null)
            {
                return string.Empty;
            }
            else
            {
                return str;
            }
        }


        private YouTubeSearchResult DoSearchOver(string query, int resultNum)
        {
            int loop = (resultNum - 1) / 100;
            List<YouTubeElement> resultElements = new List<YouTubeElement>();
            for (int i = 0; i < loop; i++)
            {
                resultElements.AddRange(DoSearchOriginal(query, 100, i + 1).ResultElements);
            }
            YouTubeSearchResult searchResult = DoSearchOriginal(query, resultNum - (loop * 100), loop + 1);
            resultElements.AddRange(searchResult.ResultElements);

            return new YouTubeSearchResult(query, searchResult.TotalNumber,resultElements.ToArray());
        }

        #endregion

        #region vpeB

        /// <summary>
        /// vNV擾Eݒ肷B
        /// </summary>
        public string Proxy
        {
            set
            {
                if (string.IsNullOrEmpty(value))
                {
                    this.proxy = null;
                }
                else
                {
                    this.proxy = new WebProxy(value);
                }
            }
            get
            {
                return this.proxy.Address.AbsoluteUri;
            }
        }

        #endregion


        #region IVideoSearch o

        IVideoSearchResult IVideoSearch.DoSearch(string query, int resultNum)
        {
            return this.DoSearch(query, resultNum);
        }

        #endregion

        #region ISearch o

        ISearchResult ISearch.DoSearch(string query, int resultNum)
        {
            return this.DoSearch(query, resultNum);
        }

        #endregion
    }
}
