using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.IO;
using System.Net;

namespace SlothLib.Web.WebLoader
{
    /// <summary>
    /// }`XbhpĕURL̓e擾NX
    /// </summary>
    public class MultiWebGet
    {
        #region privatetB[h

        private int threadCount;
        private string proxy;
        private string userAgent;
        private int count;
        #endregion

        #region RXgN^

        /// <summary>
        /// RXgN^
        /// </summary>
        public MultiWebGet()
        {
            this.proxy = null;
            this.userAgent = null;
            this.threadCount = DEFAULT_THREAD_COUNT;
            this.count = 0;
           
        }

        #endregion

        #region DoFetch

        /// <summary>
        /// }`Xbh𗘗pĕURL̃f[^擾
        /// </summary>
        /// <param name="urlList">f[^擾URL̃Xg</param>
        /// <returns>MultiWebGetResults^̌</returns>
        public MultiWebGetResults DoFetch(string[] urlList)
        {
            return this.DoFetch(urlList, null, null);
        }

        /// <summary>
        /// }`Xbh𗘗pĕURL̃f[^擾
        /// </summary>
        /// <param name="urlList">f[^擾URL̃Xg</param>
        /// <param name="outputFileList">擾URL̃XgɑΉo̓t@C̃Xg</param>
        /// <returns>MultiWebGetResults^̌</returns>
        public MultiWebGetResults DoFetch(string[] urlList, string[] outputFileList)
        {
            return this.DoFetch(urlList, outputFileList, null, null);
        }



        /// <summary>
        /// }`Xbh𗘗pĕURL̃f[^擾
        /// </summary>
        /// <param name="urlList">f[^擾URL̃Xg</param>
        /// <param name="allowContentTypes">擾URLCotentTypẽXg</param>
        /// <param name="excludeContentTypes">擾ȂURLCotentTypẽXg</param>
        /// <returns>MultiWebGetResults^̌</returns>
        public MultiWebGetResults DoFetch(string[] urlList, string[] allowContentTypes, string[] excludeContentTypes)
        {
            string[] tmpFileNameList = new string[urlList.Length];

            for (int i = 0; i < urlList.Length; i++)
            {
                tmpFileNameList[i] = GetTempFileName(urlList[i]);
            }

            return this.DoFetch(urlList, tmpFileNameList, allowContentTypes, excludeContentTypes);
            
        }

        /// <summary>
        /// }`Xbh𗘗pĕURL̃f[^擾
        /// </summary>
        /// <param name="urlList">f[^擾URL̃Xg</param>
        /// <param name="outputFileList">擾URL̃XgɑΉo̓t@C̃Xg</param>
        /// <param name="allowContentTypes">擾URLCotentTypẽXg</param>
        /// <param name="excludeContentTypes">擾ȂURLCotentTypẽXg</param>
        /// <returns></returns>
        public MultiWebGetResults DoFetch(string[] urlList, string[] outputFileList, string[] allowContentTypes, string[] excludeContentTypes)
        {
            if (urlList.Length > outputFileList.Length)
            {
                System.Diagnostics.Debug.WriteLine("MultiWebGet:擾URLXgƑΉo̓t@CXg̗vfΉĂ܂");
                return null;
            }

            // I܂ƂCxg
            ManualResetEvent finishEvent = new ManualResetEvent(false);

            // SmanagerɈϔC
            WebGetManager manager = new WebGetManager(urlList, this.threadCount, outputFileList, allowContentTypes, excludeContentTypes, finishEvent,this.proxy,this.userAgent);

            // w肳ꂽXbhă[v
            for (int i = 0; i < this.threadCount; i++)
            {
                // [N ACeL[ɓ܂:
                //Console.WriteLine("Queue to Thread Pool {0}", iItem);
                ThreadPool.QueueUserWorkItem(new WaitCallback(manager.WorkerThread));
            }

            finishEvent.WaitOne(Timeout.Infinite, true);

            return new MultiWebGetResults(manager.GetResult());
        }

        #endregion

        #region private֐

        /// <summary>
        /// URLꎞt@C𓾂
        /// </summary>
        /// <param name="url"></param>
        /// <returns></returns>
        private string GetTempFileName(string url)
        {
            return Path.GetTempPath() + GetHashName(url);
        }

        /// <summary>
        /// URLӂ̃t@C𓾂
        /// </summary>
        /// <param name="url"></param>
        /// <returns></returns>
        private string GetHashName(string url)
        {
            return url.GetHashCode().ToString() + DateTime.Now.GetHashCode() + ((int)count++).ToString()  + ".tmp";
        }

        #endregion

        #region vpeB

        /// <summary>
        /// HTTPʐMɗpproxyT[o
        /// </summary>
        public string Proxy
        {
            set
            {
                this.proxy = value;
            }
            get
            {
                return this.proxy;
            }
        }

        /// <summary>
        /// HTTPʐMɗpUserAgent
        /// </summary>
        public string UserAgent
        {
            set
            {
                this.userAgent = value;
            }
            get
            {
                return this.userAgent;
            }
        }

        /// <summary>
        /// Web̎擾ɗpXbh̐
        /// </summary>
        public int ThreadCount
        {
            get
            {
                return this.threadCount;
            }
            set
            {
                if (value > MAX_THREAD_COUNT)
                {
                    this.threadCount = MAX_THREAD_COUNT;
                }
                else if (value < 0)
                {
                    this.threadCount = 1;
                }
                else
                {
                    this.threadCount = value;
                }
            }
        }

        #endregion

        #region 萔

        private const int MAX_THREAD_COUNT = 20;
        private const int DEFAULT_THREAD_COUNT = 10;

        #endregion
    }
}
