package slothLib.NLP;

/**
 * 品詞情報が付加された語の並びを格納するインターフェース
 */
public interface IPosTaggerResult
{
	/**
	 * 格納している語の配列
	 */
	IPosTaggedWord[] posTaggedWords();
	
	///// <summary>
	///// インデクサ
	///// </summary>
	///// <param name="index">語の番号</param>
	///// <returns>index番目の語</returns>
	//IPosTaggedWord this[int index]
	//{
	//    get;
	//}
	
	///// <summary>
	///// 格納されている語の数
	///// </summary>
	//int Count
	//{
	//    get;
	//}
	
	/**
	 * 各語のRawを配列にして返す
	 * @return Rawの配列
	 */
	String[] getRawArray();
	
	/**
	 * 各語のPOSを配列にして返す
	 * @return POSの配列
	 */
	String[] getPOSArray();
}
