


import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import slothLib.web.search.GoogleSOAPSearchAPI;
import slothLib.web.search.IWebElement;
import slothLib.web.search.IWebSearch;
import slothLib.web.search.IWebSearchResult;
import slothLib.web.search.LiveWebSearch;
import slothLib.web.search.WebSearchException;
import slothLib.web.search.YahooJpWebSearch;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Label;

public class MultiSearch {

	private Shell sShell = null;  //  @jve:decl-index=0:visual-constraint="10,10"
	private Text target = null;
	private Button go = null;
	private Combo combo = null;
	private Browser browser = null;
	private List list = null;

	/**
	 * This method initializes combo	
	 *
	 */
	private void createCombo() {
		GridData gridData = new GridData();
		gridData.horizontalSpan = 2;
		gridData.horizontalAlignment = org.eclipse.swt.layout.GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		combo = new Combo(sShell, SWT.V_SCROLL);
		combo.add("Google");
		combo.add("Yahoo");
		combo.add("LiveSearch");
		combo.setText("--select--");
		combo.setLayoutData(gridData);
	}

	/**
	 * This method initializes browser	
	 *
	 */
	private void createBrowser() {
		GridData gridData3 = new GridData();
		gridData3.grabExcessHorizontalSpace = true;
		gridData3.horizontalAlignment = org.eclipse.swt.layout.GridData.FILL;
		gridData3.verticalAlignment = org.eclipse.swt.layout.GridData.FILL;
		gridData3.horizontalSpan = 2;
		gridData3.grabExcessVerticalSpace = true;
		browser = new Browser(sShell, SWT.NONE);
		browser.setLayoutData(gridData3);
	}

	/**
	 * @param args
	 */
	public static void main(String[] args) {
	
		/* Before this is run, be sure to set up the launch configuration (Arguments->VM Arguments)
		 * for the correct SWT library path in order to run with the SWT dlls. 
		 * The dlls are located in the SWT plugin jar.  
		 * For example, on Windows the Eclipse SWT 3.1 plugin jar is:
		 *       installation_directory\plugins\org.eclipse.swt.win32_3.1.0.jar
		 */
		Display display = Display.getDefault();
		MultiSearch thisClass = new MultiSearch();
		thisClass.createSShell();
		thisClass.sShell.open();

		while (!thisClass.sShell.isDisposed()) {
			if (!display.readAndDispatch())
				display.sleep();
		}
		display.dispose();
	}

	/**
	 * This method initializes sShell
	 */
	private void createSShell() {
		GridData gridData4 = new GridData();
		gridData4.horizontalSpan = 2;
		gridData4.verticalAlignment = org.eclipse.swt.layout.GridData.FILL;
		gridData4.horizontalAlignment = org.eclipse.swt.layout.GridData.FILL;
		GridData gridData2 = new GridData();
		gridData2.grabExcessHorizontalSpace = true;
		gridData2.horizontalAlignment = org.eclipse.swt.layout.GridData.FILL;
		GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 2;
		sShell = new Shell();
		sShell.setText("MultiSearch");
		sShell.setLayout(gridLayout);
		sShell.setSize(new Point(298, 298));
		target = new Text(sShell, SWT.BORDER);
		target.setLayoutData(gridData2);
		go = new Button(sShell, SWT.NONE);
		go.setText("Go");
		go.addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
			public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) {
				System.out.println("widgetSelected()" + combo.getText());
				searchAndDisplay(target.getText(), combo.getText());
			}
		});
		createCombo();
		list = new List(sShell, SWT.V_SCROLL);
		list.setLayoutData(gridData4);
		list.addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
			public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) {
				String url = elements[list.getSelectionIndex()].getURL();
				browser.setUrl(url);
			}
		});
		createBrowser();
	}
	/**
	 * search and display 
	 */

	private IWebElement [] elements;
	
	private void searchAndDisplay(String text, String engine) { 
		try {
			list.removeAll();
			elements = search(text, engine); 
			if (elements == null){
				System.err.println("--- the engine is not available ---");				
				return;
			}
			StringBuffer sb = new StringBuffer();
			for (IWebElement element: elements) 
				sb.append(element.getTitle() + "\n");
			System.err.println(sb.toString());
			
			
			int index = 0;
			for (IWebElement element: elements) 
				list.add(element.getTitle(), index++);
			
		} catch (WebSearchException e) {
			System.err.println(e.getMessage());
		}
	}			
	
	/**
	 * search
	 */
	private IWebElement[] search(String text, String engine) throws WebSearchException{

		IWebSearch ws;
		if (engine.equals("Google"))
			ws = new GoogleSOAPSearchAPI();
		else if (engine.equals("Yahoo"))
			ws = new YahooJpWebSearch("slothlib");
		else if (engine.equals("LiveSearch"))
			ws = new LiveWebSearch();
		else
			return null;
		
		IWebSearchResult result = ws.doSearch(text, 10);
		return result.getResultElements();
	}
}
