
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import slothLib.web.search.GoogleSOAPSearchAPI;
import slothLib.web.search.IWebElement;
import slothLib.web.search.IWebSearch;
import slothLib.web.search.IWebSearchResult;
import slothLib.web.search.LiveWebSearch;
import slothLib.web.search.WebSearchException;
import slothLib.web.search.YahooJpWebSearch;

public class MultiTest {

	private Shell sShell = null;
	private Text target = null;
	private Button go = null;
	private Combo combo = null;
	private Text textArea = null;

	/**
	 * This method initializes combo	
	 *
	 */
	private void createCombo() {
		GridData gridData = new GridData();
		gridData.horizontalSpan = 2;
		gridData.horizontalAlignment = org.eclipse.swt.layout.GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		combo = new Combo(sShell, SWT.V_SCROLL);
		combo.add("Google");
		combo.add("Yahoo");
		combo.add("LiveSearch");
		combo.setText("--select--");
		combo.setLayoutData(gridData);
	}

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		// TODO 自動生成されたメソッド・スタブ
		/* Before this is run, be sure to set up the launch configuration (Arguments->VM Arguments)
		 * for the correct SWT library path in order to run with the SWT dlls. 
		 * The dlls are located in the SWT plugin jar.  
		 * For example, on Windows the Eclipse SWT 3.1 plugin jar is:
		 *       installation_directory\plugins\org.eclipse.swt.win32_3.1.0.jar
		 */
		Display display = Display.getDefault();
		MultiTest thisClass = new MultiTest();
		thisClass.createSShell();
		thisClass.sShell.open();

		while (!thisClass.sShell.isDisposed()) {
			if (!display.readAndDispatch())
				display.sleep();
		}
		display.dispose();
	}

	/**
	 * This method initializes sShell
	 */
	private void createSShell() {
		GridData gridData2 = new GridData();
		gridData2.grabExcessHorizontalSpace = true;
		gridData2.horizontalAlignment = org.eclipse.swt.layout.GridData.FILL;
		GridData gridData1 = new GridData();
		gridData1.horizontalSpan = 2;
		gridData1.grabExcessVerticalSpace = true;
		gridData1.horizontalAlignment = org.eclipse.swt.layout.GridData.FILL;
		gridData1.verticalAlignment = org.eclipse.swt.layout.GridData.FILL;
		gridData1.grabExcessHorizontalSpace = true;
		GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 2;
		sShell = new Shell();
		sShell.setText("MultiTest");
		sShell.setLayout(gridLayout);
		sShell.setSize(new Point(300, 200));
		target = new Text(sShell, SWT.BORDER);
		target.setLayoutData(gridData2);
		go = new Button(sShell, SWT.NONE);
		go.setText("Go");
		go.addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
			public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) {
				System.out.println("widgetSelected()" + combo.getText());
				textArea.setText(search(target.getText(), combo.getText()));
			}
		});
		createCombo();
		textArea = new Text(sShell, SWT.MULTI | SWT.WRAP | SWT.V_SCROLL);
		textArea.setLayoutData(gridData1);
	}
	/**
	 * search
	 */
	private String search(String text, String engine) {
		StringBuffer sb = new StringBuffer();

		try {

			IWebSearch ws;
			if (engine.equals("Google"))
				ws = new GoogleSOAPSearchAPI();
			else if (engine.equals("Yahoo"))
				ws = new YahooJpWebSearch("slothlib");
			else if (engine.equals("LiveSearch"))
				ws = new LiveWebSearch();
			else
				return "--- the engine is not available ---";
		
			IWebSearchResult result = ws.doSearch(text, 10);
			for (IWebElement element: result.getResultElements())
				sb.append(element.getTitle() + "\n");
			return sb.toString();
		} catch (WebSearchException e) {
			return e.getMessage();
		}
		
	}
}
