package slothLib.linearAlgebra.featureVector;

/**
 * 重心法のデンドログラムのノード
 */

public class CentroidDendrogramNode<T> extends DendrogramNode<T> {

	// 重心法における重心のベクトル
	private IVector<T> _centroidVector;

	/**
	 * コンストラクタ
	 * @param iid1 
	 * @param iid2 
	 * @param distance 
	 * @param centroidVector 
	 */
	public CentroidDendrogramNode(int iid1, int iid2, double distance, IVector<T> centroidVector)
	{
		super(iid1, iid2, distance);
		this._centroidVector = centroidVector;
	}

	/**
	 * 重心法における重心のベクトル
	 */
	public IVector<T> centroidVector()
	{
		return this._centroidVector; 
	}
}

