package slothLib.linearAlgebra.featureVector;

/**
 * 群平均法
 * <typeparam name="T"></typeparam>
 */
public class GroupAverageClusteringProcess<T> extends HierarchicalClusteringProcess<T>
{

	/**
	 * そのクラスタに属しているアイテムの数を格納しておくもの
	 */
	protected int[] itemCountInCluster;

	/**
	 * コンストラクタ
	 * @param vectors 
	 * @param calculator 
	 * @param dType 
	 */
	public GroupAverageClusteringProcess(IVector<T>[] vectors, ICalculatorScalarFromTwoVectors<T> calculator, ClusteringDistanceType dType)
	{
		super(vectors, calculator, dType);

		itemCountInCluster = new int[this.itemCount];
		for (int i = 0; i < this.itemCount; i++)
		{
			// はじめは全部1つ。
			itemCountInCluster[i] = 1;
		}
	}
	
	/**
	 * クラスタを結合する
	 * @param cid1 
	 * @param cid2 
	 */
	protected void union(int cid1, int cid2)
	{
		// クラスタ番号の更新
		clusterID[cid2] = cid1;

		// アイテム数の更新
		int c = itemCountInCluster[cid1] + itemCountInCluster[cid2];
		itemCountInCluster[cid1] = c;

		// 距離テーブルの更新
		for (int i = 0; i < this.itemCount; i++)
		{
			// クラスタの代表ではなかったり、距離テーブルの対角成分は更新・参照の対象ではない。
			if (clusterID[i] != i || i == cid1 || i == cid2)
			{
				continue;
			}
			setDistance(cid1, i, (getDistance(i, cid1) * this.itemCountInCluster[cid1] + getDistance(i, cid2) * this.itemCountInCluster[cid2]) / (this.itemCountInCluster[cid1] + this.itemCountInCluster[cid2]));
		}
	}

}
