package slothLib.linearAlgebra.featureVector;

/**
 * 階層的クラスタリングを実際に行うクラスが実装するインターフェース
 */
public interface IHierarchicalClusteringProcess<T> {
	/**
	 * クラスタリングを行う
	 * @return 
	 */
	HierarchicalClusteringResult<T> doClustering();

	/**
	 * クラスタリングを行う
	 * @param thresholdClusterCount 
	 * @return 
	 */
	HierarchicalClusteringResult<T> doClustering(int thresholdClusterCount);

	/**
	 * クラスタリングを行う
	 * @param thresholdDistanceOrSimilarity 
	 * @return 
	 */
	HierarchicalClusteringResult<T> doClustering(double thresholdDistanceOrSimilarity);


	/**
	 * クラスタリングを行う
	 * @param thresholdClusterCount 
	 * @param thresholdDistanceOrSimilarity 
	 * @return 
	 */
	HierarchicalClusteringResult<T> doClustering(int thresholdClusterCount, double thresholdDistanceOrSimilarity);
}
