package slothLib.linearAlgebra.featureVector;

public class MaxNormVector<T> extends BasicVector<T> {
	public MaxNormVector(IVector<T> vector) {
		double absmax = VectorOperator.getMaxNorm(vector);
		
		for (T key: vector.keys()) {
			if (absmax != 0) 
				this.set(key, vector.get(key) / absmax);
			else
                this.set(key, 0);
        }
    }
}
