package slothLib.linearAlgebra.vector;

public abstract class AbstractVector implements IVector {

	public IVector op_add(IVector vector2){
		return VectorOperator.add(this, vector2);
	}

	public IVector op_sub(IVector vector2){
		return VectorOperator.subtract(this, vector2);
	}

	public IVector op_negate(){
		return VectorOperator.negate(this);
	}

	public IVector op_mul(double scalar){
		return VectorOperator.multiply(scalar, this);
	}
	
	abstract public int dimension();
	
	abstract public double get(int dimension);

	abstract public double[] getPlainVector();

	abstract public void set(int dimension, double value);

	abstract public Object clone(); 
}
