package slothLib.test;
import java.io.FileNotFoundException;

import slothLib.NLP.ChaSen;
import slothLib.NLP.ChaSenResult;
import slothLib.NLP.IMorpheme;
import slothLib.NLP.MeCabResult;
import slothLib.NLP.MeCabServer;
import slothLib.external.NLP.*;
import slothLib.*;

public class ChaSenTest {

	/**
	 * @param args
	 * @throws FileNotFoundException 
	 */
	public static void main(String[] args) throws SlothLibException {
		String tmp = "Javaでは ISearch.DoSearch や IWebSearch.DoSearchを実装しなくてもよいようです．\n" +
		"まあ，実装することが言語機能的に出来ないのですが．\n" +
		"また，Javaではシリアライズはデフォルトでやってくれるので楽です．\n";

		ChaSen chaSen = new ChaSen();
		ChaSenResult result = chaSen.doAnalyze(tmp);
		System.out.println(result.getRawResult());
		for (IMorpheme s: result.getMorphemes())
			System.out.println(s);
	}

}
