package slothLib.test;

import slothLib.NLP.IMorpheme;
import slothLib.NLP.IMorphemeFilter;
import slothLib.NLP.IMorphemeToStringFilter;
import slothLib.NLP.IMorphologicalAnalyzer;
import slothLib.NLP.IMorphologicalAnalyzerResult;
import slothLib.NLP.MeCab;
import slothLib.NLP.PosFilter;
import slothLib.NLP.RemainOriginalFilter;
import slothLib.linearAlgebra.featureVector.FrequencyVector;
import slothLib.linearAlgebra.featureVector.IVector;
import slothLib.web.search.IWebElement;
import slothLib.web.search.IWebSearch;
import slothLib.web.search.IWebSearchResult;
import slothLib.web.search.YahooJpWebSearch;

public class testSample {

	/**
	 * @param args
	 */
	public static void main(String[] args) throws Exception {
		IWebSearch yahoo = new YahooJpWebSearch("slothlib");
		IWebSearchResult result = yahoo.doSearch("京都", 10);
//		 検索結果の概要部分を取得
		StringBuilder sb = new StringBuilder();
		for (IWebElement element: result.getResultElements())
		    sb.append(element.getDescription());
//		 形態素解析器MeCabを利用する
		IMorphologicalAnalyzer jm = new MeCab();
//		 品詞が「名詞」か「動詞」の語を残すフィルタ
		IMorphemeFilter pos = new PosFilter("名詞|動詞");
//		 形態素結果の結果中から語の原型を取り出すフィルタ
		IMorphemeToStringFilter org = new 
		                    RemainOriginalFilter();
//		 形態素解析を行い，フィルタを適用する
		IMorphologicalAnalyzerResult mr = 
		                    jm.doAnalyze(sb.toString());
		IMorpheme[] morphs = pos.doFilter(mr.getMorphemes());
		String[] nouns = org.doFilter(morphs);
//		 語の出現回数による特徴ベクトル生成
		IVector<String> v = new FrequencyVector<String>(nouns);

		for (String key: v.keys())
			System.out.println(key + " " + v.get(key));
		
	}

}
