//using System;
//using System.Collections.Generic;
//using System.Text;
//using System.Runtime.Serialization;

package slothLib.web.search;

import java.io.Serializable;

    /**
     * GooBlog検索が返す検索結果全体。
     */
    
    public class GooBlogSearchResult implements IBlogSearchResult, Serializable
    {

        // プライベートフィールド

        private GooBlogElement[] resultElements;
        private String query;
        private long searchTotalResults;



        // コンストラクタ

        /**
         * コンストラクタ
         * @param query 検索クエリ
         * @param searchTotalResults 検索結果総数
         * @param elementList 検索結果要素
         */
        public GooBlogSearchResult(String query, long searchTotalResults, GooBlogElement[] elementList)
        {
            this.query = query;
            this.searchTotalResults = searchTotalResults;
            //this.elementList = new List<ISearchResultElement>(elementList);
            this.resultElements = elementList;
        }

        //public GooBlogSearchResult(String query, long searchTotalResults, ISearchResultElement[] elementList)
        //{
        //    this.query = query;
        //    this.searchTotalResults = searchTotalResults;
        //    //this.elementList = new List<ISearchResultElement>(elementList);
        //}



        // プロパティ

        /**
         * 検索結果要素
         */
        public GooBlogElement[] getResultElements()
        {
            return this.resultElements;
        }

        /**
         * 検索クエリ
         */
        public String getQuery()
        {
        	return this.query;
        }

        /**
         * 検索結果総数
         */
        public long getSearchTotalResults()
        {
        	return this.searchTotalResults;
        }

        //public int Count
        //{
        //    get
        //    {
        //        return this.elementList.Count;
        //    }
        //}



        // IBlogSearchResult メンバ

        /**
         * 検索結果要素
         */
//        IBlogElement[] getResultElements()
//        {
//            return this.ResultElements;
//        }

        //IBlogElement IBlogSearchResult.this[int index]
        //{
        //    get
        //    {
        //        return (IBlogElement)this.elementList[index];
        //    }
        //}



//        //#region ISearchResult メンバ
//
//        /// <summary>
//        /// 検索結果要素
//        /// </summary>
//        ISearchResultElement[] ISearchResult.ResultElements
//        {
//            get { return this.ResultElements; }
//        }
//
//        /// <summary>
//        /// 検索クエリ
//        /// </summary>
//        String ISearchResult.Query
//        {
//            get { return this.query;
//            }
//        }
//
//        /// <summary>
//        /// 検索結果総数
//        /// </summary>
        public long getTotalNumber()
        {
        	return this.searchTotalResults;
        }

        //ISearchResultElement ISearchResult.this[int index]
        //{
        //    get
        //    {
        //        return this.elementList[index];
        //    }
        //}

        //int ISearchResult.Count
        //{
        //    get
        //    {
        //        return this.elementList.Count;
        //    }
        //}



//        //#region ISerializable メンバ
//
//        /// <summary>
//        /// シリアライズ化するときに呼び出される関数
//        /// </summary>
//        /// <param name="info">逆シリアル化に必要なすべてのデータ</param>
//        /// <param name="context">シリアル化ストリームの転送元と転送先</param>
//        void System.Runtime.Serialization.ISerializable.GetObjectData(SerializationInfo info, StreamingContext context)
//        {
//            info.AddValue("query", this.query);
//            info.AddValue("searchTotalResults", this.searchTotalResults);
//            info.AddValue("resultElements", this.resultElements);
//        }
//
//        /// <summary>
//		/// シリアライズされたものがデシリアライズされたときに呼ばれるコンストラクタ
//		/// </summary>
//        /// <param name="info">シリアル化に必要なすべてのデータ</param>
//        /// <param name="context">シリアル化ストリームの転送元と転送先</param>
//        protected GooBlogSearchResult(SerializationInfo info, StreamingContext context)
//		{
//            this.query = info.GetString("query");
//            this.searchTotalResults = info.GetInt64("searchTotalResults");
//            this.resultElements = (GooBlogElement[])info.GetValue("resultElements", typeof(GooBlogElement[]));
//        }
//
//        //#endregion
    }

