package slothLib.web.search;

/**
 * Yahoo! 動画検索の検索結果要素を格納するクラス
 */
//[Serializable]
public class YahooJpVideoElement implements IVideoElement, IRankedElement
{
	
	// コンストラクタ
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * コンストラクタ
         * @param rank 検索順位
	 * @param title 動画ファイルのタイトル
	 * @param summary 動画ファイルに関連するテキストサマリー
	 * @param url 動画ファイルやストリームのURL
	 * @param clickUrl 動画ファイルのリンクURL
	 * @param refererUrl 動画コンテンツを含むページのURL
	 * @param fileSize ファイルサイズ 単位はバイト
	 * @param fileFormat avi、flash、mpeg、msmedia、quicktime、またはrealmediaのいずれか
	 * @param height 動画から取得したキーフレームの高さ 単位はピクセル
	 * @param width 動画から取得したキーフレームの幅 単位はピクセル
	 * @param duration 動画ファイルの時間 単位は秒
	 * @param channels オーディオチャネル数 通常は1（モノラル）か2（ステレオ）
	 * @param streaming 動画ファイルがストリーミングである（true）か、ストリーミングでない（false）か
	 * @param thumbnailUrl サムネイルのURL
	 * @param thumbnailHeight サムネイルの高さ 単位はピクセル
	 * @param thumbnailWidth サムネイルの幅 単位はピクセル
	 * @param publisher 動画ファイルの提供者
	 * <param name="restrictions">このメディアオブジェクトの制限事項です。制限事項はnoframeまたはnoinlineです。
	 *                             noframeとは、サイト内のフレームで表示してはいけないことを意味します。
	 *                             noinlineとは、フレーム上のインラインオブジェクトとして表示してはいけないことを意味します
	 *                             （サイトに"referrer"などの保護がされているため、動作しません）</param>
	 * @param copyright オーナーのコピーライト
	 */
	public YahooJpVideoElement(int rank,String title, String summary, String url, String clickUrl, String refererUrl,
			String fileSize, String fileFormat, String height, String width, String duration, String channels, String streaming,
			String thumbnailUrl, String thumbnailHeight, String thumbnailWidth, String publisher,
			String restrictions, String copyright)
	{
		this.rank = rank;
		this.title = title; this.summary = summary; this.url = url; this.clickUrl = clickUrl; this.refererUrl = refererUrl;
		this.fileSize = fileSize; this.fileFormat = fileFormat; this.height = height; this.width = width; this.duration = duration;
		this.channels = channels; this.streaming = streaming; this.thumbnailUrl = thumbnailUrl;
		this.thumbnailHeight = thumbnailHeight; this.thumbnailWidth = thumbnailWidth; this.publisher = publisher; this.restrictions = restrictions;
		this.copyright = copyright;
	}
	

	
	
	// privateフィールド
	int rank;
	String title;
	String summary;
	String url;
	String clickUrl;
	String refererUrl;
	String fileSize;
	String fileFormat;
	String height;
	String width;
	String duration;
	String channels;
	String streaming;
	String thumbnailUrl;
	String thumbnailHeight;
	String thumbnailWidth;
	String publisher;
	String restrictions;
	String copyright;
	

	
	
	// プロパティ
	
	/**
	 * 動画のタイトル
	 */
	public String getTitle()
	{
		return this.title;
	}
	
	/**
	 * 動画ファイルに関連するテキストサマリー
	 */
	public String getSummary()
	{
		return this.summary;
	}
	
	/**
	 * 動画ファイルやストリームのURL
	 */
	public String getUrl()
	{
		return this.url;
	}
	
	/**
	 * 動画ファイルやリンクURL
	 */
	public String getClickUrl()
	{
		return this.clickUrl;
	}
	
	/**
	 * 動画コンテンツを含むページのURL
	 */
	public String getRefererUrl()
	{
		return this.refererUrl;
	}
	
	/**
	 * ファイルサイズ　単位はバイト
	 */
	public String getFileSize()
	{
		return this.fileSize;
	}
	
	/**
	 * avi、flash、mpeg、msmedia、quicktime、またはrealmediaのいずれか
	 */
	public String getFileFormat()
	{
		return this.fileFormat;
	}
	
	/**
	 * 動画から取得したキーフレームの高さ 単位はピクセル
	 */
	public int getHeight()
	{
		try
		{
			return Integer.parseInt(this.height);
		}
		catch (NumberFormatException e)
		{
		}
		return 0;
	}
	
	/**
	 * 動画から取得したキーフレームの幅 単位はピクセル
	 */
	public int getWidth()
	{
		try
		{
			return Integer.parseInt(this.width);
		}
		catch (NumberFormatException e)
		{
		}
		return 0;
	}
	
	/**
	 * 動画ファイルの時間 単位は秒
	 */
	public int getDuration()
	{
		try
		{
			return Integer.parseInt(this.duration);
		}
		catch (NumberFormatException e)
		{
		}
		return 0;
	}
	
	/**
	 * オーディオチャネル数 通常は1（モノラル）か2（ステレオ）
	 */
	public int getChannels()
	{
		try
		{
			
			return Integer.parseInt(this.channels);
		}
		catch (NumberFormatException e)
		{
		}
		return 0;
	}
	
	/**
	 * 動画ファイルがストリーミングである（true）か、ストリーミングでない（false）か
	 */
	public boolean getStreaming()
	{
		return Boolean.parseBoolean(this.streaming);
	}
	
	/**
	 * サムネイルのURL
	 */
	public String getThumbnail_Url()
	{
		return this.thumbnailUrl;
	}
	
	/**
	 * サムネイルの高さ 単位はピクセル
	 */
	public int getThumbnail_Height()
	{
		try
		{
			return Integer.parseInt(this.thumbnailHeight);
		}
		catch (NumberFormatException e)
		{
		}
		return 0;
	}
	
	/**
	 * サムネイルの幅 単位はピクセル
	 */
	public int getThumbnail_Width()
	{
		try
		{
			return Integer.parseInt(this.thumbnailWidth);
		}
		catch (NumberFormatException e)
		{
		}
		return 0;
	}
	
	/**
	 * 動画ファイルの提供者です。
	 */
	public String getPublisher()
	{
		return this.publisher;
		
	}
	
	/**
	 * オーナーのコピーライトです。
	 */
	public String getCopyright()
	{
		return this.copyright;
	}
	
	/**
	 * このメディアオブジェクトの制限事項
	 * noframeとは、サイト内のフレームで表示してはいけないことを意味します。
	 * noinlineとは、フレーム上のインラインオブジェクトとして表示してはいけないことを意味します
	 * サイトに"referrer"などの保護がされているため、動作しません)
	 */
	public String getRestrictions()
	{
		return this.restrictions;
	}
	

	
	
	
	
	
	// ISearchResultElement メンバ
	
	public String getURL()
	{
		return this.url;
		
	}
	
//	String ISearchResultElement.Title
//	{
//		get
//		{
//			return this.title;
//		}
//	}
	
	public String  getDescription()
	{
		return this.summary;
	}
	

	
	// IVideoElement メンバ
	
	public int duration()
	{
		try
		{
			return Integer.parseInt(this.duration);
		}
		catch (NumberFormatException e)
		{
			return 0;
		}
	}
	
	public String getThumbnailURL()
	{
		return this.thumbnailUrl;
	}



//        //#region ISerializable メンバ
//
//        /// <summary>
//        /// シリアライズ化するときに呼び出される関数
//        /// </summary>
//        /// <param name="info">逆シリアル化に必要なすべてのデータ</param>
//        /// <param name="context">シリアル化ストリームの転送元と転送先</param>
//        void System.Runtime.Serialization.ISerializable.GetObjectData(System.Runtime.Serialization.SerializationInfo info, System.Runtime.Serialization.StreamingContext context)
//        {
//			info.AddValue("rank", this.rank);
//			info.AddValue("title", this.title);
//			info.AddValue("summary", this.summary);
//			info.AddValue("url", this.url);
//			info.AddValue("clickUrl", this.clickUrl);
//            info.AddValue("refererUrl",this.refererUrl);
//            info.AddValue("restrictions",this.restrictions);
//            info.AddValue("channels",this.channels);
//            info.AddValue("copyright",this.copyright);
//            info.AddValue("duration", this.duration);
//            info.AddValue("fileFormat", this.fileFormat);
//            info.AddValue("fileSize", this.fileSize);
//            info.AddValue("height", this.height);
//            info.AddValue("width", this.width);
//            info.AddValue("publisher", this.publisher);
//            info.AddValue("streaming", this.streaming);
//            info.AddValue("thumbnailHeight", this.thumbnailHeight);
//            info.AddValue("thumbnailWidth", this.thumbnailWidth);
//            info.AddValue("thumbnailUrl", this.thumbnailUrl);
//		
//        }
//
//        /// <summary>
//        /// シリアライズされたものがデシリアライズされたときに呼ばれるコンストラクタ
//        /// </summary>
//        /// <param name="info">シリアル化に必要なすべてのデータ</param>
//        /// <param name="context">シリアル化ストリームの転送元と転送先</param>
//        protected YahooJpVideoElement(SerializationInfo info, StreamingContext context)
//        {
//            this.channels = info.GetString("channels");
//            this.clickUrl = info.GetString("clickUrl");
//            this.copyright = info.GetString("copyright");
//            this.duration = info.GetString("duration");
//            this.fileFormat = info.GetString("fileFormat");
//            this.fileSize = info.GetString("fileSize");
//            this.height = info.GetString("height");
//            this.publisher = info.GetString("publisher");
//            this.rank = info.GetInt32("rank");
//            this.refererUrl = info.GetString("refererUrl");
//            this.restrictions = info.GetString("restrictions");
//            this.streaming = info.GetString("streaming");
//            this.summary = info.GetString("summary");
//            this.thumbnailHeight = info.GetString("thumbnailHeight");
//            this.thumbnailUrl = info.GetString("thumnailUrl");
//            this.thumbnailWidth = info.GetString("thumnailWidth");
//            this.title = info.GetString("title");
//            this.url = info.GetString("url");
//            this.width = info.GetString("width");
//        }
//
//        //#endregion
//
//        //#region IRankedElement メンバ
//
        public int getRank()
        {
        	return this.rank;
      	}

//        //#endregion
//


}
