package slothLib.web.search;

/**
 * キャッシュした検索結果要素
 */

public class CachedElement implements ISearchResultElement, IWebElement, IRankedElement
{
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private ISearchResultElement searchResultElement;
	
	/**
	 * コンストラクタ
	 * @param searchResultElement キャッシュする検索結果要素
	 */
	public CachedElement(ISearchResultElement searchResultElement)
	{
		this.searchResultElement = searchResultElement;
	}
	
	/**
	 * ページのURL
	 */
	public String getURL()
	{
		return this.searchResultElement.getURL(); 
	}
	
	/**
	 * ページのタイトル
	 */
	public String getTitle()
	{
		return this.searchResultElement.getTitle(); 
	}
	
	/**
	 * ページの要約
	 */
	public String getDescription()
	{
		return this.searchResultElement.getDescription();
	}
	


	/**
	 * シリアライズ化するときに呼び出される関数
	 * @param info 逆シリアル化に必要なすべてのデータ
	 * @param context シリアル化ストリームの転送元と転送先
 *	public void GetObjectData(System.Runtime.Serialization.SerializationInfo info, System.Runtime.Serialization.StreamingContext context)
 *	{
 *	info.AddValue("searchResultElement", this.searchResultElement);
 *	}
	 */
	
	/**
	 * シリアライズされたものがデシリアライズされたときに呼ばれるコンストラクタ
	 * @param info シリアル化に必要なすべてのデータ
	 * @param context シリアル化ストリームの転送元と転送先
 *	protected CachedElement(SerializationInfo info, StreamingContext context)
 *	{
 *		this.searchResultElement = (ISearchResultElement)info.GetValue("searchResultElement", typeof(ISearchResultElement));
 *	}
	 */
	

	
///		#region IRankedElement メンバ

	/**
	 * 検索順位
	 */
	public int getRank()
	{
		if (this.searchResultElement instanceof IRankedElement)
		{
			IRankedElement rankedElement = (IRankedElement)this.searchResultElement;
			return rankedElement.getRank();
		}
		else
		{
			return 0;
		}
	}
}
