//using System;
//using System.Collections.Generic;
//using System.Text;
//using System.Net;
//using System.IO;
//using System.Runtime.Serialization;
//using System.Text.RegularExpressions;


package slothLib.web.webLoader;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.HttpCookie;
import java.net.URI;
import java.util.Date;
import java.util.List;

import slothLib.portUtil.PortUtil;

/**
	 * 取得したWebページの結果を保存するクラス。
 */
//[Serializable]
	public class WebGetResult implements Serializable
	{
		/**
		 * 
		 */
		private static final long serialVersionUID = 1L;
		private String url;
		private String localFilePath;
		private HttpHeader header;
		private String response;

		/**
		 * コンストラクタSerializable
		 * @param url 取得元のURL
		 * @param localFilePath 保存したファイルの場所
		 * @param header ファイルのヘッダー
		 * @param response サーバからのレスポンス（OKのみなら正常取得）
		 */
		public WebGetResult(String url, String localFilePath, HttpHeader header, String response)
		{
			this.url = url;
			this.localFilePath = localFilePath;
			this.header = header;
			this.response = response;

            /*
			String noExtensionFilePath = localFilePath.SubString(0, localFilePath.Length - 3);

			// コンテンツタイプに応じて拡張子を変更する。
			switch (this.header.ContentType)
			{
				case "text/html":
					this.MoveFile(noExtensionFilePath + "html");
					break;
				case "application/pdf":
					this.MoveFile(noExtensionFilePath + "pdf");
					break;
				case "application/msword":
					this.MoveFile(noExtensionFilePath + "doc");
					break;
				default:
					break;
			}
             */


			System.err.println("Path: " + this.localFilePath);
		}
		/**
		 * 取得元のURL
		 */
		public String getURL()
		{
			return this.url; 
		}
		/**
		 * 保存したファイルの場所
		 */
		public String getLocalFilePath()
		{
			return this.localFilePath;
		}

		public void setLocalFilePath(String value)
		{
			this.moveFile(value);
		}
		/**
		 * ファイルのヘッダー
		 */
		public HttpHeader getHeader()
		{
			return this.header; 
		}
		/**
		 * レスポンス
		 */
		public String getResponse()
		{
			return this.response; 
        }

        // 拡張子変更
        /**
         * ファイルの拡張子を変更する
         */
        public void changeExtension()
        {
            //String extension = Regex.Match(localFilePath, @"[^\\]*(\..+)$").Groups[1].Value;
            //String noExtensionFilePath = localFilePath.SubString(0, localFilePath.Length - extension.Length);

            // コンテンツタイプに応じて拡張子を変更する。
        	String contentType = this.header.getContentType();
        	if (contentType.equals("text/html"))
        	{
                this.moveFile(localFilePath + ".html");
        	}               
        	else if (contentType.equals("application/pdf"))
        	{
        		this.moveFile(localFilePath + ".pdf");
        	}
        	else if (contentType.equals("application/msword"))
        	{
        		this.moveFile(localFilePath + ".doc");
        	}
        }


        // File移動（名前変更コミ）

        /**
		 * ファイルを移動させる
		 * @param destFileName 
         */
		public void moveFile(String destFileName)
		{
			// ディレクトリがない場合は作成する。
			File fi = new File(destFileName);
			File di = new File(fi.getParent());
			if (PortUtil.fileExists(di.getAbsolutePath()))
			{
				di.mkdirs();
			}

			// すでにファイルが存在しているときは、上書きする。
			if (PortUtil.fileExists(fi.getAbsolutePath()))
			{
				try {
					PortUtil.fileDelete(fi.getAbsolutePath());
				} catch (IOException e){
					// ignore.
				}
			}

			// ファイルの移動
			(new File(this.localFilePath)).renameTo(fi);
			// localFilePathの書き換え
			this.localFilePath = destFileName;
		}





		// File削除

		/**
		 * データを格納しているファイルを削除する
		 */
		public void deleteFile()
		{
			if (PortUtil.fileExists(this.localFilePath))
			{
				try {
					PortUtil.fileDelete(this.localFilePath);
				} catch (IOException e){
					// ignore.
				}
			}
		}



//		//#region ISerializable メンバ
//
//		/// <summary>
//		/// シリアライズ化するときに呼び出される関数
//		/// </summary>
//		/// <param name="info">逆シリアル化に必要なすべてのデータ</param>
//		/// <param name="context">シリアル化ストリームの転送元と転送先</param>
//		void ISerializable.GetObjectData(SerializationInfo info, StreamingContext context)
//		{
//			info.AddValue("url", this.url);
//			info.AddValue("header", this.header);
//			info.AddValue("localFilePath", this.localFilePath);
//			info.AddValue("response", this.response);
//		}
//
//
//		/// <summary>
//		/// シリアライズされたものがデシリアライズされたときに呼ばれるコンストラクタ
//		/// </summary>
//		/// <param name="info">シリアル化に必要なすべてのデータ</param>
//		/// <param name="context">シリアル化ストリームの転送元と転送先</param>
//		protected WebGetResult(SerializationInfo info, StreamingContext context)
//		{
//			this.url = info.GetString("url");
//			this.header = (HttpHeader)info.GetValue("header", typeof(HttpHeader));
//			this.localFilePath = info.GetString("localFilePath");
//			this.response = info.GetString("response");
//		}


	}

