/*
 * Programming Language SOOPY
 *   (Simple Object Oriented Programming sYstem)
 * 
 * Copyright (C) 2002-2004 SUZUKI Jun
 * 
 * URL: http://sourceforge.jp/projects/soopy/
 * License: GPL(GNU General Public License)
 * 
 * 
 * $Id: Byte.cpp,v 1.16 2004/05/22 05:22:34 randy Exp $
 */

#include "soopy.h"

/*
 * ByteFile
 *   openIn, openOut, openAppend
 */

SpValue& byte_openIn(SpValue& v)
{
    SpValue name = v.eval();
    if(!name.isString()){
        throw SpException("filename is not string (ByteFile.openIn)");
    }
    SpString* str = name.asString();
    char* filename = (char*)str->toCStringWithEncoder();
    ifstream* fin = new ifstream;
#ifdef __WIN32__
    fin->open(filename, ios::binary);
#else
    fin->open(filename);
#endif
    if(fin->fail()){
        delete fin;
        throw SpException("can't open file");
    }
    FileStreamReader* sr = new FileStreamReader(fin, filename);
    return SpObjectResult(sr);
}

SpValue& byte_openOut(SpValue& v)
{
    SpValue name = v.eval();
    if(!name.isString()){
        throw SpException("filename is not string (ByteFile.openOut)");
    }
    SpString* str = name.asString();
    char* filename = (char*)str->toCStringWithEncoder();
    ofstream* fout = new ofstream;
#ifdef __WIN32__
    fout->open(filename, ios::binary);
#else
    fout->open(filename);
#endif
    if(fout->fail()){
        delete fout;
        throw SpException("can't open file");
    }
    FileStreamWriter* sw = new FileStreamWriter(fout, filename);
    return SpObjectResult(sw);
}

SpValue& byte_openAppend(SpValue& v)
{
    SpValue name = v.eval();
    if(!name.isString()){
        throw SpException("filename is not string (Byte.openAppend)");
    }
    SpString* str = name.asString();
    char* filename = (char*)str->toCStringWithEncoder();
    ofstream* fout = new ofstream;
#ifdef __WIN32__
    fout->open(filename, ios::app | ios::binary);
#else
    fout->open(filename, ios::app);
#endif
    if(fout->fail()){
        delete fout;
        throw SpException("can't open file");
    }
    FileStreamWriter* sw = new FileStreamWriter(fout, filename);
    return SpObjectResult(sw);
}

void initByteFile()
{
    SpValue SymByteFile(new SpSymbol("byte"));
    SpNameSpace* ns = new SpNameSpace;
    SpValue NSByteFile(ns);
    PMainNameSpace->internConst(SymByteFile, NSByteFile);

    SpValue PrimOpenIn(new SpPrim1(&byte_openIn));
    ns->internConst(SymOpenIn, PrimOpenIn);

    SpValue PrimOpenOut(new SpPrim1(&byte_openOut));
    ns->internConst(SymOpenOut, PrimOpenOut);

    SpValue PrimOpenAppend(new SpPrim1(&byte_openAppend));
    ns->internConst(SymOpenAppend, PrimOpenAppend);
}


