/*
 * Programming Language SOOPY
 *   (Simple Object Oriented Programming sYstem)
 * 
 * Copyright (C) 2002,2003 SUZUKI Jun
 * 
 * URL: http://sourceforge.jp/projects/soopy/
 * License: GPL(GNU General Public License)
 * 
 * 
 * $Id: CR_LF.cpp,v 1.11 2004/05/22 05:22:34 randy Exp $
 */

#include "soopy.h"

/*
 * CRLF -> LF
 */

/*
 * Class CRLF2LFReadEncoder
 */

SpChar CRLF2LFReadEncoder::readCh()
{
    SpChar c;

    if(eof()){ return (SpChar)NULL; }
    c = reader->ReadChar();
    SpChar c2 = SpCharGetChar(c);
    if(c2 == CR){
        SpChar ch = reader->ReadChar();
        SpChar ch2 = SpCharGetChar(ch);
        if(ch2 == LF){
            return MakeSpChar(CodeJIS, LF);
        }else{
            reader->UnreadChar(ch);
            return c;
        }
    }
    return c;
}

/*
 * Class CRLF2LFWriter
 */

void CRLF2LFWriteEncoder::WriteChar(SpChar ch)
{
    SpChar c = SpCharGetChar(ch);

    if(prevCR){
        prevCR = false;
        if(c == LF){
            writer->WriteChar(MakeSpChar(CodeJIS, LF));
            return;
        }else{
            writer->WriteChar(MakeSpChar(CodeJIS, CR));
        }
    }

    if(c == CR){
        prevCR = true;
    }else{
        writer->WriteChar(ch);
    }
}


/*
 * CRLF2LFFile
 *   openIn, openOut
 */

SpValue& crlf2lf_openIn(SpValue& v)
{
    SpValue name = v.eval();
    if(!name.isString()){
        throw SpException("filename is not string (CRLF2LF.openIn)");
    }
    SpString* str = name.asString();
    char* filename = (char*)str->toCStringWithEncoder();
    ifstream* fin = new ifstream;
    fin->open(filename);
    if(fin->fail()){
        delete fin;
        throw SpException("can't open file");
    }
    FileStreamReader* sr = new FileStreamReader(fin, filename);
    ReadEncoder* encoder = new CRLF2LFReadEncoder(sr);
    return SpObjectResult(encoder);
}

SpValue& crlf2lf_openOut(SpValue& v)
{
    SpValue name = v.eval();
    if(!name.isString()){
        throw SpException("filename is not string (CRLF2LF.openOut)");
    }
    SpString* str = name.asString();
    char* filename = (char*)str->toCStringWithEncoder();
    ofstream* fout = new ofstream;
    fout->open(filename);
    if(fout->fail()){
        delete fout;
        throw SpException("can't open file");
    }
    FileStreamWriter* sw = new FileStreamWriter(fout, filename);
    WriteEncoder* encoder = new CRLF2LFWriteEncoder(sw);
    return SpObjectResult(encoder);
}

SpValue& crlf2lf_openAppend(SpValue& v)
{
    SpValue name = v.eval();
    if(!name.isString()){
        throw SpException("filename is not string (CRLF2LF.openAppend)");
    }
    SpString* str = name.asString();
    char* filename = (char*)str->toCStringWithEncoder();
    ofstream* fout = new ofstream;
#ifdef __WIN32__
    fout->open(filename, ios::app | ios::binary);
#else
    fout->open(filename, ios::app);
#endif
    if(fout->fail()){
        delete fout;
        throw SpException("can't open file");
    }
    FileStreamWriter* sw = new FileStreamWriter(fout, filename);
    WriteEncoder* encoder = new CRLF2LFWriteEncoder(sw);
    return SpObjectResult(encoder);
}

SpValue& crlf2lf_encoderIn(SpValue& v)
{
    SpValue r = v.eval();
    if(!r.isReader()){
        throw SpException("not reader (CRLF2LF.encoderIn)");
    }
    Reader* reader = r.asReader();
    ReadEncoder* encoder = new CRLF2LFReadEncoder(reader);
    return SpObjectResult(encoder);
}

SpValue& crlf2lf_encoderOut(SpValue& v)
{
    SpValue w = v.eval();
    if(!w.isWriter()){
        throw SpException("not writer (CRLF2LF.encoderOut)");
    }
    Writer* writer = w.asWriter();
    WriteEncoder* encoder = new CRLF2LFWriteEncoder(writer);
    return SpObjectResult(encoder);
}

// init
void initCRLF2LF()
{
    SpValue SymCRLF2LF(new SpSymbol("crlf2lf"));
    SpNameSpace* ns = new SpNameSpace;
    SpValue NSCRLF2LF(ns);
    PMainNameSpace->internConst(SymCRLF2LF, NSCRLF2LF);

    SpValue PrimOpenIn(new SpPrim1(&crlf2lf_openIn));
    ns->internConst(SymOpenIn, PrimOpenIn);
    SpValue PrimEncoderIn(new SpPrim1(&crlf2lf_encoderIn));
    ns->internConst(SymEncoderIn, PrimEncoderIn);

    SpValue PrimOpenOut(new SpPrim1(&crlf2lf_openOut));
    ns->internConst(SymOpenOut, PrimOpenOut);

    SpValue PrimOpenAppend(new SpPrim1(&crlf2lf_openAppend));
    ns->internConst(SymOpenAppend, PrimOpenAppend);

    SpValue PrimEncoderOut(new SpPrim1(&crlf2lf_encoderOut));
    ns->internConst(SymEncoderOut, PrimEncoderOut);
}

/*
 * CRLF -> CR
 */

/*
 * Class CRLF2CRReadEncoder
 */

SpChar CRLF2CRReadEncoder::readCh()
{
    SpChar c;

    if(eof()){ return (SpChar)NULL; }
    c = reader->ReadChar();
    SpChar c2 = SpCharGetChar(c);
    if(c2 == CR){
        SpChar ch = reader->ReadChar();
        SpChar ch2 = SpCharGetChar(ch);
        if(ch2 == LF){
            return MakeSpChar(CodeJIS, CR);
        }else{
            reader->UnreadChar(ch);
            return c;
        }
    }
    return c;
}

/*
 * Class CRLF2CRWriter
 */

void CRLF2CRWriteEncoder::WriteChar(SpChar ch)
{
    SpChar c = SpCharGetChar(ch);

    if(prevCR){
        prevCR = false;
        if(c == LF){
            writer->WriteChar(MakeSpChar(CodeJIS, CR));
            return;
        }else{
            writer->WriteChar(MakeSpChar(CodeJIS, CR));
        }
    }

    if(c == CR){
        prevCR = true;
    }else{
        writer->WriteChar(ch);
    }
}


/*
 * CRLF2CRFile
 *   openIn, openOut
 */

SpValue& crlf2cr_openIn(SpValue& v)
{
    SpValue name = v.eval();
    if(!name.isString()){
        throw SpException("filename is not string (CRLF2CR.openIn)");
    }
    SpString* str = name.asString();
    char* filename = (char*)str->toCStringWithEncoder();
    ifstream* fin = new ifstream;
    fin->open(filename);
    if(fin->fail()){
        delete fin;
        throw SpException("can't open file");
    }
    FileStreamReader* sr = new FileStreamReader(fin, filename);
    ReadEncoder* encoder = new CRLF2CRReadEncoder(sr);
    return SpObjectResult(encoder);
}

SpValue& crlf2cr_openOut(SpValue& v)
{
    SpValue name = v.eval();
    if(!name.isString()){
        throw SpException("filename is not string (CRLF2CR.openOut)");
    }
    SpString* str = name.asString();
    char* filename = (char*)str->toCStringWithEncoder();
    ofstream* fout = new ofstream;
    fout->open(filename);
    if(fout->fail()){
        delete fout;
        throw SpException("can't open file");
    }
    FileStreamWriter* sw = new FileStreamWriter(fout, filename);
    WriteEncoder* encoder = new CRLF2CRWriteEncoder(sw);
    return SpObjectResult(encoder);
}

SpValue& crlf2cr_openAppend(SpValue& v)
{
    SpValue name = v.eval();
    if(!name.isString()){
        throw SpException("filename is not string (CRLF2CR.openAppend)");
    }
    SpString* str = name.asString();
    char* filename = (char*)str->toCStringWithEncoder();
    ofstream* fout = new ofstream;
#ifdef __WIN32__
    fout->open(filename, ios::app | ios::binary);
#else
    fout->open(filename, ios::app);
#endif
    if(fout->fail()){
        delete fout;
        throw SpException("can't open file");
    }
    FileStreamWriter* sw = new FileStreamWriter(fout, filename);
    WriteEncoder* encoder = new CRLF2CRWriteEncoder(sw);
    return SpObjectResult(encoder);
}

SpValue& crlf2cr_encoderIn(SpValue& v)
{
    SpValue r = v.eval();
    if(!r.isReader()){
        throw SpException("not reader (CRLF2CR.encoderIn)");
    }
    Reader* reader = r.asReader();
    ReadEncoder* encoder = new CRLF2CRReadEncoder(reader);
    return SpObjectResult(encoder);
}

SpValue& crlf2cr_encoderOut(SpValue& v)
{
    SpValue w = v.eval();
    if(!w.isWriter()){
        throw SpException("not writer (CRLF2CR.encoderOut)");
    }
    Writer* writer = w.asWriter();
    WriteEncoder* encoder = new CRLF2CRWriteEncoder(writer);
    return SpObjectResult(encoder);
}

// init
void initCRLF2CR()
{
    SpValue SymCRLF2CR(new SpSymbol("crlf2cr"));
    SpNameSpace* ns = new SpNameSpace;
    SpValue NSCRLF2CR(ns);
    PMainNameSpace->internConst(SymCRLF2CR, NSCRLF2CR);

    SpValue PrimOpenIn(new SpPrim1(&crlf2cr_openIn));
    ns->internConst(SymOpenIn, PrimOpenIn);
    SpValue PrimEncoderIn(new SpPrim1(&crlf2cr_encoderIn));
    ns->internConst(SymEncoderIn, PrimEncoderIn);

    SpValue PrimOpenOut(new SpPrim1(&crlf2cr_openOut));
    ns->internConst(SymOpenOut, PrimOpenOut);

    SpValue PrimOpenAppend(new SpPrim1(&crlf2cr_openAppend));
    ns->internConst(SymOpenAppend, PrimOpenAppend);

    SpValue PrimEncoderOut(new SpPrim1(&crlf2cr_encoderOut));
    ns->internConst(SymEncoderOut, PrimEncoderOut);
}

/*
 * LF -> CRLF
 */

/*
 * Class LF2CRLFReadEncoder
 */

SpChar LF2CRLFReadEncoder::readCh()
{
    SpChar c;

    if(prevLF){
        prevLF = false;
        return MakeSpChar(CodeJIS, LF);
    }else{
        if(eof()){ return (SpChar)NULL; }
        c = reader->ReadChar();
        if(SpCharGetChar(c) == LF){
            prevLF = true;
            return MakeSpChar(CodeJIS, CR);
        }
    }
    return c;
}

/*
 * Class LF2CRLFWriter
 */

void LF2CRLFWriteEncoder::WriteChar(SpChar ch)
{
    SpChar c = SpCharGetChar(ch);
    if(c == LF){
        writer->WriteChar(MakeSpChar(CodeJIS, CR));
        writer->WriteChar(MakeSpChar(CodeJIS, LF));
    }else{
        writer->WriteChar(ch);
    }
}


/*
 * LF2CRLFFile
 *   openIn, openOut
 */

SpValue& lf2crlf_openIn(SpValue& v)
{
    SpValue name = v.eval();
    if(!name.isString()){
        throw SpException("filename is not string (LF2CRLF.openIn)");
    }
    SpString* str = name.asString();
    char* filename = (char*)str->toCStringWithEncoder();
    ifstream* fin = new ifstream;
    fin->open(filename);
    if(fin->fail()){
        delete fin;
        throw SpException("can't open file");
    }
    FileStreamReader* sr = new FileStreamReader(fin, filename);
    ReadEncoder* encoder = new LF2CRLFReadEncoder(sr);
    return SpObjectResult(encoder);
}

SpValue& lf2crlf_openOut(SpValue& v)
{
    SpValue name = v.eval();
    if(!name.isString()){
        throw SpException("filename is not string (LF2CRLF.openOut)");
    }
    SpString* str = name.asString();
    char* filename = (char*)str->toCStringWithEncoder();
    ofstream* fout = new ofstream;
    fout->open(filename);
    if(fout->fail()){
        delete fout;
        throw SpException("can't open file");
    }
    FileStreamWriter* sw = new FileStreamWriter(fout, filename);
    WriteEncoder* encoder = new LF2CRLFWriteEncoder(sw);
    //    static SpValue result;
    //    result.setNewObject(encoder);
    //    return result;
    return SpObjectResult(encoder);
}

SpValue& lf2crlf_openAppend(SpValue& v)
{
    SpValue name = v.eval();
    if(!name.isString()){
        throw SpException("filename is not string (LF2CRLF.openAppend)");
    }
    SpString* str = name.asString();
    char* filename = (char*)str->toCStringWithEncoder();
    ofstream* fout = new ofstream;
#ifdef __WIN32__
    fout->open(filename, ios::app | ios::binary);
#else
    fout->open(filename, ios::app);
#endif
    if(fout->fail()){
        delete fout;
        throw SpException("can't open file");
    }
    FileStreamWriter* sw = new FileStreamWriter(fout, filename);
    WriteEncoder* encoder = new LF2CRLFWriteEncoder(sw);
    return SpObjectResult(encoder);
}

SpValue& lf2crlf_encoderIn(SpValue& v)
{
    SpValue r = v.eval();
    if(!r.isReader()){
        throw SpException("not reader (LF2CRLF.encoderIn)");
    }
    Reader* reader = r.asReader();
    ReadEncoder* encoder = new LF2CRLFReadEncoder(reader);
    return SpObjectResult(encoder);
}

SpValue& lf2crlf_encoderOut(SpValue& v)
{
    SpValue w = v.eval();
    if(!w.isWriter()){
        throw SpException("not writer (LF2CRLF.encoderOut)");
    }
    Writer* writer = w.asWriter();
    WriteEncoder* encoder = new LF2CRLFWriteEncoder(writer);
    return SpObjectResult(encoder);
}

// init
void initLF2CRLF()
{
    SpValue SymLF2CRLF(new SpSymbol("lf2crlf"));
    SpNameSpace* ns = new SpNameSpace;
    SpValue NSLF2CRLF(ns);
    PMainNameSpace->internConst(SymLF2CRLF, NSLF2CRLF);

    SpValue PrimOpenIn(new SpPrim1(&lf2crlf_openIn));
    ns->internConst(SymOpenIn, PrimOpenIn);
    SpValue PrimEncoderIn(new SpPrim1(&lf2crlf_encoderIn));
    ns->internConst(SymEncoderIn, PrimEncoderIn);

    SpValue PrimOpenOut(new SpPrim1(&lf2crlf_openOut));
    ns->internConst(SymOpenOut, PrimOpenOut);

    SpValue PrimOpenAppend(new SpPrim1(&lf2crlf_openAppend));
    ns->internConst(SymOpenAppend, PrimOpenAppend);

    SpValue PrimEncoderOut(new SpPrim1(&lf2crlf_encoderOut));
    ns->internConst(SymEncoderOut, PrimEncoderOut);
}

/*
 * CR -> CRLF
 */

/*
 * Class CR2CRLFReadEncoder
 */

SpChar CR2CRLFReadEncoder::readCh()
{
    SpChar c;

    if(prevCR){
        prevCR = false;
        return MakeSpChar(CodeJIS, LF);
    }else{
        c = reader->ReadChar();
        if(eof()){ return (SpChar)NULL; }
        if(SpCharGetChar(c) == CR){
            prevCR = true;
            return MakeSpChar(CodeJIS, CR);
        }
    }
    return c;
}

/*
 * Class CR2CRLFWriter
 */

void CR2CRLFWriteEncoder::WriteChar(SpChar ch)
{
    SpChar c = SpCharGetChar(ch);
    if(c == CR){
        writer->WriteChar(MakeSpChar(CodeJIS, CR));
        writer->WriteChar(MakeSpChar(CodeJIS, LF));
    }else{
        writer->WriteChar(ch);
    }
}


/*
 * CR2CRLFFile
 *   openIn, openOut
 */

SpValue& cr2crlf_openIn(SpValue& v)
{
    SpValue name = v.eval();
    if(!name.isString()){
        throw SpException("filename is not string (CR2CRLF.openIn)");
    }
    SpString* str = name.asString();
    char* filename = (char*)str->toCStringWithEncoder();
    ifstream* fin = new ifstream;
    fin->open(filename);
    if(fin->fail()){
        delete fin;
        throw SpException("can't open file");
    }
    FileStreamReader* sr = new FileStreamReader(fin, filename);
    ReadEncoder* encoder = new CR2CRLFReadEncoder(sr);
    return SpObjectResult(encoder);
}

SpValue& cr2crlf_openOut(SpValue& v)
{
    SpValue name = v.eval();
    if(!name.isString()){
        throw SpException("filename is not string (CR2CRLF.openOut)");
    }
    SpString* str = name.asString();
    char* filename = (char*)str->toCStringWithEncoder();
    ofstream* fout = new ofstream;
    fout->open(filename);
    if(fout->fail()){
        delete fout;
        throw SpException("can't open file");
    }
    FileStreamWriter* sw = new FileStreamWriter(fout, filename);
    WriteEncoder* encoder = new CR2CRLFWriteEncoder(sw);
    return SpObjectResult(encoder);
}

SpValue& cr2crlf_openAppend(SpValue& v)
{
    SpValue name = v.eval();
    if(!name.isString()){
        throw SpException("filename is not string (CR2CRLF.openAppend)");
    }
    SpString* str = name.asString();
    char* filename = (char*)str->toCStringWithEncoder();
    ofstream* fout = new ofstream;
#ifdef __WIN32__
    fout->open(filename, ios::app | ios::binary);
#else
    fout->open(filename, ios::app);
#endif
    if(fout->fail()){
        delete fout;
        throw SpException("can't open file");
    }
    FileStreamWriter* sw = new FileStreamWriter(fout, filename);
    WriteEncoder* encoder = new CR2CRLFWriteEncoder(sw);
    return SpObjectResult(encoder);
}

SpValue& cr2crlf_encoderIn(SpValue& v)
{
    SpValue r = v.eval();
    if(!r.isReader()){
        throw SpException("not reader (CR2CRLF.encoderIn)");
    }
    Reader* reader = r.asReader();
    ReadEncoder* encoder = new CR2CRLFReadEncoder(reader);
    return SpObjectResult(encoder);
}

SpValue& cr2crlf_encoderOut(SpValue& v)
{
    SpValue w = v.eval();
    if(!w.isWriter()){
        throw SpException("not writer (CR2CRLF.encoderOut)");
    }
    Writer* writer = w.asWriter();
    WriteEncoder* encoder = new CR2CRLFWriteEncoder(writer);
    return SpObjectResult(encoder);
}

// init
void initCR2CRLF()
{
    SpValue SymCR2CRLF(new SpSymbol("cr2crlf"));
    SpNameSpace* ns = new SpNameSpace;
    SpValue NSCR2CRLF(ns);
    PMainNameSpace->internConst(SymCR2CRLF, NSCR2CRLF);

    SpValue PrimOpenIn(new SpPrim1(&cr2crlf_openIn));
    ns->internConst(SymOpenIn, PrimOpenIn);
    SpValue PrimEncoderIn(new SpPrim1(&cr2crlf_encoderIn));
    ns->internConst(SymEncoderIn, PrimEncoderIn);

    SpValue PrimOpenOut(new SpPrim1(&cr2crlf_openOut));
    ns->internConst(SymOpenOut, PrimOpenOut);

    SpValue PrimOpenAppend(new SpPrim1(&cr2crlf_openAppend));
    ns->internConst(SymOpenAppend, PrimOpenAppend);

    SpValue PrimEncoderOut(new SpPrim1(&cr2crlf_encoderOut));
    ns->internConst(SymEncoderOut, PrimEncoderOut);
}

/*
 * CR -> LF
 */

/*
 * Class CR2LFReadEncoder
 */

SpChar CR2LFReadEncoder::readCh()
{
    if(eof()){ return (SpChar)NULL; }
    SpChar c = reader->ReadChar();
    if(SpCharGetChar(c) == CR){
        return MakeSpChar(CodeJIS, LF);
    }
    return c;
}

/*
 * Class CR2LFWriter
 */

void CR2LFWriteEncoder::WriteChar(SpChar ch)
{
    SpChar c = SpCharGetChar(ch);
    if(c == CR){
        writer->WriteChar(MakeSpChar(CodeJIS, LF));
    }else{
        writer->WriteChar(ch);
    }
}


/*
 * CR2LFFile
 *   openIn, openOut
 */

SpValue& cr2lf_openIn(SpValue& v)
{
    SpValue name = v.eval();
    if(!name.isString()){
        throw SpException("filename is not string (CR2LF.openIn)");
    }
    SpString* str = name.asString();
    char* filename = (char*)str->toCStringWithEncoder();
    ifstream* fin = new ifstream;
    fin->open(filename);
    if(fin->fail()){
        delete fin;
        throw SpException("can't open file");
    }
    FileStreamReader* sr = new FileStreamReader(fin, filename);
    ReadEncoder* encoder = new CR2LFReadEncoder(sr);
    return SpObjectResult(encoder);
}

SpValue& cr2lf_openOut(SpValue& v)
{
    SpValue name = v.eval();
    if(!name.isString()){
        throw SpException("filename is not string (CR2LF.openOut)");
    }
    SpString* str = name.asString();
    char* filename = (char*)str->toCStringWithEncoder();
    ofstream* fout = new ofstream;
    fout->open(filename);
    if(fout->fail()){
        delete fout;
        throw SpException("can't open file");
    }
    FileStreamWriter* sw = new FileStreamWriter(fout, filename);
    WriteEncoder* encoder = new CR2LFWriteEncoder(sw);
    return SpObjectResult(encoder);
}

SpValue& cr2lf_openAppend(SpValue& v)
{
    SpValue name = v.eval();
    if(!name.isString()){
        throw SpException("filename is not string (CR2LF.openAppend)");
    }
    SpString* str = name.asString();
    char* filename = (char*)str->toCStringWithEncoder();
    ofstream* fout = new ofstream;
#ifdef __WIN32__
    fout->open(filename, ios::app | ios::binary);
#else
    fout->open(filename, ios::app);
#endif
    if(fout->fail()){
        delete fout;
        throw SpException("can't open file");
    }
    FileStreamWriter* sw = new FileStreamWriter(fout, filename);
    WriteEncoder* encoder = new CR2LFWriteEncoder(sw);
    return SpObjectResult(encoder);
}

SpValue& cr2lf_encoderIn(SpValue& v)
{
    SpValue r = v.eval();
    if(!r.isReader()){
        throw SpException("not reader (CR2LF.encoderIn)");
    }
    Reader* reader = r.asReader();
    ReadEncoder* encoder = new CR2LFReadEncoder(reader);
    return SpObjectResult(encoder);
}

SpValue& cr2lf_encoderOut(SpValue& v)
{
    SpValue w = v.eval();
    if(!w.isWriter()){
        throw SpException("not writer (CR2LF.encoderOut)");
    }
    Writer* writer = w.asWriter();
    WriteEncoder* encoder = new CR2LFWriteEncoder(writer);
    return SpObjectResult(encoder);
}

// init
void initCR2LF()
{
    SpValue SymCR2LF(new SpSymbol("cr2lf"));
    SpNameSpace* ns = new SpNameSpace;
    SpValue NSCR2LF(ns);
    PMainNameSpace->internConst(SymCR2LF, NSCR2LF);

    SpValue PrimOpenIn(new SpPrim1(&cr2lf_openIn));
    ns->internConst(SymOpenIn, PrimOpenIn);
    SpValue PrimEncoderIn(new SpPrim1(&cr2lf_encoderIn));
    ns->internConst(SymEncoderIn, PrimEncoderIn);

    SpValue PrimOpenOut(new SpPrim1(&cr2lf_openOut));
    ns->internConst(SymOpenOut, PrimOpenOut);

    SpValue PrimOpenAppend(new SpPrim1(&cr2lf_openAppend));
    ns->internConst(SymOpenAppend, PrimOpenAppend);

    SpValue PrimEncoderOut(new SpPrim1(&cr2lf_encoderOut));
    ns->internConst(SymEncoderOut, PrimEncoderOut);
}

/*
 * LF -> CR
 */

/*
 * Class LF2CRReadEncoder
 */

SpChar LF2CRReadEncoder::readCh()
{
    if(eof()){ return (SpChar)NULL; }
    SpChar c = reader->ReadChar();
    if(SpCharGetChar(c) == LF){
        return MakeSpChar(CodeJIS, CR);
    }
    return c;
}

/*
 * Class LF2CRWriter
 */

void LF2CRWriteEncoder::WriteChar(SpChar ch)
{
    SpChar c = SpCharGetChar(ch);
    if(c == LF){
        writer->WriteChar(MakeSpChar(CodeJIS, CR));
    }else{
        writer->WriteChar(ch);
    }
}


/*
 * LF2CRFile
 *   openIn, openOut
 */

SpValue& lf2cr_openIn(SpValue& v)
{
    SpValue name = v.eval();
    if(!name.isString()){
        throw SpException("filename is not string (LF2CR.openIn)");
    }
    SpString* str = name.asString();
    char* filename = (char*)str->toCStringWithEncoder();
    ifstream* fin = new ifstream;
    fin->open(filename);
    if(fin->fail()){
        delete fin;
        throw SpException("can't open file");
    }
    FileStreamReader* sr = new FileStreamReader(fin, filename);
    ReadEncoder* encoder = new LF2CRReadEncoder(sr);
    return SpObjectResult(encoder);
}

SpValue& lf2cr_openOut(SpValue& v)
{
    SpValue name = v.eval();
    if(!name.isString()){
        throw SpException("filename is not string (LF2CR.openOut)");
    }
    SpString* str = name.asString();
    char* filename = (char*)str->toCStringWithEncoder();
    ofstream* fout = new ofstream;
    fout->open(filename);
    if(fout->fail()){
        delete fout;
        throw SpException("can't open file");
    }
    FileStreamWriter* sw = new FileStreamWriter(fout, filename);
    WriteEncoder* encoder = new LF2CRWriteEncoder(sw);
    return SpObjectResult(encoder);
}

SpValue& lf2cr_openAppend(SpValue& v)
{
    SpValue name = v.eval();
    if(!name.isString()){
        throw SpException("filename is not string (LF2CR.openAppend)");
    }
    SpString* str = name.asString();
    char* filename = (char*)str->toCStringWithEncoder();
    ofstream* fout = new ofstream;
#ifdef __WIN32__
    fout->open(filename, ios::app | ios::binary);
#else
    fout->open(filename, ios::app);
#endif
    if(fout->fail()){
        delete fout;
        throw SpException("can't open file");
    }
    FileStreamWriter* sw = new FileStreamWriter(fout, filename);
    WriteEncoder* encoder = new LF2CRWriteEncoder(sw);
    return SpObjectResult(encoder);
}

SpValue& lf2cr_encoderIn(SpValue& v)
{
    SpValue r = v.eval();
    if(!r.isReader()){
        throw SpException("not reader (LF2CR.encoderIn)");
    }
    Reader* reader = r.asReader();
    ReadEncoder* encoder = new LF2CRReadEncoder(reader);
    return SpObjectResult(encoder);
}

SpValue& lf2cr_encoderOut(SpValue& v)
{
    SpValue w = v.eval();
    if(!w.isWriter()){
        throw SpException("not writer (LF2CR.encoderOut)");
    }
    Writer* writer = w.asWriter();
    WriteEncoder* encoder = new LF2CRWriteEncoder(writer);
    return SpObjectResult(encoder);
}

// init
void initLF2CR()
{
    SpValue SymLF2CR(new SpSymbol("lf2cr"));
    SpNameSpace* ns = new SpNameSpace;
    SpValue NSLF2CR(ns);
    PMainNameSpace->internConst(SymLF2CR, NSLF2CR);

    SpValue PrimOpenIn(new SpPrim1(&lf2cr_openIn));
    ns->internConst(SymOpenIn, PrimOpenIn);
    SpValue PrimEncoderIn(new SpPrim1(&lf2cr_encoderIn));
    ns->internConst(SymEncoderIn, PrimEncoderIn);

    SpValue PrimOpenOut(new SpPrim1(&lf2cr_openOut));
    ns->internConst(SymOpenOut, PrimOpenOut);

    SpValue PrimOpenAppend(new SpPrim1(&lf2cr_openAppend));
    ns->internConst(SymOpenAppend, PrimOpenAppend);

    SpValue PrimEncoderOut(new SpPrim1(&lf2cr_encoderOut));
    ns->internConst(SymEncoderOut, PrimEncoderOut);
}

