/*
 * Programming Language SOOPY
 *   (Simple Object Oriented Programming sYstem)
 * 
 * Copyright (C) 2002 SUZUKI Jun
 * 
 * URL: http://sourceforge.jp/projects/soopy/
 * License: GPL(GNU General Public License)
 * 
 * 
 * $Id: Closure.cpp,v 1.15 2004/03/24 11:53:44 randy Exp $
 */

#include "soopy.h"

/*
 * Closure
 */

SpClosure::SpClosure(SpValue& f, SpValue& aNS)
    : func(f), ns(aNS)
{
    SpFunc* f2 = dynamic_cast<SpFunc*>(func.getObject());
    argLen = f2->argLen;
}

SpValue& SpClosure::operator()(SpValue& arg)
{
    //    static SpValue result;
    SpValue result;
    SpFunc* f2 = dynamic_cast<SpFunc*>(func.getObject());
    pushCurrentNS(ns);
    try{
        result = (*f2)(arg);
    }catch(...){
      popCurrentNS();
      throw;
    }
    popCurrentNS();
    //    return result;
    return SpValueResult(result);
}

SpValue& SpClosure::toString()
{
    SpString* str;

    str = new SpString();
    *str = "#<Closure: ";
    *str += ns.toString();
    *str += ">";
    //    static SpValue s;
    //    s.setNewObject(str);
    //    return s;
    return SpObjectResult(str);
}

/*
 * Closure: arg length  1
 */

SpValue& SpClosureP2::operator()(SpValue& arg2)
{
    //    static SpValue result;
    SpValue result;

    pushCurrentNS(ns);
    try{
        SpPrim2* f = dynamic_cast<SpPrim2*>(func.getObject());
        result = (*f)(arg, arg2);
    }catch(...){
      popCurrentNS();
      throw;
    }
    popCurrentNS();
    //    return result;
    return SpValueResult(result);
}

SpValue& SpClosureP2::toString()
{
    SpString* str;

    str = new SpString();
    *str = "#<Closure: arg length 1>";
    //    static SpValue s;
    //    s.setNewObject(str);
    //    return s;
    return SpObjectResult(str);
}


// SpClosureP3
SpValue& SpClosureP3_1::operator()(SpValue& arg2)
{
    //    static SpValue result;
    SpValue result;

    pushCurrentNS(ns);
    try{
        SpPrim3* f = dynamic_cast<SpPrim3*>(func.getObject());
        result = (*f)(arg, arg2);
    }catch(...){
      popCurrentNS();
      throw;
    }
    popCurrentNS();
    //    return result;
    return SpValueResult(result);
}

SpValue& SpClosureP3_1::toString()
{
    SpString* str;

    str = new SpString();
    *str = "#<Closure: arg length 1>";
    //    static SpValue s;
    //    s.setNewObject(str);
    //    return s;
    return SpObjectResult(str);
}

SpValue& SpClosureP3_2::operator()(SpValue& arg3)
{
    //    static SpValue result;
    SpValue result;

    pushCurrentNS(ns);
    try{
        SpPrim3* f = dynamic_cast<SpPrim3*>(func.getObject());
        result = (*f)(arg1, arg2, arg3);
    }catch(...){
      popCurrentNS();
      throw;
    }
    popCurrentNS();
    //    return result;
    return SpValueResult(result);
}

SpValue& SpClosureP3_2::toString()
{
    SpString* str;

    str = new SpString();
    *str = "#<Closure: arg length 1>";
    //    static SpValue s;
    //    s.setNewObject(str);
    //    return s;
    return SpObjectResult(str);
}

/*
 * Closure: arg length N
 */

SpClosureN::SpClosureN(SpValue& f, SpValue& a, SpValue& aNS)
    : func(f), ns(aNS)
{
    SpFunc* f2 = dynamic_cast<SpFunc*>(func.getObject());
    if(a.isTuple()){
        SpTuple* t = dynamic_cast<SpTuple*>(a.getObject());
        argLen = f2->argLen - t->length();
        args = a;
    }else{
        argLen = f2->argLen - 1;
        args.setNewObject(new SpTuple(a));
    }
}

SpValue& SpClosureN::operator()(SpValue& arg2)
{
    //    static SpValue result;
    SpValue result;

    SpTuple* t = dynamic_cast<SpTuple*>(args.getObject());
    SpTuple* tuple = new SpTuple(t->vec);
    SpValue a(tuple);
    SpFunc* f = dynamic_cast<SpFunc*>(func.getObject());

    if(arg2.isTuple()){
        SpTuple* t2 = dynamic_cast<SpTuple*>(arg2.getObject());        
        SpValueVector::iterator it;
        it = t2->begin();
        for(; it != t2->end(); it++){
            tuple->append(*it);
        }
    }else{
        tuple->append(arg2);
    }

    if((SpInt)f->argLen > tuple->length()){
        result.setNewObject(new SpClosureN(func, a, ns));
    }else if((SpInt)f->argLen == tuple->length()){
        pushCurrentNS(ns);
        try{
            result = (*f)(a);
        }catch(...){
          popCurrentNS();
          throw;
        }
        popCurrentNS();
    }else{
        throw SpException("too many args");
    }
    //    return result;
    return SpValueResult(result);
}

SpValue& SpClosureN::toString()
{
    SpString* str;
    SpValue i((int)argLen);

    str = new SpString();
    *str = "#<ClosureN: arg length ";
    *str += i;
    *str += ">";
    //    static SpValue s;
    //    s.setNewObject(str);
    //    return s;
    return SpObjectResult(str);
}

