/*
 * Programming Language SOOPY
 *   (Simple Object Oriented Programming sYstem)
 * 
 * Copyright (C) 2002 SUZUKI Jun
 * 
 * URL: http://sourceforge.jp/projects/soopy/
 * License: GPL(GNU General Public License)
 * 
 * 
 * $Id: Datatype.cpp,v 1.10 2004/03/25 13:29:57 randy Exp $
 */

#include "soopy.h"

/*
 * SpDataType
 */

void SpDataType::mapping2ns(SpValue& self, SpNameSpace* ns)
{
    // set datatype
/*
    SpValue v(new NSConst(symbol));
    ns->intern(v, self);
*/
    ns->internConst(symbol, self);
    // set constructors
    SpValueVector::iterator it;
    it = vec.begin();
    for(; it != vec.end(); it++){
        SpConstructor* con = it->asConstructor();
/*
        v.setNewObject(new NSConst(con->symbol));
        ns->intern(v, *it);
*/
        ns->internConst(con->symbol, *it);
    }
}

SpValue& SpDataType::toString()
{
    SpString* str;

    str = new SpString();
    *str += "datatype ";
    *str += symbol;
    *str += " = ";
    SpValueVector::iterator it;
    it = vec.begin();
    *str += *it;
    it++;
    for(; it != vec.end(); it++){
        *str += " | ";
        *str += *it;
    }
    //    static SpValue s;
    //    s.setNewObject(str);
    //    return s;
    return SpObjectResult(str);
}

/*
 * SpConstructor
 */

SpValue& SpConstructor::eval()
{
    //    static SpValue result;
    SpValue result;
    if(argLen == 0){
        result.setNewObject(new SpDType(this, symbol, ns));
    }else{
        result.setObject(this);
    }
    //    return result;
    return SpValueResult(result);
}

SpValue& SpConstructor::operator()(SpValue& arg)
{
    //    static SpValue result;
    SpValue result, temp, temp2;
    SpNameSpace* assoc = new SpNameSpace(ns);
    SpValue v_ns(assoc);
    SpValue v_f(this);

    if(argLen == 0){
        if(!arg.isNil()){
            throw SpException("too much args");
        }
        result.setNewObject(new SpDType(this, symbol, ns));
	//        return result;
	return SpValueResult(result);
    }else if(argLen == 1){
        SpTuple* ptr = args.asTuple();
        //SpArg* p = ((*ptr)[0]).asArg();
        temp = ((*ptr)[0]);
        SpArg* p = temp.asArg();
        temp = arg.eval();
        CheckType(p->typ, temp);
        //assoc->internVar(p->getVarName(), temp);
	temp2 = p->getVarName();
        assoc->internVar(temp2, temp);
    }else{
        if(!arg.isTuple()){
            result.setNewObject(new SpClosureN(v_f, arg, v_ns));
	    //            return result;
	    return SpValueResult(result);
        }else{
            SpTuple* t = arg.asTuple();
            if((SpInt)argLen != t->length()){
                throw SpException("arg length mismatch");
            }
            // set args
            SpTuple* ptr = args.asTuple();
            SpValueVector::iterator it, it2;
            it = ptr->begin();
            it2 = t->begin();
            for(; it != ptr->end(); it++, it2++){
                SpArg* p = it->asArg();
                temp = it2->eval();
                CheckType(p->typ, temp);
//                assoc->internVar(p->getVarName(), it2->eval());
		temp2 = p->getVarName();
                assoc->internVar(temp2, temp);
            }
        }

    }
//cout << "dtype ns: " << ns << endl;
//cout << "dtype v_ns: " << v_ns << endl;
    //    result.setNewObject(new SpDType(this, symbol, v_ns));
    //    return result;
    return SpObjectResult(new SpDType(this, symbol, v_ns));
}

SpValue& SpConstructor::toString()
{
    SpString* str;

    str = new SpString();
    *str += "con ";
    *str += symbol;
    if(!args.isNil()){
        *str += "(";
        SpTuple* t = args.asTuple();
        SpValueVector::iterator it;
        it = t->begin();
        *str += *it;
        it++;
        for(; it != t->end(); it++){
            *str += ",";
            *str += *it;
        }
        *str += ")";
    }
    //    static SpValue s;
    //    s.setNewObject(str);
    //    return s;
    return SpObjectResult(str);
}

/*
 * SpDType
 */

SpValue& SpDType::toString()
{
    SpString* str;

    str = new SpString();
    *str += symbol;
    //if(!ns.isNil()){
    if(!con->args.isNil()){
        *str += "(";
        SpNameSpace* assoc = ns.asNameSpace();
        SpTuple* t = con->args.asTuple();
        SpValueVector::iterator it = t->begin();
        SpArg* arg = it->asArg();
        //SpValue v = assoc->lookup(arg->getVarName());
        SpValue v = arg->getVarName();
        v = assoc->lookup(v);
        *str += v.toString();
        it++;
        for(; it != t->end(); it++){
            *str += ",";
            arg = it->asArg();
            //v = assoc->lookup(arg->getVarName());
            v = arg->getVarName();
            v = assoc->lookup(v);
            *str += v.toString();
        }
        *str += ")";
    }
    //    static SpValue s;
    //    s.setNewObject(str);
    //    return s;
    return SpObjectResult(str);
}

SpValue& SpDType::onMessage(SpValue&, SpValue& msg)
{
    if(ns.isNil()){
        throw SpException("no such a feature (datatype)");
    }
    SpNameSpace* assoc = ns.asNameSpace();
//    try{
    return assoc->lookup(msg);
//    }catch(SpException& e){
//        return DTypeMsgHandler(rec, msg);
//    }
}

SpValue& SpDType::eq(SpValue&, SpValue& e2)
{
    if(e2.isDType()){
        SpDType* ptr = e2.asDType();
        if(con != ptr->con){
            return FalseObject;
        }
        if(symbol != ptr->symbol){
            return FalseObject;
        }
        if(ns == ptr->ns){
            return TrueObject;
        }
//        return ns.eq(ptr->ns);
    }
    return FalseObject;
}

/*
bool SpDType::match(SpValue& self, SpValue& val, SpNameSpace* ns)
{
}
*/

/*
 * class SpPatternCon
 */

SpValue& SpPatternCon::toString()
{
    SpString* str;

    str = new SpString();
    *str += symbol;
    *str += "(";
    SpTuple* t = tuple.asTuple();
    SpValueVector::iterator it;
    it = t->begin();
    *str += *it;
    it++;
    for(; it != t->end(); it++){
        *str += ",";
        *str += *it;
    }
    *str += ")";
    //    static SpValue v;
    //    v.setNewObject(str);
    //    return v;
    return SpObjectResult(str);
}

bool SpPatternCon::match(SpValue&, SpValue& val, SpNameSpace* ns)
{
    if(!val.isDType()){
        return false;
    }
    SpDType* dt = val.asDType();
    if(symbol != dt->symbol){
        return false;
    }
    if(tuple.isNil()){
        if(dt->ns.isNil()){
            return true;
        }else{
            return false;
        }
    }
    if(dt->ns.isNil()){
        return false;
    }

    SpTuple* t = tuple.asTuple();
    SpNameSpace* assoc = dt->ns.asNameSpace();
    if(t->length() != assoc->size()){
        return false;
    }

    if(dt->con->args.isNil()){
        return true;
    }
    SpTuple* t2 = dt->con->args.asTuple();
    SpValueVector::iterator it, it2;
    it = t->begin();
    it2 = t2->begin();
    for(; it != t->end(); it++, it2++){
        NSMap::iterator found;
        SpArg* a = it2->asArg();
        //NSVar* var = new NSVar(a->getVarName());
        SpValue temp = a->getVarName();
        NSVar* var = new NSVar(temp);
        SpValue key(var);
        found = assoc->aMap.find(key);
        if(found == assoc->aMap.end()){
            return false;
        }
        if(!it->match(found->second,ns)){
            return false;
        }
    }

    return true;
}


