/*
 * Programming Language SOOPY
 *   (Simple Object Oriented Programming sYstem)
 * 
 * Copyright (C) 2002 SUZUKI Jun
 * 
 * URL: http://sourceforge.jp/projects/soopy/
 * License: GPL(GNU General Public License)
 * 
 * 
 * $Id: Int.cpp,v 1.8 2004/03/21 05:48:06 randy Exp $
 */

#include "soopy.h"

// primitives

SpInt int_fromString(SpString* str)
{
  SpInt result = 0;

  SpCharVector::iterator it;
  for(it = str->begin(); it != str->end(); it++){
    if(!isDIGIT(*it)){
      throw SpException("not integer (int_fromString)");
    }
    result = (result * 10) + toINT(*it);
  }

  return result;
}

SpValue& int_toChar(SpValue& v)
{
    SpInt i = v.getInt();
    /*
    static SpValue res;
    res.setInt(i);
    res.typ = TypeChar;
    return res;
    */
    return SpCharResult((SpChar)i);
}

SpValue& int_toReal(SpValue& v)
{
    //    static SpValue res;
    //    res.setReal((SpReal)v.getInt());
    //    return res;
    return SpRealResult((SpReal)v.getInt());
}

SpValue& int_toString(SpValue& v)
{
    SpString* str = new SpString;
    *str += v;
    //    static SpValue res;
    //    res.setNewObject(str);
    //    return res;
    return SpObjectResult(str);
}

SpValue& int_repeat(SpValue& self, SpValue& n)
{
    //    static SpValue result;
    SpValue result;

    if(!n.isNameSpace()){
        throw SpException("not namespace in repeat");
    }
    SpNameSpace* ns = n.asNameSpace();
    SpUsrFunc* func = SpUsrFunc::fromNameSpace(ns);
    SpValue taker(func);
    SpInt count = self.getInt();
    for(int i=0; i < count; i++){
        SpValue arg;
        arg.setInt(i);
        result = (*func)(arg);
    }
    //    return result;
    return SpValueResult(result);
}

// init Message Handler
void initInt()
{
    IntMsgHandler.append(SymIsInt, PrimTrue);

    SpValue SymToChar(new SpSymbol("tochar"));
    SpValue PrimToChar(new SpPrim1(int_toChar));
    IntMsgHandler.append(SymToChar, PrimToChar);

    SpValue SymToReal(new SpSymbol("toreal"));
    SpValue PrimToReal(new SpPrim1(int_toReal));
    IntMsgHandler.append(SymToReal, PrimToReal);

    SpValue PrimToString(new SpPrim1(int_toString));
    IntMsgHandler.append(SymToString, PrimToString);

    SpValue SymRepeat(new SpSymbol("repeat"));
    SpValue PrimRepeat(new SpPrim2(int_repeat));
    IntMsgHandler.append(SymRepeat, PrimRepeat);
}
