/*
 * Programming Language SOOPY
 *   (Simple Object Oriented Programming sYstem)
 * 
 * Copyright (C) 2002,2003 SUZUKI Jun
 * 
 * URL: http://sourceforge.jp/projects/soopy/
 * License: GPL(GNU General Public License)
 * 
 * 
 * $Id: List.cpp,v 1.61 2004/05/18 12:47:17 randy Exp $
 */

//
// Soopy List Class
//

#include "soopy.h"

/*
ostream& operator<<(ostream& out, SpList* list)
{
  out << "[";
  while(true){
    out << list->value();
    list = list->next();
    if(list != NULL){
      out << ", ";
    }else{
      break;
    }
  }
  out << "]";

  return out;
}
*/

/*
 * Message Handler
 */

SpValue& SpList::onMessage(SpValue& rec, SpValue& msg)
{
  //    return ListMsgHandler(rec, msg);
    SpValue result = ListMsgHandler(rec, msg);
    return SpValueResult(result);
}

bool SpList::match(SpValue& self, SpValue& val, SpNameSpace* ns)
{
    SpValue list, list2, temp, temp2;
    list = self;
    list2 = val;
    while(list2.isList()){
        SpList* ptr = dynamic_cast<SpList*>(list.getObject());
        SpList* ptr2 = dynamic_cast<SpList*>(list2.getObject());

        //if(!ptr->value().match(ptr2->value(), ns)){
        temp = ptr->value();
        temp2 = ptr2->value();
        if(!temp.match(temp2, ns)){
            return false;
        }

        list = ptr->nextList();
        list2 = ptr2->nextList();
        if(list.isNil()){
            if(list2.isNil()){
                return true;
            }
            break;
        }
    }
    return false;
}

SpValue& SpList::eq(SpValue& e1, SpValue& e2)
{
    SpValue list, list2, temp, temp2;
    list = e1;
    list2 = e2;
    while(list2.isList()){
        SpList* ptr = list.asList();
        SpList* ptr2 = list2.asList();

        //if(ptr->value().eq(ptr2->value()).isFalse()){
        temp = ptr->value();
        temp2 = ptr2->value();
        temp = temp.eq(temp2);
        if(temp.isFalse()){
            return FalseObject;
        }

        list = ptr->nextList();
        list2 = ptr2->nextList();
        if(list.isNil()){
            if(list2.isNil()){
                return TrueObject;
            }
            break;
        }
    }
    return FalseObject;
}

SpList* SpList::nth(int i)
{
  SpList* ptr = this;
  for(int j=0; j < i; j++){
    //    static SpValue temp;
    ptr = ptr->next();
    if(ptr == NULL){
      throw SpException("index is too big ( list.nth )");
    }
    //    temp.setObject(ptr);
    SpObjectResult(ptr);
  }
  return ptr;
}


// list Primitives
SpValue& SpList::prim_head(SpValue& list)
{
    SpList* ptr = dynamic_cast<SpList*>(list.getObject());
    if(ptr == NULL){
        throw SpException("not list (head)");
    }
    //    return ptr->value().eval();
    SpValue result;
    result = ptr->value();
    result = result.eval();
    return SpValueResult(result);
}

SpValue& SpList::prim_tail(SpValue& list)
{
    SpList* ptr = dynamic_cast<SpList*>(list.getObject());
    if(ptr == NULL){
        throw SpException("not list (tail)");
    }
    //    return ptr->nextList();

    SpValue result = ptr->nextList();
    return SpValueResult(result);
}

SpValue& SpList::prim_nth(SpValue& self, SpValue& index)
{
    if(!index.isInt()){ throw SpException("not int (list.nth)"); }
    int i = index.getInt();
    SpValue temp = self;
    SpList* ptr = self.asList();
    for(int j=0; j != i; j++){
        temp = ptr->nextList();
        if(temp.isNil()){
            throw SpException("index is too big (list.nth)");
        }
        ptr = temp.asList();
    }
    //    static SpValue result;
    //    result = ptr->value().eval();
    //    return result;

    //return SpValueResult(ptr->value().eval());
    SpValue result;
    result = ptr->value();
    result = result.eval();
    return SpValueResult(result);
}

SpValue& SpList::prim_each(SpValue& self, SpValue& func)
{
    SpValue taker;
    SpFunc* f;
    if(func.isNameSpace()){
        SpNameSpace* ns = func.asNameSpace();
        f = SpUsrFunc::fromNameSpace(ns);
        //        taker.setNewObject(f);
        taker.setObject(f);
    }else if(func.isFunc()){
        f = func.asFunc();
    }else{
        throw SpException("not function (list.each)");
    }
    SpList* ptr = self.asList();

    while(ptr != NULL){
        SpValue temp = ptr->value();
        (*f)(temp);
        ptr = ptr->next();
    }

    return NilObject;
}

SpValue& SpList::prim_map(SpValue& self, SpValue& func)
{
    SpValue temp;
    SpValue taker;
    SpFunc* f;

    if(func.isNameSpace()){
        SpNameSpace* ns = func.asNameSpace();
        f = SpUsrFunc::fromNameSpace(ns);
        //        taker.setNewObject(f);
        taker.setObject(f);
    }else if(func.isFunc()){
        f = func.asFunc();
    }else{
        throw SpException("not function (list.map)");
    }
    SpList* ptr = self.asList();

    temp = ptr->value();
    //SpCons* head = new SpCons((*f)(temp));
    temp = (*f)(temp);
    SpCons* head = new SpCons(temp);
    SpCons* p = head;
    ptr = ptr->next();

    while(ptr != NULL){
        temp = ptr->value();
        //        p->append((*f)(temp));
        temp = (*f)(temp);
        p->append(temp);
        ptr = ptr->next();
        p = (SpCons*)p->next();
    }

    //    static SpValue result;
    //    result.setNewObject(head);
    //    return result;
    return SpObjectResult(head);
}

SpValue& SpList::prim_foldl(SpValue& self, SpValue& func)
{

    SpValue v1, v2;

    SpValue taker;
    SpFunc* f;
    if(func.isNameSpace()){
        SpNameSpace* ns = func.asNameSpace();
        f = SpUsrFunc::fromNameSpace(ns);
        //        taker.setNewObject(f);
        taker.setObject(f);
    }else if(func.isFunc()){
        f = func.asFunc();
    }else{
        throw SpException("not function (list.foldl)");
    }
    SpList* ptr = self.asList();

    v1 = ptr->value();
    SpTuple* t = new SpTuple(v1);
    t->append(NilObject);
    SpValue arg(t);
    ptr = ptr->next();
    while(ptr != NULL){
        v2 = ptr->value();
        (*t)[0] = v1;
        (*t)[1] = v2;
        v1 = (*f)(arg);
        ptr = ptr->next();
    }

    //    static SpValue result;
    //    result = v1;
    //    return result;
    return SpValueResult(v1);
}

SpValue& SpList::sub_foldr(SpFunc* f,
                           SpValue& v1,
                           SpList* list)
{
    if(list == NULL){
        return v1;
    }
    SpTuple* t = new SpTuple(v1);
    //    SpValue& v2 = sub_foldr(f, list->value(), list->next());
    SpValue temp;
    temp = list->value();
    SpValue& v2 = sub_foldr(f, temp, list->next());
    t->append(v2);
    SpValue arg(t);
    //    static SpValue result;
    //    result = (*f)(arg);
    //    return result;
    return SpValueResult((*f)(arg));
}

SpValue& SpList::prim_foldr(SpValue& self, SpValue& func)
{

    SpValue v1, v2;

    SpValue taker;
    SpFunc* f;
    if(func.isNameSpace()){
        SpNameSpace* ns = func.asNameSpace();
        f = SpUsrFunc::fromNameSpace(ns);
        //        taker.setNewObject(f);
        taker.setObject(f);
    }else if(func.isFunc()){
        f = func.asFunc();
    }else{
        throw SpException("not function (list.foldr)");
    }
    SpList* ptr = self.asList();

    v1 = ptr->value();
    ptr = ptr->next();
    //    static SpValue result;
    //    result = sub_foldr(f, v1, ptr);
    //    return result;
    return SpValueResult(sub_foldr(f, v1, ptr));
}

SpValue& SpList::prim_member(SpValue& self, SpValue& value)
{
    SpValue v1, temp;
    SpList* ptr = self.asList();
    while(ptr != NULL){
        //if(ptr->value().eq(value).isTrue()){
        temp = ptr->value();
        temp = temp.eq(value);
        if(temp.isTrue()){
            return TrueObject;
        }
        v1 = ptr->value();
        ptr = ptr->next();
    }
    return FalseObject;
}

SpValue& SpList::prim_sort(SpValue& self)
{
    SpValue v1, temp;

    if(!self.isCons()){
        throw SpException("not cons (List.sort)");
    }
    SpCons* ptr = (SpCons*)self.asList();
    SpCons* res = NULL;
    while(ptr != NULL){
        v1 = ptr->value();

        // insert to result
        if(res == NULL){
            res = new SpCons(v1);
        }else{
            SpCons* prev = NULL;
            SpCons* pos  = res;
            while(pos != NULL){
                //                if(v1 < pos->value()){
                temp = pos->value();
                if(v1 < temp){
                    break;
                }

                prev = pos;
                pos = (SpCons*)pos->next();
            }
            if(prev == NULL){
              //                temp.setNewObject(res);
                temp.setObject(res);
                res = new SpCons(v1, temp);
            }else{
                if(pos == NULL){
                    temp.setNewObject(new SpCons(v1));
                }else{
                    SpValue t2;
                    //                    t2.setNewObject(pos);
                    t2.setObject(pos);
                    temp.setNewObject(new SpCons(v1, t2));
                }
                prev->setNext(temp);
            }
        }

        ptr = (SpCons*)ptr->next();
    }
    //    static SpValue result;
    //    result.setNewObject(res);
    //    return result;
    return SpObjectResult(res);
}

SpValue& SpList::prim_filter(SpValue& self, SpValue& func)
{
    SpValue temp;
    SpValue taker;
    SpFunc* f;
    if(func.isNameSpace()){
        SpNameSpace* ns = func.asNameSpace();
        f = SpUsrFunc::fromNameSpace(ns);
        taker.setNewObject(f);
    }else if(func.isFunc()){
        f = func.asFunc();
    }else{
        throw SpException("not function (list.filter)");
    }
    SpList* ptr = self.asList();

    SpCons* head = NULL;
    SpCons* p = NULL;
    while(ptr != NULL){
        SpValue cond;
        temp = ptr->value();
        cond = (*f)(temp);
        if(cond.isTrue()){
            if(p == NULL){
                head = new SpCons(temp);
                p = head;
            }else{
                p->append(temp);
                p = (SpCons*)p->next();
            }
        }
        ptr = ptr->next();
    }

    if(head == NULL){
        return NilObject;
    }
    //    static SpValue result;
    //    result.setNewObject(head);
    //    return result;
    return SpObjectResult(head);
}

SpValue& SpList::prim_length(SpValue& self)
{
    SpList* ptr = self.asList();
    //    static SpValue result;
    //    result.setInt(ptr->length());
    //    return result;
    return SpIntResult(ptr->length());
}


// init Message Handler
void SpList::init()
{
    ListMsgHandler.append(SymIsList, PrimTrue);
    ListMsgHandler.append(SymIsNil, PrimFalse);

    SpValue PrimHead(new SpPrim1(prim_head));
    ListMsgHandler.append(SymHead, PrimHead);

    SpValue PrimTail(new SpPrim1(prim_tail));
    ListMsgHandler.append(SymTail, PrimTail);

    SpValue PrimNth(new SpPrim2(prim_nth));
    ListMsgHandler.append(SymNth, PrimNth);

    SpValue PrimEach(new SpPrim2(prim_each));
    ListMsgHandler.append(SymEach, PrimEach);

    SpValue PrimMap(new SpPrim2(prim_map));
    ListMsgHandler.append(SymMap, PrimMap);

    SpValue PrimFoldl(new SpPrim2(prim_foldl));
    ListMsgHandler.append(SymFoldl, PrimFoldl);

    SpValue PrimFoldr(new SpPrim2(prim_foldr));
    ListMsgHandler.append(SymFoldr, PrimFoldr);

    SpValue PrimMember(new SpPrim2(prim_member));
    ListMsgHandler.append(SymMember, PrimMember);

    SpValue PrimSort(new SpPrim1(prim_sort));
    ListMsgHandler.append(SymSort, PrimSort);

    SpValue PrimFilter(new SpPrim2(prim_filter));
    ListMsgHandler.append(SymFilter, PrimFilter);

    SpValue PrimLength(new SpPrim1(prim_length));
    ListMsgHandler.append(SymLength, PrimLength);
}


SpValue& SpList::nextList()
{
    SpObject* obj = next();
    if(obj == NULL){
        return NilObject;
    }
    //    static SpValue v;
    //    v.setNewObject(obj); // BUG!?
    //    return v;
    return SpObjectResult(obj);
}

SpValue& SpList::toString()
{
    SpString* str;
    SpList* ptr = this;

    str = new SpString();
    *str = "[";
    while(true){
        //*str += ptr->value().toString();
        SpValue temp;
        temp = ptr->value();
        *str += temp.toString();
        ptr = ptr->next();
        if(ptr != NULL){
            *str += ", ";
        }else{
            break;
        }
    }
    *str += "]";
    //    static SpValue s;
    //    s.setNewObject(str);
    //    return s;
    return SpObjectResult(str);
}

//
// Soopy Cons Class
//

SpCons::~SpCons()
{
#ifdef TEST
    *spout << ":destroy SpCons" << "\n";
#endif
}

void SpCons::append(SpValue& val)
{
    if(cdr.isNil()){
        SpCons* list = new SpCons(val);
        cdr.setNewObject(list);
    }else if(cdr.isObject()){
        SpCons* list = dynamic_cast<SpCons*>(cdr.getObject());
        list->append(val);
    }
}

int SpCons::length()
{
    int i;
    SpCons* ptr;

    ptr = this;
    for(i=0; ptr != NULL; i++){
        ptr = dynamic_cast<SpCons*>(ptr->next());
    }
    return i;
}

bool SpCons::operator==(SpObject& obj)
{
    if(SpCons* p2 = dynamic_cast<SpCons*>(&obj)){
        SpCons* p1 = this;
        while(true){
            if(p1 == NULL){
                if(p2 == NULL){
                    return true;
                }
                break;
            }
            if(p2 == NULL){
                break;
            }
            if(p1->car != p2->car){
                break;
            }

            // p1++, p2++
            p1 = dynamic_cast<SpCons*>(p1->next());
            p2 = dynamic_cast<SpCons*>(p2->next());
        }
    }
    return false;
}

bool SpCons::operator<(SpObject& obj)
{
    if(SpCons* p2 = dynamic_cast<SpCons*>(&obj)){
        SpCons* p1 = this;
        while(true){
            if(p1 == NULL){
                if(p2 == NULL){
                    return false;
                }
                return true;
            }
            if(p2 == NULL){
                return false;
            }
            if(p1->car != p2->car){
                return p1->car < p2->car;
            }

            // p1++, p2++
            p1 = dynamic_cast<SpCons*>(p1->next());
            p2 = dynamic_cast<SpCons*>(p2->next());
        }
    }
    return SpObject::operator<(obj);
}


//
// Soopy Range Class
//

SpRange::~SpRange()
{
#ifdef TEST
    *spout << ":destroy SpRange(" << start << "," << end;
    *spout << "," << step << ")" << "\n";
#endif
}

SpList* SpRange::next()
{
    SpRange* range;

    int i = start + step;
    if(!infinity){
        if(step >= 0){
            if(i > end){
                return NULL;
            }
        }else{ // step < 0
            if(i < end){
                return NULL;
            }
        }
    }
    range = new SpRange(i, end, step, infinity);
    return range;
}

SpValue& SpRange::value()
{
    //    static SpValue i;
    //    i = start;
    //    return i;
    return SpIntResult(start);
}

SpValue& SpRange::toString()
{
    SpString* str;
    SpRange* ptr = this;
//    SpValue v(ptr);
    SpValue v;

    str = new SpString();
    *str = "[";
    while(true){
        //*str += ptr->value().toString();
        SpValue temp;
        temp = ptr->value();
        *str += temp.toString();
        ptr = (SpRange*)ptr->next();
        //v = ptr;
        v.setNewObject(ptr);
        if(ptr != NULL){
            *str += ", ";
        }else{
            break;
        }
    }
    *str += "]";
    //    static SpValue s;
    //    s.setNewObject(str);
    //    return s;
    return SpObjectResult(str);
}

int SpRange::length()
{
    int i = 1;

    if(infinity){
        throw SpNoLengthException("can't calc length(infinity)");
    }

    if(step == 0){
        throw SpNoLengthException("can't calc length(infinity)");
    }else if(step > 0){
        if(start < end){
            i += (end - start) / step;
        }
    }else{ // step < 0
        if(start > end){
            i += (start - end) / (-step);
        }
    }

    return i;
}

// class SpMakeRange

SpValue& SpMakeRange::toString()
{
    SpString* str;
    SpValue v;

    str = new SpString();
    *str += "[";
    *str += vstart.toString();
    *str += "..";
    if(hasStep){
        *str += vstep.toString();
        *str += "..";
    }
    if(!infinity){
        *str += vend.toString();
    }
    *str += "]";

    //    static SpValue s;
    //    s.setNewObject(str);
    //    return s;
    return SpObjectResult(str);
}

SpValue& SpMakeRange::eval()
{
    SpValue temp;
    SpRange* range;
    int i;
    int start;
    int end;
    int step;

    temp = vstart.eval();
    if(!temp.isInt()){
        throw SpException("not int in range");
    }
    start = temp.getInt();

    if(hasStep){
        temp = vstep.eval();
        if(!temp.isInt()){
            throw SpException("not int in range");
        }
        i = temp.getInt();
        step = i - start;
        if(infinity){
            range = new SpRange(start, 0, step, true);
        }else{
            temp = vend.eval();
            if(!temp.isInt()){
                throw SpException("not int in range");
            }
            end = temp.getInt();
            range = new SpRange(start, end, step);
        }
    }else{
        if(infinity){
            range = new SpRange(start, 0, 1, true);
        }else{
            temp = vend.eval();
            if(!temp.isInt()){
                throw SpException("not int in range");
            }
            end = temp.getInt();
            if(start <= end){
                step = 1;
            }else{
                step = -1;
            }
            range = new SpRange(start, end, step);
        }
    }

    //    static SpValue result;
    //    result.setNewObject(range);
    //    return result;
    return SpObjectResult(range);
}

//
// SpAppendedList
//   first @ second
//
SpList* SpAppendedList::next()
{
  SpList* list = first.asList();
  list = list->next();
  if(list == NULL){
    return second.asList();
  }else{
    SpValue temp;

    temp.setObject(list);
    list = new SpAppendedList(temp, second, environ);
    return list;
  }
}

SpValue& SpAppendedList::value()
{
  //  static SpValue result;
  SpValue result;

  pushCurrentNS(environ);
  try {
    SpList* list = first.asList();
    result = list->value();
  }catch(...){
    popCurrentNS();
    throw;
  }
  popCurrentNS();
  //  return result;
  return SpValueResult(result);
}

//
// Soopy List Comprehension Class
//

// class SpListCreator
SpValue& SpListCreator::toString()
{
    SpString* str;
    SpValue v;

    str = new SpString();
    *str += symbol.toString();
    *str += " <- ";
    *str += list.toString();

    //    static SpValue s;
    //    s.setNewObject(str);
    //    return s;
    return SpObjectResult(str);
}


// class SpListCompre
SpListCompre::SpListCompre(SpValue& cur_val, SpValue& e, SpValue& c, SpValue& f, SpValueVector* v, SpValue& env)
     : SpListCompreBase(cur_val, e, c, f, env)
{
  // set cur_creators
  SpValueVector::iterator it;
  it = v->begin();
  for(; it != v->end(); it++){
    cur_creators.push_back(*it);
  }
}

/*
int SpListCompre::length()
{
  int len = 0;
  SpTuple* tpl = dynamic_cast<SpTuple*>(creators.getObject());
  SpValueVector::iterator it;
  it = tpl->begin();
  for(; it != tpl->end(); it++){
    SpListCreator* cre  = dynamic_cast<SpListCreator*>(it->getObject());
    SpList*        list = cre->list.asList();
    len += list->length();
  }
  return len;
}
*/

// ЂƂListComprep̃p[^vZ
//   Xg̏ÎƂɂfalseԂ
bool SpListCompre::calc_next_param(SpValue& org, SpValueVector* cur)
{
  SpValue temp;
  SpTuple* tpl = dynamic_cast<SpTuple*>(org.getObject());
  SpValueVector::reverse_iterator it1;
  SpValueVector::reverse_iterator it2;
  it1 = tpl->rbegin();
  it2 = cur->rbegin();
/*
  if(tpl->length() != cur->size()){
    throw SpException("System error: creator length not match with original (ListCompre)");
  }
*/
  for(; ; it1++, it2++){
    if(it2 == cur->rend()){
      return false;
    }
    SpListCreator* cre  = dynamic_cast<SpListCreator*>(it2->getObject());
    SpList*        list = cre->list.asList();
    SpList*        next = list->next();
    temp.setObject(next);
    if(next == NULL){
      *it2 = *it1;
    }else{
      //it2->setNewObject(new SpListCreator(cre->symbol, temp));
      SpListCreator* ptr = new SpListCreator(cre->symbol, temp);
      it2->setNewObject(ptr);
      ptr->list = temp;
      break;
    }
  }

  return true;
}

// ^ꂽp[^Őlfiltersʂ邩eXg
//   filtersʂȂƂɂfalseԂ
//   vZlresultɕԂ
bool SpListCompre::calc_value(SpValue& result, SpValue& e, SpValue& f, SpValueVector* v, SpValue& env)
{
  bool boolean = true;
  SpNameSpace* ns = new SpNameSpace(env);
  SpValue v_ns(ns);

  pushCurrentNS(v_ns);
  try {
    // List̐(ex. x <- [1..3])ϐɒlZbg
    SpValueVector::iterator it;
    it = v->begin();
    for(; it != v->end(); it++){
      SpValue temp;
      SpListCreator* cre  = dynamic_cast<SpListCreator*>(it->getObject());
      SpList*        list = cre->list.asList();
      temp = list->value();
      ns->internVar(cre->symbol, temp);
    }

    // filter  check
    if(!f.isNil()){
      SpTuple* filter_list = f.asTuple();
      it = filter_list->begin();
      for(; it != filter_list->end(); it++){
        SpValue p;
        p = it->eval();
        if(!p.isTrue()){
          boolean = false;
          break;
        }
      }
    }

    if(boolean){
      result = e.eval();
    }

  }catch(...){
    popCurrentNS();
    throw;
  }
  popCurrentNS();

  return boolean;
}

SpListCompre* SpListCompre::Create(SpValue& e, SpValue& c, SpValue& f)
{
  // ʂƂċ󃊃Xg̏ꍇANullԂ
  //   ListCreator::listЂƂłNil̂ƂNULL
  SpTuple* tpl = dynamic_cast<SpTuple*>(c.getObject());
  SpValueVector::iterator it;
  it = tpl->begin();
  for(; it != tpl->end(); it++){
    SpListCreator* cre = dynamic_cast<SpListCreator*>(it->getObject());
    cre->list = cre->expr.eval();
    if(cre->list.isNil()){
      return NULL;
    }
    if(!cre->list.isList()){
      throw SpException("not list (list comprehension)");
    }
  }
  return calc_next_list(e, c, f, getCurrentNS());
}

SpListCompre* SpListCompre::calc_next_list(SpValue& e, SpValue& c, SpValue& f, SpValue& env, SpValueVector* v)
{
  // ʂƂċ󃊃Xg̏ꍇANullԂ
  //   Head̒l炩ߌvZĂ
  //   ߂lAfilterʂȂƂɂ
  //   ̒l߂BȉAlɌJԂB
  //   ŏIIɁAfilterʂl݂ȂꍇɂNULLԂ
  SpListCompre* result;
  SpValue val;
  SpValue exp = e;
  SpValue cre = c;
  SpValue fil = f;
  SpValueVector* vec;

  if(v == NULL){
    vec = new SpValueVector;
    copy_tuple_to_valVec(vec, c);
  }else{
    vec = v;
  }

  bool hasValue = calc_value(val, exp, fil, vec, env);
  while(!hasValue){
    if(calc_next_param(cre, vec) == false){ // ȂƂiXg̏Ij
      result = NULL;
      goto end;
    }
    hasValue = calc_value(val, exp, fil, vec, env);
  }
  result = new SpListCompre(val, exp, cre, fil, vec, env);

end:
  if(v == NULL){
    delete vec;
  }
  return result;
}

void SpListCompre::copy_tuple_to_valVec(SpValueVector* dst, SpValue& src)
{
  SpTuple* tpl = dynamic_cast<SpTuple*>(src.getObject());
  SpValueVector::iterator it;
  it = tpl->begin();
  for(; it != tpl->end(); it++){
    dst->push_back(*it);
  }
}

void SpListCompre::copy_valVec_to_valVec(SpValueVector* dst, SpValueVector* src)
{
  SpValueVector::iterator sit;
  sit = src->begin();
  for(; sit != src->end(); sit++){
    dst->push_back(*sit);
  }
}

SpList* SpListCompre::next()
{
  SpValueVector* vec;

  vec = new SpValueVector;
  copy_valVec_to_valVec(vec, &cur_creators);
  if(calc_next_param(creators, vec) == false){ // ȂƂiXg̏Ij
    delete vec;
    return NULL;
  }

  SpListCompre* result;
  result = calc_next_list(expr, creators, filters, environ, vec);
  delete vec;
  return result;
}


// class SpListcompreCreator
SpValue& SpListCompreCreator::eval()
{
  SpListCompre* list = SpListCompre::Create(expr, creators, filters);
  if(list == NULL){
    return NilObject;
  }
  //  static SpValue result;
  //  result.setObject(list);
  //  return result;
  SpValue result;
  result.setObject(list);
  //  return SpObjectResult(list);
  return SpValueResult(result);
}

SpValue& SpListCompreCreator::toString()
{
  SpString* str;

  str = new SpString();
  *str = "<list comprehension creator>";
  //  static SpValue s;
  //  s.setNewObject(str);
  //  return s;
  return SpObjectResult(str);
}


//
// list comprehension (diagonalising)
//   ex. [(x, y) // x <- [1..], y <- [1..]]
//
/*
 * ΊpZF邽߂̍l@
 *

XgQ̏ꍇ([ expr // x <- [0..3], y <- [0..3], ......])

(0, 0)                      x + y = 0,    x >= 0, y >= 0, x <= 3, y <= 3
(1, 0) (0, 1)               x + y = 1,    x >= 0, y >= 0, x <= 3, y <= 3
(2, 0) (1, 1) (0, 2)        x + y = 2,    x >= 0, y >= 0, x <= 3, y <= 3
(3, 0) (2, 1) (1, 2) (0, 3) x + y = 3,    x >= 0, y >= 0, x <= 3, y <= 3
(3, 1) (2, 2) (1, 3)        x + y = 4,    x >= 0, y >= 0, x <= 3, y <= 3
(3, 2) (2, 3)               x + y = 5,    x >= 0, y >= 0, x <= 3, y <= 3
(3, 3)                      x + y = 6,    x >= 0, y >= 0, x <= 3, y <= 3


XgR̏ꍇ([ expr // x <- [0..3], y <- [0..3], z <- [0..3], ......])

(0, 0, 0)                      x + y + z = 0
(1, 0, 0) (0, 1, 0) (0, 0, 1)  x + y + z = 1
(2, 0, 0) (1, 1, 0) (1, 0, 1) (0, 2, 0) (0, 1, 1) (0, 0, 2)  x + y + z = 2
.....
(3, 3, 3)                      x + y + z = 9


  Xgix <- [1..] ݂Ȃj̂ƂA
  ẻԖڂ̒lgp邩,

    A1 + A2 + A3 + ... + An = 0
    A1 + A2 + A3 + ... + An = 1
    A1 + A2 + A3 + ... + An = 2
    A1 + A2 + A3 + ... + An = 3
       ......
    A1 + A2 + A3 + ... + An = ől

  ̕𖞂RA1An܂łɂׂċ߂΂悢B
  (A1  An ͊ẻԖڂ\j)

  ̍őĺueXg̘̒av|u̐vɓB
  Xg܂܂ꍇɂ́Aől݂̂̂ȂB

  ۂ̃ASYiASY͎₷̗̂pBƂA܂ΊpۂȂȂƂĂj
  @EӂN̂ƂA
  @@PDA1NAOɂB
  @@QDA1 = A1 - 1, A2 = A2 + 1  iǂPƁAق̂ǂPj
  @@RDA2 = A2 - 1, A3 = A3 + 1
  @@@@@ȉAAn܂œlɌJԂB
  @@SD(A1 - 1) OłȂꍇAQ
  @@TDA1 = 0, A2NAA2`AnOɂB
  @@UDA2 = A2 - 1, A3 = A3 + 1
  @@@@@ȉAAn܂œlɌJԂB
  @@VDAnNɂȂ܂œlɌJԂB
  @@ił̂HHj

*/

bool SpListCompreDiag::next_rval(int  max,
                                 int& idx,
                                 IntVector& rval,
                                 IntVector& base,
                                 IntVector& move,
                                 int depth,
                                 int* dimension)
{
  rval[idx]++;
  // Xg̏ÎƂɂ́AfalseԂB
  if((max >= 0) && (rval[idx] > max)){
    return false;
  }
  base[idx] = 0;
  move[idx] = 0;
  dimension[0] = rval[idx];
  for(int i=1; i < depth; i++){
    dimension[i] = 0;
  }
  return true;
}

bool SpListCompreDiag::dec_idx(int  max,
                               int& idx,
                               IntVector& rval,
                               IntVector& base,
                               IntVector& move,
                               int depth,
                               int* dimension)
{
  while(idx > 0){
    idx--;
    if(dimension[base[idx]] > 0){
      dimension[base[idx]]--;
      move[idx] = base[idx] + 1;
      dimension[move[idx]] = rval[idx] - dimension[base[idx]];
      for(int i=move[idx]+1; i < depth; i++){
        dimension[i] = 0;
      }
      if((idx < (depth - 2)) && (dimension[move[idx]] > 1)){
        idx++;
        rval[idx] = dimension[move[idx-1]];
        base[idx] = move[idx-1];
        move[idx] = base[idx];
      }
      break;
    }else if(idx <= 0){  // dimension[base[idx]] <= 0
      if(next_rval(max, idx, rval, base, move, depth, dimension) == false){
        return false;
      }
    }
  }
  return true;
}

bool SpListCompreDiag::calc_next_param(IntVector& lengths,
                                       int  max,
                                       int& idx,
                                       IntVector& rval,
                                       IntVector& base,
                                       IntVector& move,
                                       int depth,
                                       int* dimension)
{
  bool loop = true;

  if(rval[idx] == 0){
    return next_rval(max, idx, rval, base, move, depth, dimension);
  }
  while(loop){
    if((move[idx] + 1) < depth){
      dimension[move[idx]]--;
      move[idx]++;
      dimension[move[idx]]++;
    }else{  // (move[idx] + 1) >= depth
      if(dimension[base[idx]] == 1){
        dimension[base[idx]] = 0;
        base[idx]++;
        if(base[idx] < depth){
          move[idx] = base[idx];
          dimension[base[idx]] = rval[idx];
          for(int i=base[idx]+1; i < depth; i++){
            dimension[i] = 0;
          }
        }else{ // base[idx] >= depth
          if(next_rval(max, idx, rval, base, move, depth, dimension) == false){
            return false;
          }
        }
      }else if(dimension[base[idx]] == 0){
        if(idx > 0){
          if(dec_idx(max, idx, rval, base, move, depth, dimension) == false){
            return false;
          }
        }else{
          if(next_rval(max, idx, rval, base, move, depth, dimension) == false){
            return false;
          }
        }
      }else{ // dimension[base[idx]] != 1 or 0
        if(base[idx] < (depth - 1)){
          dimension[base[idx]]--;
          move[idx] = base[idx] + 1;
          dimension[move[idx]] = rval[idx] - dimension[base[idx]];
          for(int i=move[idx]+1; i < depth; i++){
            dimension[i] = 0;
          }
          if((idx < (depth - 2)) && (dimension[move[idx]] > 1)){
            idx++;
            rval[idx] = dimension[move[idx-1]];
            base[idx] = move[idx-1];
            move[idx] = base[idx];
          }
        }else{
          if(idx > 0){
            if(dec_idx(max, idx, rval, base, move, depth, dimension) == false){
              return false;
            }
          }else{ // idx <= 0
            if(next_rval(max, idx, rval, base, move, depth, dimension) == false){
              return false;
            }
          }
        }
      }
    }
    // eXg̒𒴂ĂȂ`FbN
    for(int i=0; i < depth; i++){
      loop = false;
      if((lengths[i] >= 0) && (dimension[i] >= lengths[i])){
        loop = true;
        break;
      }
    }
  }
  return true;
}

// ^ꂽp[^Őlfiltersʂ邩eXg
//   filtersʂȂƂɂfalseԂ
//   vZlresultɕԂ
bool SpListCompreDiag::calc_value(SpValue& result, SpValue& e, SpValue& c, SpValue& f, SpValue& env, int* dimension)
{
  bool boolean = true;
  SpNameSpace* ns = new SpNameSpace(env);
  SpValue v_ns(ns);
  SpTuple* tpl = c.asTuple();

  pushCurrentNS(v_ns);
  try {
    // List̐(ex. x <- [1..3])ϐɒlZbg
    SpValueVector::iterator it;
    it = tpl->begin();
    for(int i=0; it != tpl->end(); it++, i++){
      SpValue temp;
      SpListCreator* cre  = dynamic_cast<SpListCreator*>(it->getObject());
      SpList*        list = cre->list.asList();
      temp = list->nth(dimension[i])->value();
      ns->internVar(cre->symbol, temp);
    }

    // filter  check
    if(!f.isNil()){
      SpTuple* filter_list = f.asTuple();
      it = filter_list->begin();
      for(; it != filter_list->end(); it++){
        SpValue p;
        p = it->eval();
        if(!p.isTrue()){
          boolean = false;
          break;
        }
      }
    }

    if(boolean){
      result = e.eval();
    }

  }catch(...){
    popCurrentNS();
    throw;
  }
  popCurrentNS();

  return boolean;
}

SpListCompreDiag* SpListCompreDiag::calc_next_list(IntVector& lengths,
                                                   SpValue& e,
                                                   SpValue& c,
                                                   SpValue& f,
                                                   SpValue& env,
                                                   int  max,
                                                   int& idx,
                                                   IntVector& rval,
                                                   IntVector& base,
                                                   IntVector& move,
                                                   int  depth,
                                                   int* dimension)
{
  // ʂƂċ󃊃Xg̏ꍇANullԂ
  //   Head̒l炩ߌvZĂ
  //   ߂lAfilterʂȂƂɂ
  //   ̒l߂BȉAlɌJԂB
  //   ŏIIɁAfilterʂl݂ȂꍇɂNULLԂ
  SpListCompreDiag* result;
  SpValue val;
  SpValue exp = e;
  SpValue cre = c;
  SpValue fil = f;
  int* ptr;

  if(dimension == NULL){
    ptr = new int[depth];
    for(int i=0; i < depth; i++){
      ptr[i] = 0;
    }
  }else{
    ptr = dimension;
  }

  bool hasValue = calc_value(val, exp, cre, fil, env, ptr);
  while(!hasValue){
    if(calc_next_param(lengths, max, idx, rval, base, move, depth, ptr) == false){ // ȂƂiXg̏Ij
      if(dimension == NULL){
        delete[] ptr;
      }
      return NULL;
    }
    hasValue = calc_value(val, exp, cre, fil, env, ptr);
  }
  result = new SpListCompreDiag(val, exp, cre, fil, env, max, idx, rval, base, move, depth, ptr);
  return result;
}

void SpListCompreDiag::calcLength()
{
  //  len = 1;
  int len = 1;
  SpTuple* tpl = dynamic_cast<SpTuple*>(creators.getObject());
  SpValueVector::iterator it;
  it = tpl->begin();
  for(; it != tpl->end(); it++){
    SpListCreator* cre  = dynamic_cast<SpListCreator*>(it->getObject());
    SpList*        list = cre->list.asList();
    try{
      int j;
      j = list->length();
      if(len >= 0){
        len *= j;
      }
      lengths.push_back(j);
    }catch(SpNoLengthException& e){
      len = -1;
      lengths.push_back(-1);
    }
  }
}

SpListCompreDiag* SpListCompreDiag::Create(SpValue& e, SpValue& c, SpValue& f)
{
  // ʂƂċ󃊃Xg̏ꍇANullԂ
  //   ListCreator::listЂƂłNil̂ƂNULL
  int max  = 0;
  int index = 0;
  IntVector rval;
  IntVector base;
  IntVector move;
  IntVector lens;

  SpTuple* tpl = dynamic_cast<SpTuple*>(c.getObject());
  SpValueVector::iterator it;
  it = tpl->begin();
  for(; it != tpl->end(); it++){
    SpListCreator* cre = dynamic_cast<SpListCreator*>(it->getObject());
    cre->list = cre->expr.eval();
    if(cre->list.isNil()){
      return NULL;
    }
    if(!cre->list.isList()){
      throw SpException("not list (list comprehension //)");
    }
    SpList* ptr = cre->list.asList();
    int len;
    try{
      len = ptr->length();
      if(max >= 0){
        max += len;
      }
      lens.push_back(len);
    }catch(SpNoLengthException& e){
      max = -1;
      lens.push_back(len);
    }
  }
  if(max >= 0){
    max -= tpl->length();
  }
  int i = tpl->length();
  clearIntVector(rval, i);
  clearIntVector(base, i);
  clearIntVector(move, i);
  return calc_next_list(lens, e, c, f, getCurrentNS(), max, index, rval, base, move, tpl->length());
}

SpList* SpListCompreDiag::next()
{
  IntVector rval;
  IntVector base;
  IntVector move;
  int idx = index;
  int* ptr;

  copyIntVector(rval, rvalue);
  copyIntVector(base, base_pos);
  copyIntVector(move, move_pos);
  ptr = new int[depth];
  for(int i=0; i < depth; i++){
    ptr[i] = dim[i];
  }
  if(calc_next_param(lengths, max, idx, rval, base, move, depth, ptr) == false){ // ȂƂiXg̏Ij
    delete[] ptr;
    return NULL;
  }

  SpListCompreDiag* result;
  result = calc_next_list(lengths, expr, creators, filters, environ, max, idx, rval, base, move, depth, ptr);
  return result;
}

void SpListCompreDiag::clearIntVector(IntVector& dst, int len)
{
  for(int i=0; i < len; i++){
    dst.push_back(0);
  }
}

void SpListCompreDiag::copyIntVector(IntVector& dst, IntVector& src)
{
  IntVector::iterator it;
  it = src.begin();
  for(; it < src.end(); it++){
    dst.push_back(*it);
  }
}

// class SpListCompreDiagCreator
SpValue& SpListCompreDiagCreator::eval()
{
  SpListCompreDiag* list = SpListCompreDiag::Create(expr, creators, filters);
  if(list == NULL){
    return NilObject;
  }
  //  static SpValue result;
  //  result.setObject(list);
  //  return result;
  SpValue result;
  result.setObject(list);
  //  return SpObjectResult(list);
  return SpValueResult(result);
}

SpValue& SpListCompreDiagCreator::toString()
{
  SpString* str;

  str = new SpString();
  *str = "<list comprehension(diagonalising) creator>";
  //  static SpValue s;
  //  s.setNewObject(str);
  //  return s;
  return SpObjectResult(str);
}


/*
 * class SpPatternWColon
 */
SpValue& SpPatternWColon::toString()
{
    SpValue v1 = head.toString();
    SpValue v2 = tail.toString();
    SpString* s1 = dynamic_cast<SpString*>(v1.getObject());
    SpString* s2 = dynamic_cast<SpString*>(v2.getObject());
    *s1 += "::";
    *s1 += *s2;
    SpString* s = new SpString(s1->toCStringWithEncoder());
    //    static SpValue v;
    //    v.setNewObject(s);
    //    return v;
    return SpObjectResult(s);
}

bool SpPatternWColon::match(SpValue&, SpValue& val, SpNameSpace* ns)
{
    SpValue temp;
    if(!val.isList()){
        return false;
    }
    // val is list
    SpList* ptr = dynamic_cast<SpList*>(val.getObject());
    //if(!head.match(ptr->value(), ns)){
    temp = ptr->value();
    if(!head.match(temp, ns)){
        return false;
    }
    // match head
    //return tail.match(ptr->nextList(), ns);
    temp = ptr->nextList();
    return tail.match(temp, ns);
}

/*
 * class SpPatternAt
 */
SpValue& SpPatternAt::toString()
{
    SpValue v1 = list1.toString();
    SpValue v2 = list2.toString();
    SpString* s1 = dynamic_cast<SpString*>(v1.getObject());
    SpString* s2 = dynamic_cast<SpString*>(v2.getObject());
    *s1 += "@";
    *s1 += *s2;
    SpString* s = new SpString(s1->toCStringWithEncoder());
    //    static SpValue v;
    //    v.setNewObject(s);
    //    return v;
    return SpObjectResult(s);
}

bool SpPatternAt::match(SpValue&, SpValue& val, SpNameSpace* ns)
{
    if(!val.isList()){
        return false;
    }
    // val is list
    SpValue l1 = list1;
    SpValue l2 = val;
    while(l2.isList()){
        SpList* ptr = dynamic_cast<SpList*>(l1.getObject());
        SpList* ptr2 = dynamic_cast<SpList*>(l2.getObject());

        //if(!ptr->value().match(ptr2->value(), ns)){
        SpValue temp, temp2;
        temp = ptr->value();
        temp2 = ptr2->value();
        if(!temp.match(temp2, ns)){
            return false;
        }

        l1 = ptr->nextList();
        l2 = ptr2->nextList();
        if(l1.isNil()){
            return list2.match(l2,ns);
        }
    }
    return false;
}

