/*
 * Programming Language SOOPY
 *   (Simple Object Oriented Programming sYstem)
 * 
 * Copyright (C) 2002 SUZUKI Jun
 * 
 * URL: http://sourceforge.jp/projects/soopy/
 * License: GPL(GNU General Public License)
 * 
 * 
 * $Id: NameSpace.cpp,v 1.69 2004/03/27 05:08:14 randy Exp $
 */

#include "soopy.h"

//
// Soopy NameSpace Class
//

#ifndef USE_PTHREAD
vector<SpValue> Frame;
#endif

SpNameSpace::SpNameSpace(NSMap& m, SpValue& p)
{
    aMap = m;
    parentNS = p;
}

SpNameSpace::SpNameSpace(SpNameSpace* ns1, SpNameSpace* ns2, SpValue& p)
{
    aMap = ns1->aMap;
    NSMap::iterator found;
    NSMap::iterator it = ns2->aMap.begin();
    for(; it != ns2->aMap.end(); it++){
        found = aMap.find(it->first);
        if(found != aMap.end()){
            aMap.erase(found);
        }
        aMap[it->first] = it->second;
    }
    parentNS = p;
}

SpNameSpace::SpNameSpace(SpValue& p)
{
    parentNS = p;
}

SpNameSpace::~SpNameSpace()
{
#ifdef TEST
    *spout << ":destroy NameSpace:" << "\n";
#endif
//    NSMap::iterator it;
//    for(it = aMap.begin(); it != aMap.end(); it++){
//        delete it->first;
//    }
}

SpValue& SpNameSpace::toString()
{
    SpString* str;
    bool isPublic=true;

    str = new SpString();
    *str = "{\n";
    NSMap::iterator it;
    for(it = aMap.begin(); it != aMap.end(); it++){
        SpValue temp = it->first;
        NSKey* key = temp.asNSKey();
        if(key->isPublic != isPublic){
            isPublic = ! isPublic;
            if(isPublic){
                *str += "public\n";
            }else{
                *str += "private\n";
            }
        }
        *str += "  ";
        *str += key->toString();
        *str += ": ";
        *str += it->second.toString();
        *str += ";\n";
    }
    *str += "}";

    //    static SpValue s;
    //    s.setNewObject(str);
    //    return s;
    return SpObjectResult(str);
}

bool SpNameSpace::operator==(SpObject& obj)
{
    if(SpNameSpace* p2 = dynamic_cast<SpNameSpace*>(&obj)){
        if(size() != p2->size()){
            return false;
        }

        NSMap::iterator it;
        for(it = aMap.begin(); it != aMap.end(); it++){
            NSMap::iterator find;

            find = p2->aMap.find(it->first);
            if(find == p2->aMap.end()){ // not found
                return false;
            }
            if(it->second != find->second){
                return false;
            }
        }
        return true;
    }
    return false;
}

bool SpNameSpace::operator<(SpObject& obj)
{
    if(SpNameSpace* p2 = dynamic_cast<SpNameSpace*>(&obj)){
        int size1 = size();
        int size2 = p2->size();
        if(size1 != size2){
            return size1 < size2;
        }

        // ׂẴL[ǂ`FbN
        bool all_match = true;
        NSMap::iterator it;
        for(it = aMap.begin(); it != aMap.end(); it++){
            NSMap::iterator find;
            find = p2->aMap.find(it->first);
            if(find == p2->aMap.end()){ // not found
                all_match = false;
                break;
            }
        }

        if(all_match){
            // ׂẴL[ƂAlԂɔrB
            NSMap::iterator it;
            for(it = aMap.begin(); it != aMap.end(); it++){
                if(it->second != p2->aMap[it->first]){
                    return it->second < p2->aMap[it->first];
                }
            }
            return false;
        }else{
            // L[ʂ̂ƂAL[̑傫rB
            //   L[̏Ԃɂ͈ӖȂ̂ŁAł́A{͕s\B
            //   āAPȃl[Xy[XȊOAl[Xy[X̃L[ƂĎgׂł͂ȂB
            NSMap::iterator it;
            NSMap::iterator it2;
            for(it = aMap.begin(), it2 = p2->aMap.begin();
                it != aMap.end();
                it++, it2++)
            {
                SpValue temp;
                temp = it->first;
                NSKey* key1 = temp.asNSKey();
                temp = it2->first;
                NSKey* key2 = temp.asNSKey();
                SpValue v1 = key1->val;
                SpValue v2 = key2->val;
                if(v1 != v2){
                    return v1 < v2;
                }
            }
        }
    }
    return SpObject::operator<(obj);
}

SpNameSpace& SpNameSpace::operator+=(SpNameSpace& ns)
{
    NSMap::iterator it;
    for(it=ns.begin(); it != ns.end(); it++){
        this->setValue((SpValue&)it->first, it->second, (SpNameSpace*)this);
    }
    return *this;
}

bool SpNameSpace::reachable(SpNameSpace* ns)
{
  if(ns == NULL) return false;
  if(this == ns){
    return true;
  }
  if(!parentNS.isNil()){
    SpNameSpace* p = parentNS.asNameSpace();
    return p->reachable(ns);
  }
  return false;
}

SpValue& SpNameSpace::lookup(SpValue& v, SpNameSpace* searcher)
{
    NSVar* key = new NSVar(v);
    try{
        return getValue(key, searcher, NULL, true);
    //}catch(SpAccessException& e){
    //    throw;
    //}catch(SpException& e){
    }catch(SpKeyException& e){
        return NilObject;
    }
}

// search 1 level only
SpValue& SpNameSpace::lookup1(SpValue& v, SpNameSpace* searcher)
{
    NSVar* key = new NSVar(v);
    try{
        return getValue(key, searcher, NULL, false);
    //}catch(SpAccessException& e){
    //    throw;
    //}catch(SpException& e){
    }catch(SpKeyException& e){
        return NilObject;
    }
}

SpValue& SpNameSpace::getValue(NSKey* k, SpNameSpace* searcher, SpNameSpace* cur_ns, bool search_parent)
{
//cout << "getValue key:'" << *k << "'" << endl;
    if(cur_ns == NULL){
        cur_ns = this;
    }
    NSKey* ptr;
    //    SpValue key(k);
    SpValue key;
    key.setObject(k);
    NSMap::iterator it;
    it = aMap.find(key);
    if(it != aMap.end()){
        SpValue temp = it->first;
        ptr = temp.asNSKey();
        // check permission
        if(!ptr->isPublic){
            if(searcher == NULL){
                throw SpAccessException("can't access private feature.");
            }
            if(!searcher->reachable(this)){
                throw SpAccessException("can't access private feature.");
            }
        }
        if(ptr->isNSProperty()){
            NSProperty* pro = (NSProperty*)ptr;
            NSVar* var = new NSVar(pro->getter);
            SpValue key2(var);
            it = aMap.find(key2);
            if(it == aMap.end()){ throw SpException("no getter in property"); }
            temp = it->first;
            NSKey* ptr2 = dynamic_cast<NSKey*>(temp.getObject());
            if(ptr2->isNSFunc()){
                SpFunc* func = it->second.asFunc();
                //static SpValue v;
                SpValue v;
                // push this to currentNS
                SpValue ns(cur_ns);
                pushCurrentNS(ns);
                try{
                    v = (*func)(NilObject);
                }catch(...){
                    popCurrentNS();
                    throw;
                }
                popCurrentNS();
		//                return v;
		return SpValueResult(v);
            }else{
                return it->second;
            }
        }else if(ptr->isNSPrimProperty()){
            NSPrimProperty* pro = (NSPrimProperty*)ptr;
            if(pro->getter.isFunc()){
                SpFunc* func = pro->getter.asFunc();
		//                static SpValue v;
                SpValue v;
                // push this to currentNS
                SpValue ns(cur_ns);
                pushCurrentNS(ns);
                try{
                    v = (*func)(NilObject);
                }catch(...){
                    popCurrentNS();
                    throw;
                }
                popCurrentNS();
		//                return v;
		return SpValueResult(v);
            }else{
                return it->second;
            }
        }else if(ptr->isNSFunc()){
            //SpValue ns(this);
            SpValue ns(cur_ns);
            SpClosure* clos = new SpClosure(it->second, ns);
	    //            static SpValue result;
	    //            result.setNewObject(clos);
	    //            return result;
	    return SpObjectResult(clos);
        }else{
            return it->second;
        }
    }
    // not found
    if(search_parent && !parentNS.isNil()){
        SpNameSpace* ns = dynamic_cast<SpNameSpace*>(parentNS.getObject());
        return ns->getValue(k, searcher, cur_ns);
    }

    throw SpKeyException("no such a key", k->toCStringWithEncoder());
}

void SpNameSpace::setValue(SpValue& key, SpValue& val, SpNameSpace* searcher, SpNameSpace* cur_ns)
{
    SpValue old_value;
    if(cur_ns == NULL){
        cur_ns = this;
    }
    NSMap::iterator it;
    it = aMap.find(key);
    if(it != aMap.end()){
        old_value = it->second;
        SpValue temp = it->first;
        NSKey* ptr = temp.asNSKey();
        // check permission
        if(!ptr->isPublic){
            if(searcher == NULL){
                throw SpAccessException("can't access private feature.");
            }
            if(!searcher->reachable(this)){
                throw SpAccessException("can't access private feature.");
            }
        }
        if(ptr->isNSProperty()){
            NSProperty* pro = (NSProperty*)ptr;
            NSVar* var = new NSVar(pro->setter);
            SpValue key2(var);
            it = aMap.find(key2);
            if(it == aMap.end()){ throw SpException("no setter in property"); }
            temp = it->first;
            NSKey* ptr2 = dynamic_cast<NSKey*>(temp.getObject());
            if(ptr2->isNSFunc()){
                SpFunc* func = it->second.asFunc();
                // push this to currentNS
                //SpValue ns(this);
                SpValue ns(cur_ns);
                pushCurrentNS(ns);
                try{
                    (*func)(val);
                }catch(...){
                    popCurrentNS();
                    throw;
                }
                popCurrentNS();
            }else if(ptr2->isNSConst()){
                throw SpException("setter is constant or function");
            }else{
                //aMap[pro->setter] = val;
                aMap[key2] = val;
            }
        }else if(ptr->isNSPrimProperty()){
            NSPrimProperty* pro = (NSPrimProperty*)ptr;
            if(pro->setter.isFunc()){
                SpFunc* func = pro->setter.asFunc();
		//                static SpValue v;
                // push this to currentNS
                SpValue ns(cur_ns);
                pushCurrentNS(ns);
                try{
                    (*func)(val);
                }catch(...){
                    popCurrentNS();
                    throw;
                }
                popCurrentNS();
            }else{
                //throw SpException("system error");
                throw SpSystemError(__FILE__, __LINE__);
            }
        }else{
            if(ptr->isNSConst()){
                throw SpException("can't change constant or function");
            }
	    aMap.erase(it);
            aMap[key] = val;
        }
    }else{
        if(!parentNS.isNil()){
            SpNameSpace* ns = dynamic_cast<SpNameSpace*>(parentNS.getObject());
            ns->setValue(key, val, searcher);
        }else if(this == PMainNameSpace){
            aMap[key] = val;
        }else{
            throw SpException("can't set undefined feature");
        }
    }
}

void SpNameSpace::intern(SpValue& key, SpValue& val)
{
    NSMap::iterator it = aMap.find(key);
    if(it != aMap.end()){
        aMap.erase(it);
    }
    aMap[key] = val;
}

/*
 * NSVar
 */

SpValue& NSVar::toString()
{
    SpString* s = new SpString("var ");
    *s += val.toString();
    //    static SpValue v;
    //    v.setNewObject(s);
    //    return v;
    return SpObjectResult(s);
}


/*
 * NSCont
 */

SpValue& NSConst::toString()
{
    SpString* s1 = new SpString("const ");
    SpValue taker(s1);
    SpValue v2 = val.toString();
    SpString* s2 = dynamic_cast<SpString*>(v2.getObject());
    *s1 += *s2;
    SpString* s = new SpString(s1->toCStringWithEncoder());
    //    static SpValue v;
    //    v.setNewObject(s);
    //    return v;
    return SpObjectResult(s);
}


/*
 * NSProperty
 */

SpValue& NSProperty::toString()
{
    bool print_getter=false;
    SpString* s = new SpString("property ");
    SpValue taker(s);
    SpValue v0 = NSKey::toString();
    SpValue v1 = getter.toString();
    SpValue v2 = setter.toString();
    SpString* s1 = dynamic_cast<SpString*>(v1.getObject());
    SpString* s2 = dynamic_cast<SpString*>(v2.getObject());
    *s += v0;
    *s += " {";
    if(getter != NilObject){
        *s += "get: ";
        *s += *s1;
        print_getter = true;
    }
    if(setter != NilObject){
        if(print_getter){
            *s += ", ";
        }
        *s += "set: ";
        *s += *s2;
    }
    *s += "}";
    SpString* s3 = new SpString(s->toCStringWithEncoder());
    //    static SpValue v;
    //    v.setNewObject(s3);
    //    return v;
    return SpObjectResult(s3);
}


/*
 * NSPrimProperty
 */

SpValue& NSPrimProperty::toString()
{
    bool print_getter=false;
    SpString* s = new SpString("property ");
    SpValue taker(s);
    SpValue v0 = NSKey::toString();
    SpValue v1 = getter.toString();
    SpValue v2 = setter.toString();
    SpString* s1 = dynamic_cast<SpString*>(v1.getObject());
    SpString* s2 = dynamic_cast<SpString*>(v2.getObject());
    *s += v0;
    *s += " {";
    if(getter != NilObject){
        *s += "get: ";
        *s += *s1;
        print_getter = true;
    }
    if(setter != NilObject){
        if(print_getter){
            *s += ", ";
        }
        *s += "set: ";
        *s += *s2;
    }
    *s += "}";
    SpString* s3 = new SpString(s->toCStringWithEncoder());
    //    static SpValue v;
    //    v.setNewObject(s3);
    //    return v;
    return SpObjectResult(s3);
}


/*
 * Message Handler
 */

SpValue& SpNameSpace::onMessage(SpValue& rec, SpValue& msg)
{
    NSVar* key = new NSVar(msg);
    try{
        SpValue temp = getCurrentNS();
        SpNameSpace* ns = temp.asNameSpace();
        return getValue(key, ns);
        //        return lookup(msg);
    }catch(SpAccessException& e){
        throw;
    }catch(SpException& e){
        try{
            return NameSpaceMsgHandler(rec, msg);
        }catch(SpNoMethodException& e){
            return NilObject;
        }
    }
}

/*
 * primitives
 */

SpValue& SpNameSpace::rename(SpValue& self, SpValue& renames)
{
    if(!renames.isNameSpace()){
        throw SpException("arg is not namespace.(ns.rename)");
    }
    SpNameSpace* ns1 = self.asNameSpace();
    SpNameSpace* ns2 = renames.asNameSpace();

    NSMap assoc = ns1->aMap;
    NSMap::iterator it = ns2->aMap.begin();
    for(; it != ns2->aMap.end(); it++){
        NSMap::iterator found;
        found = assoc.find(it->first);
        if(found != assoc.end()){
            SpValue val = found->second;
            //NSKey* key = ((SpValue&)found->first).asNSKey();
            SpValue temp = found->first;
            NSKey* key = temp.asNSKey();
            if(key->isNSProperty()){
                NSProperty* p = (NSProperty*)key;
                key = new NSProperty(it->second, p->getter, p->setter, p->isPublic);
            }else if(key->isNSPrimProperty()){
                NSPrimProperty* p = (NSPrimProperty*)key;
                key = new NSProperty(it->second, p->getter, p->setter, p->isPublic);
            }else if(key->isNSFunc()){
                key = new NSFunc(it->second);
            }else if(key->isNSDataType()){
                key = new NSDataType(it->second);
            }else if(key->isNSConst()){
                key = new NSConst(it->second);
            }else{
                key = new NSVar(it->second);
            }
            assoc.erase(found);
            assoc[key] = val;
        }
    }

    //    static SpValue result;
    //    result.setNewObject(new SpNameSpace(assoc, ns1->parentNS));
    //    return result;
    return SpObjectResult(new SpNameSpace(assoc, ns1->parentNS));
}


SpValue& SpNameSpace::make_func(SpValue& self)
{
    SpNameSpace* ns = self.asNameSpace();
    SpValue f(SpUsrFunc::fromNameSpace(ns));
    //    static SpValue result;
    //    result.setNewObject(new SpClosure(f, self));
    //    return result;
    return SpObjectResult(new SpClosure(f, self));
}

static SpValue PrimAppend;

SpValue& SpNameSpace::prim_append(SpValue& self, SpValue& key, SpValue& val)
{
    SpNameSpace* ns = self.asNameSpace();
    SpValue v1 = key.eval();
    SpValue v2 = val.eval();
    ns->internVar(v1, v2);

    //    static SpValue result;
    //    result.setNewObject(new SpClosureP3_1(PrimAppend, self, getCurrentNS()));
    //    return result;
    return SpObjectResult(new SpClosureP3_1(PrimAppend, self, getCurrentNS()));
}

SpValue& SpNameSpace::prim_keys(SpValue& self)
{
    //    static SpValue result;
    SpValue result;
    result = NilObject;
    SpNameSpace* ns = self.asNameSpace();

    NSMap::iterator it = ns->aMap.begin();
    for(; it != ns->aMap.end(); it++){
        NSKey* key;
        key = ((SpValue)it->first).asNSKey();
        result.setNewObject(new SpCons(key->val, result));
    }

    //    return result;
    return SpValueResult(result);
}

SpValue& SpNameSpace::prim_delete(SpValue& self, SpValue& key)
{
    SpNameSpace* ns = self.asNameSpace();
    NSVar var(key);
    SpValue k;
    k.setObject(&var);
    NSMap::iterator found = ns->aMap.find(k);
    if(found != ns->aMap.end()){
        ns->aMap.erase(found);
        return TrueObject;
    }
    return FalseObject;
}

SpValue& SpNameSpace::prim_lookup(SpValue& self, SpValue& key)
{
    SpNameSpace* ns = self.asNameSpace();
    SpValue v = key.eval();
    //    static SpValue result;
    //    result = ns->lookup(v);
    //    return result;
    return SpValueResult(ns->lookup(v));
}

/*
 * init NameSpace
 */

SpNameSpace* PMainNameSpace;
SpValue MainNS;
SpNameSpace* PSoopyNameSpace;
SpValue SoopyNS;
SpNameSpace* PEnvNameSpace;
SpValue EnvNS;

void SpNameSpace::init()
{
    PMainNameSpace = new SpNameSpace();
    MainNS.setNewObject(PMainNameSpace);
    pushCurrentNS(MainNS);

    PSoopyNameSpace = new SpNameSpace();
    SoopyNS.setNewObject(PSoopyNameSpace);
    PMainNameSpace->internConst(SymSoopy, SoopyNS);

    PEnvNameSpace = new SpNameSpace();
    EnvNS.setNewObject(PEnvNameSpace);
    PMainNameSpace->internConst(SymEnv, EnvNS);

    SpValue PrimRename(new SpPrim2(rename));
    NameSpaceMsgHandler.append(SymRename, PrimRename);

    SpValue SymEval(new SpSymbol("eval"));
    SpValue PrimEval(new SpPrim1(make_func));
    NameSpaceMsgHandler.append(SymEval, PrimEval);

    PrimAppend.setNewObject(new SpPrim3(prim_append));
    NameSpaceMsgHandler.append(SymAppend, PrimAppend);

    SpValue PrimKeys(new SpPrim1(prim_keys));
    NameSpaceMsgHandler.append(SymKeys, PrimKeys);

    SpValue PrimDelete(new SpPrim2(prim_delete));
    NameSpaceMsgHandler.append(SymDelete, PrimDelete);

    SpValue SymLookup(new SpSymbol("lookup"));
    SpValue PrimLookup(new SpPrim2(prim_lookup));
    NameSpaceMsgHandler.append(SymLookup, PrimLookup);
}

/*
 * operator +
 */

SpValue& SpNameSpace::plus(SpValue& e1, SpValue& e2)
{
    SpNameSpace* ns1;
    SpNameSpace* ns2;
    SpNameSpace* ns3;

    if(!e2.isNameSpace()){
        throw SpException("type mismatch in +(NameSpace, ...)");
    }
    ns1 = dynamic_cast<SpNameSpace*>(e1.getObject());
    ns2 = dynamic_cast<SpNameSpace*>(e2.getObject());
    ns3 = new SpNameSpace(ns1, ns2, getCurrentNS());
    //    static SpValue v;
    //    v.setNewObject(ns3);
    //    return v;
    return SpObjectResult(ns3);
}


/*
 * class MakeNameSpace
 */

SpValue& MakeNameSpace::eval()
{
    SpNameSpace* src = dynamic_cast<SpNameSpace*>(ns.getObject());
    SpNameSpace* assoc = new SpNameSpace(getCurrentNS());
    NSMap::iterator it = src->aMap.begin();
    for(; it != src->aMap.end(); it++){
        SpValue temp = it->first;
        if(temp.isNSKey() && temp.asNSKey()->isNSDataType()){
            SpDataType* dt = it->second.asDataType();
            dt->mapping2ns(it->second, assoc);
        }else{
            SpValue v = it->second.eval();
            temp = it->first;
            assoc->intern(temp, v);
        }
    }
    //    static SpValue result;
    //    result.setNewObject(assoc);
    //    return result;
    return SpObjectResult(assoc);
}

SpValue& MakeNameSpace::toString()
{
    SpString* str;

    str = new SpString();
    *str = "MakeNameSpace(";
    *str += ns.toString();
    *str += ")";
    //    static SpValue s;
    //    s.setNewObject(str);
    //    return s;
    return SpObjectResult(str);
}
