/*
 * Programming Language SOOPY
 *   (Simple Object Oriented Programming sYstem)
 * 
 * Copyright (C) 2002 SUZUKI Jun
 * 
 * URL: http://sourceforge.jp/projects/soopy/
 * License: GPL(GNU General Public License)
 * 
 * 
 * $Id: SendMsg.cpp,v 1.13 2004/03/26 11:17:12 randy Exp $
 */


#include "soopy.h"

/*
 * Class SpSendMsg
 */

SpSendMsg::~SpSendMsg()
{
#ifdef TEST
    *spout << ":destroy SpSendMsg:\n";
#endif
}

SpValue& SpSendMsg::eval()
{
    SpValue result;
    SpValue val = receiver.eval();
    if(message.isSymbol()  && !val.isFunc()){
        //return val.onMessage(message);
        result = val.onMessage(message);
        return SpValueResult(result);
    }
    SpValue msg = message.eval();
    //    return val.onMessage(msg);
    result = val.onMessage(msg);
    return SpValueResult(result);
}

SpValue& SpSendMsg::toString()
{
    SpString* str;
    SpValue v1, v2;

    str = new SpString();
    //*str += "(";
    *str += receiver.toString();
    *str += " (";
    *str += message.toString();
    *str += ")";
    //    static SpValue s;
    //    s.setNewObject(str);
    //    return s;
    return SpObjectResult(str);
}

bool SpSendMsg::operator==(SpObject& obj)
{
    SpSendMsg* ptr = dynamic_cast<SpSendMsg*>(&obj);
    if(ptr != NULL){
        return (receiver == ptr->receiver) &&
                (message == ptr->message);
    }
    return false;
}

bool SpSendMsg::operator<(SpObject& obj)
{
    SpSendMsg* ptr = dynamic_cast<SpSendMsg*>(&obj);
    if(ptr != NULL){
        if(receiver != ptr->receiver){
            return receiver < ptr->receiver;
        }
        return message < ptr->message;
    }
    return SpObject::operator<(obj);
}

