/*
 * Programming Language SOOPY
 *   (Simple Object Oriented Programming sYstem)
 * 
 * Copyright (C) 2002 SUZUKI Jun
 * 
 * URL: http://sourceforge.jp/projects/soopy/
 * License: GPL(GNU General Public License)
 * 
 * 
 * $Id: Tuple.cpp,v 1.14 2004/03/25 13:25:48 randy Exp $
 */

//
// Soopy Tuple Class
//

#include "soopy.h"

SpTuple::~SpTuple()
{
#ifdef TEST
    *spout << ":destroy SpTuple: ";
    *spout << toString() << "\n";
#endif
}

SpValue& SpTuple::eval()
{
    SpValueVector::iterator it = vec.begin();
    //    SpTuple* tuple = new SpTuple(it->eval());
    SpValue  temp;
    temp = it->eval();
    SpTuple* tuple = new SpTuple(temp);
    it++;
    for(; it < vec.end(); it++){
        //        tuple->append(it->eval());
        temp = it->eval();
        tuple->append(temp);
    }

    //    static SpValue result;
    //    result.setNewObject(tuple);
    //    return result;
    return SpObjectResult(tuple);
}

SpValue& SpTuple::toString()
{
    SpString* str;
    SpValueVector::iterator it = vec.begin();

    str = new SpString();
    *str = "(";
    *str += it->toString();
    it++;
    for(; it < vec.end(); it++){
        *str += ", ";
        *str += it->toString();
    }
    *str += ")";
    //    static SpValue s;
    //    s.setNewObject(str);
    //    return s;
    return SpObjectResult(str);
}

bool SpTuple::operator==(SpObject& obj)
{
    if(SpTuple* s = dynamic_cast<SpTuple*>(&obj)){
        SpValueVector::iterator it = vec.begin();
        SpValueVector::iterator it2 = s->vec.begin();
        while(true){
            if(it == vec.end()){
                if(it2 == s->vec.end()){
                    return true;
                }
                break;
            }
            if(it2 == s->vec.end()){
                break;
            }
            if(*it != *it2){
                break;
            }
            it++;
            it2++;
        }
    }
    return false;
}

bool SpTuple::operator<(SpObject& obj)
{
    if(SpTuple* s = dynamic_cast<SpTuple*>(&obj)){
        SpValueVector::iterator it = vec.begin();
        SpValueVector::iterator it2 = s->vec.begin();
        while(true){
            if(it == vec.end()){
                if(it2 == s->vec.end()){
                    return false;
                }
                return true;
            }
            if(it2 == s->vec.end()){
                return false;
            }
            if(*it != *it2){
                return *it < *it2;
            }
            it++;
            it2++;
        }
    }
    return SpObject::operator<(obj);
}

bool SpTuple::match(SpValue&, SpValue& val, SpNameSpace* ns)
{
    if(val.isTuple()){
        SpTuple* t = dynamic_cast<SpTuple*>(val.getObject());
        if(length() == t->length()){
            SpValueVector::iterator it, it2;
            it = begin();
            it2 = t->begin();
            for(; it != end(); it++, it2++){
                if(!it->match(*it2, ns)){
                    return false;
                }
            }
            return true;
        }
    }
    return false;
}

/*
 * Message Handler
 */

SpValue& SpTuple::onMessage(SpValue& rec, SpValue& msg)
{
    return TupleMsgHandler(rec, msg);
}

// tuple Primitives

SpValue& SpTuple::get_length(SpValue& self)
{
    SpTuple* t = self.asTuple();
    //    static SpValue result;
    //    result.setInt(t->length());
    //    return result;
    return SpIntResult(t->length());
}

SpValue& SpTuple::first(SpValue& self)
{
    SpTuple* t = self.asTuple();
    if(t->length() < 1){
        throw SpException("tuple size mismatch (first)");
    }
    //    static SpValue result;
    //    result = (*t)[0];
    //    return result;
    return SpValueResult((*t)[0]);
}

SpValue& SpTuple::second(SpValue& self)
{
    SpTuple* t = self.asTuple();
    if(t->length() < 2){
        throw SpException("tuple size mismatch (second)");
    }
    //    static SpValue result;
    //    result = (*t)[1];
    //    return result;
    return SpValueResult((*t)[1]);
}

SpValue& SpTuple::third(SpValue& self)
{
    SpTuple* t = self.asTuple();
    if(t->length() < 3){
        throw SpException("tuple size mismatch (third)");
    }
    //    static SpValue result;
    //    result = (*t)[2];
    //    return result;
    return SpValueResult((*t)[2]);
}

SpValue& SpTuple::fourth(SpValue& self)
{
    SpTuple* t = self.asTuple();
    if(t->length() < 4){
        throw SpException("tuple size mismatch (fourth)");
    }
    //    static SpValue result;
    //    result = (*t)[3];
    //    return result;
    return SpValueResult((*t)[3]);
}

SpValue& SpTuple::fifth(SpValue& self)
{
    SpTuple* t = self.asTuple();
    if(t->length() < 5){
        throw SpException("tuple size mismatch (fifth)");
    }
    //    static SpValue result;
    //    result = (*t)[4];
    //    return result;
    return SpValueResult((*t)[4]);
}

SpValue& SpTuple::nth(SpValue& self, SpValue& index)
{
    if(!index.isInt()){
        throw SpException("not int. (tuple.nth)");
    }
    SpInt i = index.getInt();
    SpTuple* t = self.asTuple();
    if(t->length() < i+1){
        throw SpException("tuple size mismatch (tuple.nth)");
    }
    //    static SpValue result;
    //    result = (*t)[i];
    //    return result;
    return SpValueResult((*t)[i]);
}

// init Message Handler
void SpTuple::init()
{
    TupleMsgHandler.append(SymIsTuple, PrimTrue);

    SpValue PrimLength(new SpPrim1(get_length));
    TupleMsgHandler.append(SymLength, PrimLength);

    SpValue PrimFirst(new SpPrim1(first));
    TupleMsgHandler.append(SymFirst, PrimFirst);

    SpValue PrimSecond(new SpPrim1(second));
    TupleMsgHandler.append(SymSecond, PrimSecond);

    SpValue PrimThird(new SpPrim1(third));
    TupleMsgHandler.append(SymThird, PrimThird);

    SpValue PrimFourth(new SpPrim1(fourth));
    TupleMsgHandler.append(SymFourth, PrimFourth);

    SpValue PrimFifth(new SpPrim1(fifth));
    TupleMsgHandler.append(SymFifth, PrimFifth);

    SpValue PrimNth(new SpPrim2(nth));
    TupleMsgHandler.append(SymNth, PrimNth);
}

