/*
 * Programming Language SOOPY
 *   (Simple Object Oriented Programming sYstem)
 * 
 * Copyright (C) 2002,2003 SUZUKI Jun
 * 
 * URL: http://sourceforge.jp/projects/soopy/
 * License: GPL(GNU General Public License)
 * 
 * 
 * $Id: URLEncode.cpp,v 1.6 2004/03/21 05:48:06 randy Exp $
 */

#include <stdio.h>
#include "soopy.h"

/*
 * Class URLReader
 */

//  A-Z,a-z,0-9 & *-._   @          +$!'(), ~ ͂̂܂܁B

SpChar URLReadEncoder::readCh()
{
    switch(count){
      case 1:
      case 2:
      case 3:
      case 4:
      case 5:
        return results[count--];
      default:
        if(eof()){ return (SpChar)NULL; }
        SpChar c = reader->ReadChar();

        if(isDIGIT(c) || isAlpha(c)){
            return c;
        }
        if(isdigit(c) || isalpha(c)){
            return MakeSpChar(CodeJIS, c);
        }
        switch(c){
          case JIS('*'):
          case JIS('-'):
          case JIS('.'):
          case JIS('_'):
            return c;
          case '*':
          case '-':
          case '.':
          case '_':
            return MakeSpChar(CodeJIS, c);
        }

        char buf[5];
        SpChar c2 = SpCharGetChar(c);
        if(c2 >=0xFF){
            // set 4 chars
            sprintf(buf, "%04X", c2);
            results[5] = MakeSpChar(CodeJIS, buf[0]);
            results[4] = MakeSpChar(CodeJIS, buf[1]);
            results[2] = MakeSpChar(CodeJIS, buf[2]);
            results[1] = MakeSpChar(CodeJIS, buf[3]);
            // set count
            count = 5;
        }else{
            // set 2 chars
            sprintf(buf, "%02X", c2);
            results[2] = MakeSpChar(CodeJIS, buf[0]);
            results[1] = MakeSpChar(CodeJIS, buf[1]);
            // set count
            count = 2;
        }
    }

    return results[0];
}

/*
 * Class URLWriteEncoder
 */

//void URLWriteEncoder::writeCh(unsigned char c)
void URLWriteEncoder::WriteChar(SpChar c)
{
    if(isdigit(c) || isalpha(c)){
        writer->WriteChar(c);
        return;
    }
    switch(c){
      case '*':
      case '-':
      case '.':
      case '_':
        writer->WriteChar(c);
        return;
    }

    // set 2 chars
    char buf[2];
    sprintf(buf, "%02X", c);
    writer->WriteChar(MakeSpChar(CodeJIS, '%'));
    writer->WriteChar(MakeSpChar(CodeJIS, buf[0]));
    writer->WriteChar(MakeSpChar(CodeJIS, buf[1]));
}

/*
 * Class URLReader
 */

static bool isURLChar(char c)
{
    if(isdigit(c)){
        return true;
    }
    if(isalpha(c)){
        return true;
    }
    if((c == '+') ||
       (c == '/') ||
       (c == '='))
    {
        return true;
    }
    return false;
}

static int decodeChar(int c)
{
    int result;
    if(isupper(c)){
        result = c - 'A';
    }else if(islower(c)){
        result = c - 'a' + 26;
    }else if(isdigit(c)){
        result = c - '0' + 52;
    }else{
        switch(c){
          case '+':
            result = 62;
            break;
          case '/':
            result = 63;
            break;
          case '=':
            result = 0;
            break;
        }
    }
    return result;
}

SpChar URLReadDecoder::readCh()
{
    SpChar c = reader->ReadChar();
    if(c != JIS('%')){
        return c;
    }

    int i;
    c = toHankakuLower(reader->ReadChar());
    if(isDIGIT(c)){ // '0' - '9'
        i = (c - JIS('0')) * 0x10;
    }else{          // 'a' - 'f'
        i = (c - JIS('a') + 10) * 0x10;
    }
    c = toHankakuLower(reader->ReadChar());
    if(isDIGIT(c)){ // '0' - '9'
        i = i + (c - JIS('0'));
    }else{          // 'a' - 'f'
        i = i + (c - JIS('a') + 10);
    }
    return i;
}

/*
 * Class URLWriteDecoder
 */

void URLWriteDecoder::WriteChar(SpChar c)
{
    switch(count){
      case 0:
        if(c != '%'){
            writer->WriteChar(c);
            return;
        }
        // c == '%'
        count++;
        break;
      case 1:
        c = tolower(c);
        if(isdigit(c)){ // '0' - '9'
            src = (c - '0') * 0x10;
        }else{          // 'a' - 'f'
            src = (c - 'a' + 10) * 0x10;
        }
        count++;
        break;
      case 2:
        c = tolower(c);
        if(isdigit(c)){ // '0' - '9'
            src = src + (c - '0');
        }else{          // 'a' - 'f'
            src = src + (c - 'a' + 10);
        }
        writer->WriteChar(src);
        count = 0;
        break;
    }
}

/*
 * URL
 */

SpValue& url_encoderIn(SpValue& v)
{
    SpValue r = v.eval();
    if(!r.isReader()){
        throw SpException("not reader (URL.encoderIn)");
    }
    Reader* reader = r.asReader();
    ReadEncoder* encoder = new URLReadEncoder(reader);
    //    static SpValue result;
    //    result.setNewObject(encoder);
    //    return result;
    return SpObjectResult(encoder);
}

SpValue& url_encoderOut(SpValue& v)
{
    SpValue w = v.eval();
    if(!w.isWriter()){
        throw SpException("not writer (URL.encoderOut)");
    }
    Writer* writer = w.asWriter();
    WriteEncoder* encoder = new URLWriteEncoder(writer);
    //    static SpValue result;
    //    result.setNewObject(encoder);
    //    return result;
    return SpObjectResult(encoder);
}

SpValue& url_decoderIn(SpValue& v)
{
    SpValue r = v.eval();
    if(!r.isReader()){
        throw SpException("not reader (URL.decoderIn)");
    }
    Reader* reader = r.asReader();
    ReadEncoder* encoder = new URLReadDecoder(reader);
    //    static SpValue result;
    //    result.setNewObject(encoder);
    //    return result;
    return SpObjectResult(encoder);
}

SpValue& url_decoderOut(SpValue& v)
{
    SpValue w = v.eval();
    if(!w.isWriter()){
        throw SpException("not writer (URL.decoderOut)");
    }
    Writer* writer = w.asWriter();
    WriteEncoder* encoder = new URLWriteDecoder(writer);
    //    static SpValue result;
    //    result.setNewObject(encoder);
    //    return result;
    return SpObjectResult(encoder);
}

// init
void initURL()
{
    SpValue SymURLEncoder(new SpSymbol("urlencoder"));
    SpNameSpace* ns = new SpNameSpace;
    SpValue NSURLEncoder(ns);
    PMainNameSpace->internConst(SymURLEncoder, NSURLEncoder);

    SpValue PrimEncoderIn(new SpPrim1(&url_encoderIn));
    ns->internConst(SymEncoderIn, PrimEncoderIn);
    SpValue PrimDecoderIn(new SpPrim1(&url_decoderIn));
    ns->internConst(SymDecoderIn, PrimDecoderIn);

    SpValue PrimEncoderOut(new SpPrim1(&url_encoderOut));
    ns->internConst(SymEncoderOut, PrimEncoderOut);
    SpValue PrimDecoderOut(new SpPrim1(&url_decoderOut));
    ns->internConst(SymDecoderOut, PrimDecoderOut);
}

