/*
 * Programming Language SOOPY
 *   (Simple Object Oriented Programming sYstem)
 * 
 * Copyright (C) 2002,2003 SUZUKI Jun
 * 
 * URL: http://sourceforge.jp/projects/soopy/
 * License: GPL(GNU General Public License)
 * 
 * 
 * $Id: Word.cpp,v 1.16 2004/05/22 05:22:34 randy Exp $
 */

#include "soopy.h"

/*
 * Word16File
 *   openIn, openOut
 */

class Word16ReadEncoder : public ReadEncoder {
private:
    SpChar readCh(){
        char c1, c2;
//        c1 = reader->readCh();
//        c2 = reader->readCh();
        c1 = reader->ReadChar();
        c2 = reader->ReadChar();
        SpChar c = (((SpChar)c1) << 8) | c2;
        return c;
    }
public:
    Word16ReadEncoder(Reader* r) : ReadEncoder(r) {}
};

class Word16WriteEncoder : public WriteEncoder {
private:
    //void writeCh(SpChar c){
    void WriteChar(SpChar c){
//        writer->writeCh((c >> 8) & 0xff);
//        writer->writeCh(c & 0xff);
        writer->WriteChar((c >> 8) & 0xff);
        writer->WriteChar(c & 0xff);
    }
public:
    Word16WriteEncoder(Writer* w) : WriteEncoder(w) {}
};

SpValue& word16_openIn(SpValue& v)
{
    SpValue name = v.eval();
    if(!name.isString()){
        throw SpException("filename is not string (Word16File.openIn)");
    }
    SpString* str = name.asString();
    char* filename = (char*)str->toCStringWithEncoder();
    ifstream* fin = new ifstream;
#ifdef __WIN32__
    fin->open(filename, ios::binary);
#else
    fin->open(filename);
#endif
    if(fin->fail()){
        delete fin;
        throw SpException("can't open file");
    }
    FileStreamReader* sr = new FileStreamReader(fin, filename);
    ReadEncoder* encoder = new Word16ReadEncoder(sr);
    //    static SpValue result;
    //    result.setNewObject(encoder);
    //    return result;
    return SpObjectResult(encoder);
}

SpValue& word16_openOut(SpValue& v)
{
    SpValue name = v.eval();
    if(!name.isString()){
        throw SpException("filename is not string (Word16File.openOut)");
    }
    SpString* str = name.asString();
    char* filename = (char*)str->toCStringWithEncoder();
    ofstream* fout = new ofstream;
#ifdef __WIN32__
    fout->open(filename, ios::binary);
#else
    fout->open(filename);
#endif
    if(fout->fail()){
        delete fout;
        throw SpException("can't open file");
    }
    FileStreamWriter* sw = new FileStreamWriter(fout, filename);
    WriteEncoder* encoder = new Word16WriteEncoder(sw);
    //    static SpValue result;
    //    result.setNewObject(encoder);
    //    return result;
    return SpObjectResult(encoder);
}

SpValue& word16_openAppend(SpValue& v)
{
    SpValue name = v.eval();
    if(!name.isString()){
        throw SpException("filename is not string (Word16.openAppend)");
    }
    SpString* str = name.asString();
    char* filename = (char*)str->toCStringWithEncoder();
    ofstream* fout = new ofstream;
#ifdef __WIN32__
    fout->open(filename, ios::app | ios::binary);
#else
    fout->open(filename, ios::app);
#endif
    if(fout->fail()){
        delete fout;
        throw SpException("can't open file");
    }
    FileStreamWriter* sw = new FileStreamWriter(fout, filename);
    WriteEncoder* encoder = new Word16WriteEncoder(sw);
    //    static SpValue result;
    //    result.setNewObject(encoder);
    //    return result;
    return SpObjectResult(encoder);
}

/*
 * Word32File
 *   openIn, openOut
 */

class Word32ReadEncoder : public ReadEncoder {
private:
    SpChar readCh(){
        SpChar c1, c2, c3, c4;
/*
        c1 = reader->readCh();
        c2 = reader->readCh();
        c3 = reader->readCh();
        c4 = reader->readCh();
*/
        c1 = reader->ReadChar();
        c2 = reader->ReadChar();
        c3 = reader->ReadChar();
        c4 = reader->ReadChar();
        SpChar c = (c1 << 24) | (c2 << 16) | (c3 << 8) | c4;
        return c;
    }
public:
    Word32ReadEncoder(Reader* r) : ReadEncoder(r) {}
};

class Word32WriteEncoder : public WriteEncoder {
private:
    //void writeCh(SpChar c){
    void WriteChar(SpChar c){
//        writer->writeCh((c >> 24) & 0xff);
//        writer->writeCh((c >> 16) & 0xff);
//        writer->writeCh((c >> 8) & 0xff);
//        writer->writeCh(c & 0xff);
        writer->WriteChar((c >> 24) & 0xff);
        writer->WriteChar((c >> 16) & 0xff);
        writer->WriteChar((c >> 8) & 0xff);
        writer->WriteChar(c & 0xff);
    }
public:
    Word32WriteEncoder(Writer* w) : WriteEncoder(w) {}
};

SpValue& word32_openIn(SpValue& v)
{
    SpValue name = v.eval();
    if(!name.isString()){
        throw SpException("filename is not string (Word32File.openIn)");
    }
    SpString* str = name.asString();
    char* filename = (char*)str->toCStringWithEncoder();
    ifstream* fin = new ifstream;
#ifdef __WIN32__
    fin->open(filename, ios::binary);
#else
    fin->open(filename);
#endif
    if(fin->fail()){
        delete fin;
        throw SpException("can't open file");
    }
    FileStreamReader* sr = new FileStreamReader(fin, filename);
    ReadEncoder* encoder = new Word32ReadEncoder(sr);
    //    static SpValue result;
    //    result.setNewObject(encoder);
    //    return result;
    return SpObjectResult(encoder);
}

SpValue& word32_openOut(SpValue& v)
{
    SpValue name = v.eval();
    if(!name.isString()){
        throw SpException("filename is not string (Word32File.openOut)");
    }
    SpString* str = name.asString();
    char* filename = (char*)str->toCStringWithEncoder();
    ofstream* fout = new ofstream;
#ifdef __WIN32__
    fout->open(filename, ios::binary);
#else
    fout->open(filename);
#endif
    if(fout->fail()){
        delete fout;
        throw SpException("can't open file");
    }
    FileStreamWriter* sw = new FileStreamWriter(fout, filename);
    WriteEncoder* encoder = new Word32WriteEncoder(sw);
    //    static SpValue result;
    //    result.setNewObject(encoder);
    //    return result;
    return SpObjectResult(encoder);
}

SpValue& word32_openAppend(SpValue& v)
{
    SpValue name = v.eval();
    if(!name.isString()){
        throw SpException("filename is not string (Word32.openAppend)");
    }
    SpString* str = name.asString();
    char* filename = (char*)str->toCStringWithEncoder();
    ofstream* fout = new ofstream;
#ifdef __WIN32__
    fout->open(filename, ios::app | ios::binary);
#else
    fout->open(filename, ios::app);
#endif
    if(fout->fail()){
        delete fout;
        throw SpException("can't open file");
    }
    FileStreamWriter* sw = new FileStreamWriter(fout, filename);
    WriteEncoder* encoder = new Word32WriteEncoder(sw);
    //    static SpValue result;
    //    result.setNewObject(encoder);
    //    return result;
    return SpObjectResult(encoder);
}

void initWordFile()
{
    // init Word16
    SpValue SymWord16File(new SpSymbol("word16"));
    SpNameSpace* ns = new SpNameSpace;
    SpValue NSWord16File(ns);
    PMainNameSpace->internConst(SymWord16File, NSWord16File);

    SpValue PrimOpenIn(new SpPrim1(&word16_openIn));
    ns->internConst(SymOpenIn, PrimOpenIn);

    SpValue PrimOpenOut(new SpPrim1(&word16_openOut));
    ns->internConst(SymOpenOut, PrimOpenOut);

    SpValue PrimOpenAppend(new SpPrim1(&word16_openAppend));
    ns->internConst(SymOpenOut, PrimOpenOut);

    // init Word32
    SpValue SymWord32File(new SpSymbol("word32"));
    SpNameSpace* ns32 = new SpNameSpace;
    SpValue NSWord32File(ns32);
    PMainNameSpace->internConst(SymWord32File, NSWord32File);

    SpValue PrimOpenIn32(new SpPrim1(&word32_openIn));
    ns32->internConst(SymOpenIn, PrimOpenIn32);

    SpValue PrimOpenOut32(new SpPrim1(&word32_openOut));
    ns32->internConst(SymOpenOut, PrimOpenOut32);

    SpValue PrimOpenAppend32(new SpPrim1(&word32_openAppend));
    ns32->internConst(SymOpenAppend, PrimOpenAppend32);
}


