/*
 * Programming Language SOOPY
 *   (Simple Object Oriented Programming sYstem)
 *
 * Copyright (C) 2002 SUZUKI Jun
 *
 * URL: http://sourceforge.jp/projects/soopy/
 * License: GPL(GNU General Public License)
 *
 *
 * $Id: Button.cpp,v 1.6 2004/05/10 09:58:17 randy Exp $
 */

#include <clx.h>
#pragma hdrstop

#include "soopyg.h"

/*
 * class TSpButton
 */

void __fastcall TSpButton::Click(void)
{
    TWinControl::Click();        // nȟĂяoȂǕWIȏs
    SpValue onClick  = ns->lookup(SymOnClick);
    if(onClick.isFunc()){
        SpFunc* f = onClick.asFunc();
        (*f)(NilObject);
    }
}

void __fastcall TSpButton::DblClick(void)
{
    TWinControl::DblClick();        // nȟĂяoȂǕWIȏs
    SpValue onDblClick  = ns->lookup(SymOnDblClick);
    if(onDblClick.isFunc()){
        SpFunc* f = onDblClick.asFunc();
        (*f)(NilObject);
    }
}


/*
 * class SpButton
 */

SpValue& SpButton::make()
{
    SpButton* button = new SpButton(getCurrentNS());
//    static SpValue result;
//    result.setNewObject(button);
//    return result;
  return SpObjectResult(button);
}

// Caption
SpValue& SpButton::getCaption(TWidgetControl* w)
{
//    static SpValue result;
//    result.setNewObject(new SpString(AnsiString(((TButton*)w)->Caption).c_str()));
//    return result;
  return SpObjectResult(new SpString(AnsiString(((TButton*)w)->Caption).c_str()));
}

void SpButton::setCaption(TWidgetControl* w, const char* str)
{
    ((TButton*)w)->Caption = str;
}

void SpButton::creation(SpValue& parentNS, TWidgetControl* parent)
{
    SpNameSpace* assoc = ns.asNameSpace();
    widget = new TSpButton(parent, assoc);

    SpComponent::after_creation(assoc, parentNS, parent, (TWidgetControl*)widget);

    SpValue self(this);
    assoc->internConst(SymSelf, self);

    initProperties(assoc); // SpComponent::initProperties
}

void SpButton::init()
{
    // set namespace to symbol 'std_button'.
    PButtonNameSpace = new SpNameSpace(PComponentNameSpace->getMap());
    ButtonNS.setNewObject(PButtonNameSpace);
    SpValue SymStdButton(new SpSymbol("std_button"));
    PMainNameSpace->internConst(SymStdButton, ButtonNS);

    SpValue PrimMake(new SpPrim0(make));
    PButtonNameSpace->internFunc(SymMake, PrimMake);
}

