/*
 * Programming Language SOOPY
 *   (Simple Object Oriented Programming sYstem)
 *
 * Copyright (C) 2002 SUZUKI Jun
 *
 * URL: http://sourceforge.jp/projects/soopy/
 * License: GPL(GNU General Public License)
 *
 *
 * $Id: Combo.cpp,v 1.7 2004/05/10 09:58:17 randy Exp $
 */

#include <clx.h>
#pragma hdrstop

#include "soopyg.h"

/*
 * class TSpComboBox
 */

void __fastcall TSpComboBox::Click(void)
{
    TWinControl::Click();        // $B%O%s%I%i$N8F$S=P$7$J$II8=`E*$J=hM}$r<B9T(B
    SpValue onClick  = ns->lookup(SymOnClick);
    if(onClick.isFunc()){
        SpFunc* f = onClick.asFunc();
        (*f)(NilObject);
    }
}

void __fastcall TSpComboBox::Change(void)
{
    TCustomComboBox::Change();        // $B%O%s%I%i$N8F$S=P$7$J$II8=`E*$J=hM}$r<B9T(B
    SpValue onChange  = ns->lookup(SymOnChange);
    if(onChange.isFunc()){
        SpFunc* f = onChange.asFunc();
        (*f)(NilObject);
    }
}


/*
 * class SpComboBox
 */

SpValue& SpComboBox::make()
{
    SpComboBox* box = new SpComboBox(getCurrentNS());
//    static SpValue result;
//    result.setNewObject(box);
//    return result;
  return SpObjectResult(box);
}

// Caption
SpValue& SpComboBox::getCaption(TWidgetControl* w)
{
    throw SpCaptionException("can't get combobox.caption");
}

void SpComboBox::setCaption(TWidgetControl* w, const char* str)
{
    throw SpCaptionException("can't set combobox.caption");
}

void SpComboBox::creation(SpValue& parentNS, TWidgetControl* parent)
{
    SpNameSpace* assoc = ns.asNameSpace();
    widget = new TSpComboBox(parent, assoc);

    SpComponent::after_creation(assoc, parentNS, parent, (TWidgetControl*)widget);

    // set self
    SpValue self(this);
    assoc->internConst(SymSelf, self);

    // set text
    SpValue vtext  = assoc->lookup(SymText);
    if(vtext.isString()){
        ((TComboBox*)widget)->Text = vtext.toCStringWithEncoder();
    }

    // set items
    SpValue vitems = assoc->lookup(SymItems);
    if(vitems.isList()){
        while(!vitems.isNil()){
            SpList* ptr = vitems.asList();
            ((TComboBox*)widget)->Items->Add(ptr->value().toCStringWithEncoder());
            vitems = ptr->nextList();
        }
    }

    initProperties(assoc); // SpComponent::initProperties
}

// primitives
SpValue& SpComboBox::primGetText()
{
    SpValue n = getCurrentNS();
    SpNameSpace* ns = n.asNameSpace();
    SpValue self = ns->lookup(SymSelf);
    SpComponent* comp = self.asComponent();
//    static SpValue result;
//    result.setNewObject(new SpString(AnsiString(((TComboBox*)comp->widget)->Text).c_str()));
//    return result;
  return SpObjectResult(new SpString(AnsiString(((TComboBox*)comp->widget)->Text).c_str()));
}

SpValue& SpComboBox::primSetText(SpValue& v)
{
    if(v.isString()){
        SpValue n = getCurrentNS();
        SpNameSpace* ns = n.asNameSpace();
        SpValue self = ns->lookup(SymSelf);
        SpComponent* comp = self.asComponent();
        ((TComboBox*)comp->widget)->Text = v.toCStringWithEncoder();
    }
    return TrueObject;
}

// init
static SpValue GetText;
static SpValue SetText;

void SpComboBox::initProperties(SpNameSpace* pNS)
{
    SpComponent::initProperties(pNS);
    // Text
    pNS->internPrimProperty(SymText, NilObject, GetText, SetText);
}

void SpComboBox::init()
{
    // set namespace to symbol 'std_comboBox'.
    PComboBoxNameSpace = new SpNameSpace(PComponentNameSpace->getMap());
    ComboBoxNS.setNewObject(PComboBoxNameSpace);
    SpValue SymStdComboBox(new SpSymbol("std_combobox"));
    PMainNameSpace->internConst(SymStdComboBox, ComboBoxNS);

    // set default top, left, width, height
    SpValue I;
    I.setInt(80);
    PComboBoxNameSpace->internConst(SymWidth, I);

    GetText.setNewObject(new SpPrim0(primGetText));
    SetText.setNewObject(new SpPrim1(primSetText));

    SpValue PrimMake(new SpPrim0(make));
    PComboBoxNameSpace->internFunc(SymMake, PrimMake);
}

