/*
 * Programming Language SOOPY
 *   (Simple Object Oriented Programming sYstem)
 *
 * Copyright (C) 2002 SUZUKI Jun
 *
 * URL: http://sourceforge.jp/projects/soopy/
 * License: GPL(GNU General Public License)
 *
 *
 * $Id: Component.cpp,v 1.24 2004/05/15 11:16:51 randy Exp $
 */

#include <clx.h>
#pragma hdrstop

#include "soopyg.h"

SpValue SymTop;
SpValue SymLeft;
SpValue SymWidth;
SpValue SymHeight;
SpValue SymComponents;
SpValue SymTitle;
SpValue SymCaption;
SpValue SymMake;
SpValue SymOnClick;
SpValue SymOnDblClick;
SpValue SymParent;
SpValue SymAlign;
SpValue SymText;
SpValue SymOnChange;
//SpValue SymAppend;
SpValue SymClear;
SpValue SymCheckedP;
SpValue SymCanceledP;
SpValue SymFilename;
SpValue SymFilenames;
SpValue SymItems;
SpValue SymModifiedP;
SpValue SymMessage;
SpValue SymIndex;
SpValue SymCols;
SpValue SymRows;
SpValue SymCol;
SpValue SymRow;
SpValue SymTable;
SpValue SymHeader;
SpValue SymOnCreate;

SpValue AlNone(alNone);
SpValue AlTop(alTop);
SpValue AlBottom(alBottom);
SpValue AlLeft(alLeft);
SpValue AlRight(alRight);
SpValue AlClient(alClient);

SpNameSpace* PComponentNameSpace;
SpValue ComponentNS;
SpNameSpace* PLabelNameSpace;
SpValue LabelNS;
SpNameSpace* PWindowNameSpace;
SpValue WindowNS;
SpNameSpace* PPanelNameSpace;
SpValue PanelNS;
SpNameSpace* PButtonNameSpace;
SpValue ButtonNS;
SpNameSpace* PEditNameSpace;
SpValue EditNS;
SpNameSpace* PMemoNameSpace;
SpValue MemoNS;
SpNameSpace* PCheckBoxNameSpace;
SpValue CheckBoxNS;
SpNameSpace* PSaveDialogNameSpace;
SpValue SaveDialogNS;
SpNameSpace* POpenDialogNameSpace;
SpValue OpenDialogNS;
SpNameSpace* PComboBoxNameSpace;
SpValue ComboBoxNS;
SpNameSpace* PListBoxNameSpace;
SpValue ListBoxNS;
SpNameSpace* PRadioGroupNameSpace;
SpValue RadioGroupNS;
SpNameSpace* PRadioButtonNameSpace;
SpValue RadioButtonNS;
SpNameSpace* PTableViewNameSpace;
SpValue TableViewNS;

SpValue DefaultTop;
SpValue DefaultLeft;
SpValue DefaultWidth;
SpValue DefaultHeight;


// class SpValue
SpComponent* SpValue::asComponent()
{
    if(!isComponent()){
        throw SpException("not component");
    }
    SpComponent* ptr = dynamic_cast<SpComponent*>(pObject);
    if(ptr == NULL){ throw SpException("system error"); }
    return ptr;
}

/*
 * class TSpComponent
 */

/*
 * class SpComponent
 */

SpValue& SpComponent::primGetTop()
{
    SpValue n = getCurrentNS();
    SpNameSpace* ns = n.asNameSpace();
    SpValue self = ns->lookup(SymSelf);
    SpComponent* comp = self.asComponent();
//    static SpValue result;
//    result.setInt(((TWidgetControl*)comp->widget)->Top);
//    return result;
    SpValue result;
    result.setInt(((TWidgetControl*)comp->widget)->Top);
    return SpValueResult(result);
}

SpValue& SpComponent::primSetTop(SpValue& v)
{
    if(v.isInt()){
        SpValue n = getCurrentNS();
        SpNameSpace* ns = n.asNameSpace();
        SpValue self = ns->lookup(SymSelf);
        SpComponent* comp = self.asComponent();
        ((TWidgetControl*)comp->widget)->Top = v.getInt();
    }
    return TrueObject;
}

SpValue& SpComponent::primGetLeft()
{
    SpValue n = getCurrentNS();
    SpNameSpace* ns = n.asNameSpace();
    SpValue self = ns->lookup(SymSelf);
    SpComponent* comp = self.asComponent();
//    static SpValue result;
//    result.setInt(((TWidgetControl*)comp->widget)->Left);
//    return result;
    SpValue result;
    result.setInt(((TWidgetControl*)comp->widget)->Left);
    return SpValueResult(result);
}

SpValue& SpComponent::primSetLeft(SpValue& v)
{
    if(v.isInt()){
        SpValue n = getCurrentNS();
        SpNameSpace* ns = n.asNameSpace();
        SpValue self = ns->lookup(SymSelf);
        SpComponent* comp = self.asComponent();
        ((TWidgetControl*)comp->widget)->Left = v.getInt();
    }
    return TrueObject;
}

SpValue& SpComponent::primGetWidth()
{
    SpValue n = getCurrentNS();
    SpNameSpace* ns = n.asNameSpace();
    SpValue self = ns->lookup(SymSelf);
    SpComponent* comp = self.asComponent();
//    static SpValue result;
//    result.setInt(((TWidgetControl*)comp->widget)->Width);
//    return result;
    SpValue result;
    result.setInt(((TWidgetControl*)comp->widget)->Width);
    return SpValueResult(result);
}

SpValue& SpComponent::primSetWidth(SpValue& v)
{
    if(v.isInt()){
        SpValue n = getCurrentNS();
        SpNameSpace* ns = n.asNameSpace();
        SpValue self = ns->lookup(SymSelf);
        SpComponent* comp = self.asComponent();
        ((TWidgetControl*)comp->widget)->Width = v.getInt();
    }
    return TrueObject;
}

SpValue& SpComponent::primGetHeight()
{
    SpValue n = getCurrentNS();
    SpNameSpace* ns = n.asNameSpace();
    SpValue self = ns->lookup(SymSelf);
    SpComponent* comp = self.asComponent();
//    static SpValue result;
//    result.setInt(((TWidgetControl*)comp->widget)->Height);
//    return result;
    static SpValue result;
    result.setInt(((TWidgetControl*)comp->widget)->Height);
    return SpValueResult(result);
}

SpValue& SpComponent::primSetHeight(SpValue& v)
{
    if(v.isInt()){
        SpValue n = getCurrentNS();
        SpNameSpace* ns = n.asNameSpace();
        SpValue self = ns->lookup(SymSelf);
        SpComponent* comp = self.asComponent();
        ((TWidgetControl*)comp->widget)->Height = v.getInt();
    }
    return TrueObject;
}


// Parent
SpValue& SpComponent::primGetParent()
{
    SpValue n = getCurrentNS();
    SpNameSpace* ns = n.asNameSpace();
    SpValue self = ns->lookup(SymSelf);
    SpComponent* comp = self.asComponent();
//    static SpValue result;
//    result = comp->parentNameSpace;
//    return result;
    SpValue result;
    result = comp->parentNameSpace;
    return SpValueResult(result);
}

// Caption
SpValue& SpComponent::primGetCaption()
{
    SpValue n = getCurrentNS();
    SpNameSpace* ns = n.asNameSpace();
    SpValue self = ns->lookup(SymSelf);
    SpComponent* comp = self.asComponent();
//    static SpValue result;
//    result = comp->getCaption((TWidgetControl*)comp->widget);
//    return result;
    SpValue result;
    result = comp->getCaption((TWidgetControl*)comp->widget);
    return SpValueResult(result);
}

SpValue& SpComponent::primSetCaption(SpValue& v)
{
    if(v.isString()){
        SpValue n = getCurrentNS();
        SpNameSpace* ns = n.asNameSpace();
        SpValue self = ns->lookup(SymSelf);
        SpComponent* comp = self.asComponent();
        comp->setCaption((TWidgetControl*)comp->widget, v.toCStringWithEncoder());
    }
    return TrueObject;
}

// Align
SpValue& SpComponent::primGetAlign()
{
    SpValue n = getCurrentNS();
    SpNameSpace* ns = n.asNameSpace();
    SpValue self = ns->lookup(SymSelf);
    SpComponent* comp = self.asComponent();
//    static SpValue result;
//    result.setInt(((TWidgetControl*)comp->widget)->Align);
//    return result;
    SpValue result;
    result.setInt(((TWidgetControl*)comp->widget)->Align);
    return SpValueResult(result);
}

SpValue& SpComponent::primSetAlign(SpValue& v)
{
    if(v.isInt()){
        SpValue n = getCurrentNS();
        SpNameSpace* ns = n.asNameSpace();
        SpValue self = ns->lookup(SymSelf);
        SpComponent* comp = self.asComponent();
        SpInt i = v.getInt();
        if(i < alNone || alClient < i){
            throw SpException("illegal align");
        }
        ((TWidgetControl*)comp->widget)->Align = i;
    }
    return TrueObject;
}

//
//
//
//void SpComponent::after_creation(SpNameSpace* assoc, SpValue& parentNS, TWidgetControl* parent, TComponent* child)
void SpComponent::after_creation(SpNameSpace* assoc, SpValue& parentNS, TWidgetControl* parent, TWidgetControl* child)
{
    SpValue vtop    = assoc->lookup(SymTop);
    SpValue vleft   = assoc->lookup(SymLeft);
    SpValue vwidth  = assoc->lookup(SymWidth);
    SpValue vheight = assoc->lookup(SymHeight);
    SpValue valign  = assoc->lookup(SymAlign);

    SpInt top    = vtop.asInt();
    SpInt left   = vleft.asInt();
    SpInt width  = vwidth.asInt();
    SpInt height = vheight.asInt();
    SpInt align  = valign.asInt();

    if(parent != NULL){
        child->Parent = parent;
    }
    child->Top = top;
    child->Left = left;
    child->Width = width;
    child->Height = height;
    child->Align = align;

    //SpValue vcaption  = assoc->lookup(SymCaption);
    SpValue vcaption;
    try {
        vcaption = assoc->lookup1(SymCaption);
    } catch(SpCaptionException& e){
        vcaption = NilObject;
    }
    if(vcaption.isString()){
        setCaption(child, vcaption.toCStringWithEncoder());
    }

    parentNameSpace = parentNS;

    // call fun onCreate()
    SpValue onCreate = assoc->lookup(SymOnCreate);
    if(onCreate.isFunc()){
        SpFunc* f = onCreate.asFunc();
        (*f)(NilObject);
    }
}

SpValue& SpComponent::toString()
{
    SpString* str;

    str = new SpString("<a ");
    *str += typeString();
    *str += (">");
//    static SpValue s;
//    s.setNewObject(str);
//    return s;
  return SpObjectResult(str);
}

// init
static SpValue GetTop;
static SpValue SetTop;
static SpValue GetLeft;
static SpValue SetLeft;
static SpValue GetWidth;
static SpValue SetWidth;
static SpValue GetHeight;
static SpValue SetHeight;
static SpValue SpGetParent;
static SpValue GetCaption;
static SpValue SetCaption;
static SpValue GetAlign;
static SpValue SetAlign;

void SpComponent::initProperties(SpNameSpace* ns)
{
    // Top
    ns->internPrimProperty(SymTop, NilObject, GetTop, SetTop);
    // Left
    ns->internPrimProperty(SymLeft, NilObject, GetLeft, SetLeft);
    // Width
    ns->internPrimProperty(SymWidth, NilObject, GetWidth, SetWidth);
    // Height
    ns->internPrimProperty(SymHeight, NilObject, GetHeight, SetHeight);
    // Parent
    ns->internPrimProperty(SymParent, NilObject, SpGetParent, NilObject);
    // Caption
    ns->internPrimProperty(SymCaption, NilObject, GetCaption, SetCaption);
    // Align
    ns->internPrimProperty(SymAlign, NilObject, GetAlign, SetAlign);
}

void SpComponent::init()
{
    // set symbols
    SymTop.setNewObject(new SpSymbol("top"));
    SymLeft.setNewObject(new SpSymbol("left"));
    SymWidth.setNewObject(new SpSymbol("width"));
    SymHeight.setNewObject(new SpSymbol("height"));
    SymComponents.setNewObject(new SpSymbol("components"));
    SymTitle.setNewObject(new SpSymbol("title"));
    SymCaption.setNewObject(new SpSymbol("caption"));
    SymMake.setNewObject(new SpSymbol("make"));
    SymOnClick.setNewObject(new SpSymbol("onclick"));
    SymOnDblClick.setNewObject(new SpSymbol("ondblclick"));
    SymParent.setNewObject(new SpSymbol("parent"));;
    SymAlign.setNewObject(new SpSymbol("align"));
    SymText.setNewObject(new SpSymbol("text"));
    SymOnChange.setNewObject(new SpSymbol("onchange"));
    //SymAppend.setNewObject(new SpSymbol("append"));
    SymClear.setNewObject(new SpSymbol("clear"));
    SymCheckedP.setNewObject(new SpSymbol("checked?"));
    SymCanceledP.setNewObject(new SpSymbol("canceled?"));
    SymFilename.setNewObject(new SpSymbol("filename"));
    SymFilenames.setNewObject(new SpSymbol("filenames"));
    SymItems.setNewObject(new SpSymbol("items"));
    SymModifiedP.setNewObject(new SpSymbol("modified?"));
    SymMessage.setNewObject(new SpSymbol("message"));
    SymIndex.setNewObject(new SpSymbol("index"));
    SymCols.setNewObject(new SpSymbol("cols"));
    SymRows.setNewObject(new SpSymbol("rows"));
    SymCol.setNewObject(new SpSymbol("col"));
    SymRow.setNewObject(new SpSymbol("row"));
    SymTable.setNewObject(new SpSymbol("table"));
    SymHeader.setNewObject(new SpSymbol("header"));
    SymOnCreate.setNewObject(new SpSymbol("oncreate"));

    SpValue SymAlNone(new SpSymbol("alnone"));
    SpValue SymAlTop(new SpSymbol("altop"));
    SpValue SymAlBottom(new SpSymbol("albottom"));
    SpValue SymAlLeft(new SpSymbol("alleft"));
    SpValue SymAlRight(new SpSymbol("alright"));
    SpValue SymAlClient(new SpSymbol("alclient"));
    PMainNameSpace->internConst(SymAlNone, AlNone);
    PMainNameSpace->internConst(SymAlTop, AlTop);
    PMainNameSpace->internConst(SymAlBottom, AlBottom);
    PMainNameSpace->internConst(SymAlLeft, AlLeft);
    PMainNameSpace->internConst(SymAlRight, AlRight);
    PMainNameSpace->internConst(SymAlClient, AlClient);

    PComponentNameSpace = new SpNameSpace;
    ComponentNS.setNewObject(PComponentNameSpace);

    // set default top, left, width, height
    DefaultTop.setInt(0);
    PComponentNameSpace->internConst(SymTop, DefaultTop);
    DefaultLeft.setInt(0);
    PComponentNameSpace->internConst(SymLeft, DefaultLeft);
    DefaultWidth.setInt(50);
    PComponentNameSpace->internConst(SymWidth, DefaultWidth);
    DefaultHeight.setInt(20);
    PComponentNameSpace->internConst(SymHeight, DefaultHeight);
    // set default align to alNone
    PComponentNameSpace->internConst(SymAlign, AlNone);

    // init prims
    GetTop.setNewObject(new SpPrim0(primGetTop));
    SetTop.setNewObject(new SpPrim1(primSetTop));

    GetLeft.setNewObject(new SpPrim0(primGetLeft));
    SetLeft.setNewObject(new SpPrim1(primSetLeft));

    GetWidth.setNewObject(new SpPrim0(primGetWidth));
    SetWidth.setNewObject(new SpPrim1(primSetWidth));
    GetHeight.setNewObject(new SpPrim0(primGetHeight));
    SetHeight.setNewObject(new SpPrim1(primSetHeight));
    SpGetParent.setNewObject(new SpPrim0(primGetParent));
    GetCaption.setNewObject(new SpPrim0(primGetCaption));
    SetCaption.setNewObject(new SpPrim1(primSetCaption));
    GetAlign.setNewObject(new SpPrim0(primGetAlign));
    SetAlign.setNewObject(new SpPrim1(primSetAlign));
}

