/*
 * Programming Language SOOPY
 *   (Simple Object Oriented Programming sYstem)
 *
 * Copyright (C) 2002 SUZUKI Jun
 *
 * URL: http://sourceforge.jp/projects/soopy/
 * License: GPL(GNU General Public License)
 *
 *
 * $Id: Form.cpp,v 1.17 2004/05/10 09:58:17 randy Exp $
 */

//---------------------------------------------------------------------------

#include <clx.h>
#pragma hdrstop

#include "soopyg.h"

/*
 * class SpContainer
 */
void SpContainer::create_components(TWidgetControl* parent_control,
                                    SpValue& parent_NS,
                                    SpValue& vcomps)
{
    if(vcomps.isList()){
        SpList* list = vcomps.asList();
        SpNameSpace* assoc = parent_NS.asNameSpace();
        for(; list != NULL; list = list->next()){
            SpValue value = list->value();
            if(!value.isAssign()){
                throw SpException("not assignment (components:)");
            }
            SpAssign* a = value.asAssign();
            SpValue sym = a->place;
            SpValue v = a->val.eval();
            if(!sym.isSymbol()){
                throw SpException("not symbol (components:)");
            }
            SpNameSpace* ns2 = v.asNameSpace();
            SpValue f = ns2->lookup(SymMake);
            if(!f.isFunc()){
                throw SpException("not function (make)");
            }
            SpFunc* func = f.asFunc();
            SpValue aComp = (*func)(NilObject);
            if(!aComp.isComponent()){
                throw SpException("not component (make)");
            }
            SpComponent* aComponent = aComp.asComponent();
            aComponent->creation(parent_NS, parent_control);

            assoc->internConst(sym, v);
            ns2->parentNS = parent_NS;
        }
    }
/*
    if(vcomps.isNameSpace()){
        SpNameSpace* comps = vcomps.asNameSpace();
        SpNameSpace* assoc = parent_NS.asNameSpace();
        NSMap::iterator it = comps->begin();
        for(; it != comps->end(); it++){
            if(it->first.isNSKey()){
                NSKey* key = it->first.asNSKey();
                if(!(key->isNSPrimProperty() || key->isNSProperty() || key->isNSFunc() || key->isNSDataType())){
                    SpValue v = it->second;
                    SpNameSpace* ns2 = v.asNameSpace();
                    SpValue f = ns2->lookup(SymMake);
                    if(!f.isFunc()){
                        throw SpException("not function (make)");
                    }
                    SpFunc* func = f.asFunc();
                    SpValue aComp = (*func)(NilObject);
                    if(!aComp.isComponent()){
                        throw SpException("not component (make)");
                    }
                    SpComponent* aComponent = aComp.asComponent();
                    aComponent->creation(parent_NS, parent_control);

                    assoc->internConst(key->val, v);
                    ns2->parentNS = parent_NS;
                }
            }
        }
    }
*/
}

/*
 * class SpWindow
 */
bool SpWindow::app_running = false;

SpValue& SpWindow::getCaption(TWidgetControl* w)
{
//    static SpValue result;
//    result.setNewObject(new SpString(AnsiString(((TForm*)w)->Caption).c_str()));
//    return result;
  return SpObjectResult(new SpString(AnsiString(((TForm*)w)->Caption).c_str()));
}

void SpWindow::setCaption(TWidgetControl* w, const char* str)
{
    ((TForm*)w)->Caption = str;
}

void SpWindow::creation(SpValue& parentNS, TWidgetControl* parent)
{
    TForm* form;
    Application->CreateForm(__classid(TForm), &form);
    widget = form;
    SpNameSpace* assoc = ns.asNameSpace();
    SpValue vcomps = assoc->lookup(SymComponents);

    //after_creation(assoc, parentNS, parent, form);
    SpComponent::after_creation(assoc, parentNS, parent, form);

    SpValue self(this);
    assoc->internConst(SymSelf, self);

    initProperties(assoc); // SpComponent::initProperties
//    ((TSpForm*)widget)->initProperties();

    // create components
    create_components(form, ns, vcomps);
    form->Visible = true;
}

void SpWindow::run()
{
    if(app_running){
        throw SpException("can't run two application");
    }
    app_running = true;
    Application->Initialize();

    // create main form
    creation(NilObject, NULL);

    // run app
    try{
        Application->Run();
    }
    catch (SpException &exception){
        throw;
    }
    catch (Exception &exception){
        Application->ShowException(&exception);
    }
    catch (...){
        try{
           throw Exception("");
        }
        catch (Exception &exception){
            Application->ShowException(&exception);
        }
    }
    Application->Terminate();

    // release main form
    ((TForm*)widget)->Release();
    delete widget;

    app_running = false;
}

// primitives

SpValue& SpWindow::create_and_run()
{
    SpWindow* win = new SpWindow(getCurrentNS());
    SpValue taker(win);
    win->run();

//    static SpValue result;
//    result = taker;
//    return result;
  return SpValueResult(taker);
}

SpValue& SpWindow::make()
{
    SpWindow* win = new SpWindow(getCurrentNS());
    SpValue taker(win);
    win->creation(getCurrentNS(), NULL);

//    static SpValue result;
//    result = taker;
//    return result;
  return SpValueResult(taker);
}


// init std_window
void SpWindow::init()
{
    // set namespace to symbol 'std_window'.
    PWindowNameSpace = new SpNameSpace(PComponentNameSpace->getMap());
    WindowNS.setNewObject(PWindowNameSpace);
    SpValue SymStdWindow(new SpSymbol("std_window"));
    PMainNameSpace->internConst(SymStdWindow, WindowNS);

    // set top, left, width, height
    SpValue temp;
    temp.setInt(10);
    PWindowNameSpace->internConst(SymTop, temp);
    temp.setInt(10);
    PWindowNameSpace->internConst(SymLeft, temp);
    temp.setInt(100);
    PWindowNameSpace->internConst(SymWidth, temp);
    temp.setInt(100);
    PWindowNameSpace->internConst(SymHeight, temp);

    PWindowNameSpace->internConst(SymComponents, NilObject);

    SpValue SymRun(new SpSymbol("run"));
    SpValue PrimRun(new SpPrim0(create_and_run));
    PWindowNameSpace->internFunc(SymRun, PrimRun);

    SpValue PrimMake(new SpPrim0(make));
    PWindowNameSpace->internFunc(SymMake, PrimMake);
}


