/*
 * Programming Language SOOPY
 *   (Simple Object Oriented Programming sYstem)
 *
 * Copyright (C) 2002 SUZUKI Jun
 *
 * URL: http://sourceforge.jp/projects/soopy/
 * License: GPL(GNU General Public License)
 *
 *
 * $Id: ListBox.cpp,v 1.5 2004/05/10 09:58:17 randy Exp $
 */

#include <clx.h>
#pragma hdrstop

#include "soopyg.h"

/*
 * class TSpListBox
 */

void __fastcall TSpListBox::Click(void)
{
    TWinControl::Click();        // nȟĂяoȂǕWIȏs
    SpValue onClick  = ns->lookup(SymOnClick);
    if(onClick.isFunc()){
        SpFunc* f = onClick.asFunc();
        (*f)(NilObject);
    }
}

void __fastcall TSpListBox::Changed(void)
{
    TCustomListBox::Changed();        // nȟĂяoȂǕWIȏs
    SpValue onChange  = ns->lookup(SymOnChange);
    if(onChange.isFunc()){
        SpFunc* f = onChange.asFunc();
        (*f)(NilObject);
    }
}


/*
 * class SpListBox
 */

SpValue& SpListBox::make()
{
    SpListBox* box = new SpListBox(getCurrentNS());
//    static SpValue result;
//    result.setNewObject(box);
//    return result;
  return SpObjectResult(box);
}

// Caption
SpValue& SpListBox::getCaption(TWidgetControl* w)
{
    throw SpCaptionException("can't get listbox.caption");
}

void SpListBox::setCaption(TWidgetControl* w, const char* str)
{
    throw SpCaptionException("can't set listbox.caption");
}

void SpListBox::creation(SpValue& parentNS, TWidgetControl* parent)
{
    SpNameSpace* assoc = ns.asNameSpace();
    widget = new TSpListBox(parent, assoc);

    SpComponent::after_creation(assoc, parentNS, parent, (TWidgetControl*)widget);

    // set self
    SpValue self(this);
    assoc->internConst(SymSelf, self);

    // set text
//    SpValue vtext  = assoc->lookup(SymText);
//    if(vtext.isString()){
//        ((TListBox*)widget)->Text = vtext.toCStringWithEncoder();
//    }

    // set items
    SpValue vitems = assoc->lookup(SymItems);
    if(vitems.isList()){
        while(!vitems.isNil()){
            SpList* ptr = vitems.asList();
            ((TListBox*)widget)->Items->Add(ptr->value().toCStringWithEncoder());
            vitems = ptr->nextList();
        }
    }

    initProperties(assoc); // SpComponent::initProperties
}

// primitives
SpValue& SpListBox::primGetText()
{
    SpValue n = getCurrentNS();
    SpNameSpace* ns = n.asNameSpace();
    SpValue self = ns->lookup(SymSelf);
    SpComponent* comp = self.asComponent();
    TListBox* list = (TListBox*)comp->widget;
    if(list->ItemIndex < 0){
        return NilObject;
    }
//    static SpValue result;
//    result.setNewObject(new SpString(list->Items->Strings[list->ItemIndex].c_str()));
//    return result;
  return SpObjectResult(new SpString(list->Items->Strings[list->ItemIndex].c_str()));
}

/*
SpValue& SpListBox::primSetText(SpValue& v)
{
    if(v.isString()){
        SpValue n = getCurrentNS();
        SpNameSpace* ns = n.asNameSpace();
        SpValue self = ns->lookup(SymSelf);
        SpComponent* comp = self.asComponent();
        ((TListBox*)comp->widget)->Text = v.toCStringWithEncoder();
    }
    return TrueObject;
}
*/

// init
static SpValue GetText;
//static SpValue SetText;

void SpListBox::initProperties(SpNameSpace* pNS)
{
    SpComponent::initProperties(pNS);
    // Text
    //pNS->internPrimProperty(SymText, NilObject, GetText, SetText);
    pNS->internPrimProperty(SymText, NilObject, GetText, NilObject);
}

void SpListBox::init()
{
    // set namespace to symbol 'std_listBox'.
    PListBoxNameSpace = new SpNameSpace(PComponentNameSpace->getMap());
    ListBoxNS.setNewObject(PListBoxNameSpace);
    SpValue SymStdListBox(new SpSymbol("std_listbox"));
    PMainNameSpace->internConst(SymStdListBox, ListBoxNS);

    // set default top, left, width, height
    SpValue I;
    I.setInt(80);
    PListBoxNameSpace->internConst(SymWidth, I);
    I.setInt(97);
    PListBoxNameSpace->internConst(SymHeight, I);

    GetText.setNewObject(new SpPrim0(primGetText));
//    SetText.setNewObject(new SpPrim1(primSetText));

    SpValue PrimMake(new SpPrim0(make));
    PListBoxNameSpace->internFunc(SymMake, PrimMake);
}

